/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class MEResourceBundle
extends ResourceBundle {
    private Locale locale;
    private String resourceBundleName;
    private ResourceBundle resBundle;
    private String tostring;

    public MEResourceBundle(String resBundleName) {
        this(resBundleName, Locale.getDefault(), null);
    }

    public MEResourceBundle(String resBundleName, Locale locale) {
        this(resBundleName, locale, null);
    }

    public MEResourceBundle(String resBundleName, Locale locale, ClassLoader classloader) {
        Trace trace = Trace.getInstance("MI/API/Services");
        if (trace.isLogging(90)) {
            trace.log(90, "MEResourceBundle:Constructor: Create MEResourceBundle({0}, {1}, {2})", resBundleName, locale, classloader);
        }
        this.locale = locale == null ? Locale.getDefault() : locale;
        if (classloader == null) {
            classloader = this.getClass().getClassLoader();
        }
        if (trace.isLogging(90)) {
            trace.log(90, "MEResourceBundle:Constructor: Use classloader {0}", (Object)classloader);
        }
        if (resBundleName != null) {
            this.resBundle = this.findResourceBundle(resBundleName, this.locale, classloader);
            this.resourceBundleName = this.resBundle != null ? resBundleName : null;
        } else {
            this.resBundle = null;
            this.resourceBundleName = null;
        }
        if (this.resBundle != null) {
            String localestr = this.getLocale().toString();
            String rbn = this.getResourceBundleName();
            StringBuffer sb = new StringBuffer(50 + (rbn != null ? rbn.length() : 0) + localestr.length());
            this.tostring = sb.append("MEResourceBundle with name ").append(rbn).append(" and preferred locale ").append(localestr).toString();
        } else {
            this.tostring = "MEResourceBundle without a resource bundle";
        }
    }

    public MEResourceBundle() {
        this(null, Locale.getDefault());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public Object handleGetObject(String key) {
        Object result = null;
        if (this.resBundle != null && key != null) {
            try {
                result = this.resBundle.getObject(key);
            }
            catch (MissingResourceException missing) {
                Trace.getInstance("MI/API/Services").log(70, "Cannot find resource key {0} within {1}", (Object)key, (Object)this.resourceBundleName);
            }
            catch (Exception ex) {
                Trace.getInstance("MI/API/Services").logException(60, "Exception while trying to get value for key {0} out of resource rundle {1}", new Object[]{key, this.resourceBundleName}, ex, true);
            }
        }
        if (result == null) {
            result = key == null ? new StringBuffer(10).append('(').append("NO KEY").append(')').toString() : new StringBuffer(key.length() + 2).append('(').append(key).append(')').toString();
        }
        return result;
    }

    public Enumeration getKeys() {
        Enumeration<Object> result = new Vector(0).elements();
        if (this.resBundle != null) {
            result = this.resBundle.getKeys();
        }
        return result;
    }

    public String toString() {
        return this.tostring;
    }

    private ResourceBundle findResourceBundle(String resBundleName, Locale locale, ClassLoader classloader) {
        Trace trace = Trace.getInstance("MI/API/Services");
        String localeName = "_" + locale.toString();
        String rbName = resBundleName.replace('.', '/');
        InputStream in = null;
        while (in == null) {
            in = this.getInputstreamForResourceBundle(rbName, localeName, classloader);
            if (in == null && localeName.length() == 0) {
                AppLog.getInstance("MI/API/Services").log(60, "cannot find resource bundle {0}_{1}", new Object[]{resBundleName, locale});
                return null;
            }
            if (in != null) continue;
            int p = localeName.lastIndexOf("_");
            localeName = p <= 0 ? "" : localeName.substring(0, p);
        }
        try {
            MEPropertyResourceBundle meprop = new MEPropertyResourceBundle(in);
            if (localeName.length() == 0) {
                trace.log(90, "CREATED MEPropertyResourceBundle " + meprop + " for bundleName: " + resBundleName + " without any locale!");
            } else {
                trace.log(90, "CREATED MEPropertyResourceBundle " + meprop + " for bundleName: " + resBundleName + " with Locale: " + localeName);
                try {
                    InputStream input = this.getInputstreamForResourceBundle(rbName, "", classloader);
                    if (in != null) {
                        meprop.setParentBundle(new MEPropertyResourceBundle(input));
                        trace.log(90, "CREATED parent MEPropertyResourceBundle for child bundle: " + meprop + " using bundle name: " + resBundleName);
                    } else {
                        trace.log(60, "no parent MEPropertyResourceBundle found for bundle: " + meprop + " using bundle name: " + resBundleName);
                    }
                }
                catch (IOException exception) {
                    AppLog.getInstance("MI/API/Services").logException(70, "Cannot create parent MEPropertyResourceBundle for child bundle: " + meprop + " using bundle name: " + resBundleName, exception, true);
                }
            }
            return meprop;
        }
        catch (IOException ex) {
            AppLog.getInstance("MI/API/Services").logException(60, "Exception while loading Resource bundle {0}", new Object[]{ex.getClass().getName()}, ex, false);
            return null;
        }
    }

    private InputStream getInputstreamForResourceBundle(String resBundleName, String localeName, ClassLoader classloader) {
        InputStream in = null;
        in = classloader == null ? ClassLoader.getSystemResourceAsStream(resBundleName + localeName + ".properties") : classloader.getResourceAsStream(resBundleName + localeName + ".properties");
        return in;
    }

    class MEPropertyResourceBundle
    extends PropertyResourceBundle {
        public MEPropertyResourceBundle(InputStream in) throws IOException {
            super(in);
        }

        public void setParentBundle(ResourceBundle b) {
            this.setParent(b);
        }
    }
}

