/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.Log;
import com.sap.ip.me.api.services.StreamTimeout;
import com.sap.ip.me.api.services.UrlConnectionTest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IOUtils {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF8";
    static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
    private static final String LOG_MESSAGE_PREFIX_START = "Http Connection start";
    private static final String LOG_MESSAGE_PREFIX_END = "Http Connection end";
    private static Trace trace = Trace.getInstance("MI/API/Services");
    private static long timeBetweenStreamCopy = 0L;

    public static final String utf8AndUrlEncode(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer sbuf = new StringBuffer(len * 3);
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
            } else if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
            } else if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
            } else if (ch == ' ') {
                sbuf.append('+');
            } else if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                sbuf.append(ch);
            } else if (ch <= '\u007f') {
                sbuf.append(hex[ch]);
            } else if (ch <= '\u07ff') {
                sbuf.append(hex[0xC0 | ch >> 6]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            } else {
                sbuf.append(hex[0xE0 | ch >> 12]);
                sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static final String utf8AndUrlDecode(byte[] source, int offset, int len) {
        if (source == null) {
            return null;
        }
        if (len <= 0) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer(len);
        int ch = -1;
        int sumb = 0;
        int i = offset;
        int more = -1;
        while (i < len) {
            int b;
            char c = (char)source[i];
            ch = c;
            switch (c) {
                case '%': {
                    ch = (char)source[++i];
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = (char)source[++i];
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case '+': {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more == 0) {
                    sbuf.append((char)sumb);
                }
            } else if ((b & 0x80) == 0) {
                sbuf.append((char)b);
            } else if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
            } else if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
            } else if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
            } else if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
            } else {
                sumb = b & 1;
                more = 5;
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static void httpPost(String sUrl, int len, InputStream in, OutputStream out, boolean compressed) throws HttpConnectionException {
        try {
            URL url = new URL(sUrl);
            IOUtils.isConnectable(url);
            URLConnection urlC = url.openConnection();
            urlC.setRequestProperty("content-type", "application/binary;charset=UTF-8");
            urlC.setRequestProperty("content-length", Integer.toString(len, 10));
            long timeout = Configuration.getInstance().getLong("MobileEngine.Sync.WaitForResultsTimeout", -1L);
            if (compressed) {
                if (trace.isLogging(70)) {
                    trace.log(70, "GzipDataCompression: Gzip data compression is switched on");
                }
                urlC.setRequestProperty("Accept-Encoding", "compress, gzip");
                urlC.setDoOutput(true);
                urlC.setDoInput(true);
                GZIPOutputStream gzipout = new GZIPOutputStream(urlC.getOutputStream());
                trace.log(80, LOG_MESSAGE_PREFIX_START);
                IOUtils.copyStreams(in, gzipout);
                trace.log(80, LOG_MESSAGE_PREFIX_END);
                GZIPInputStream gzip = null;
                if (timeout != -1L) {
                    InputStream ins = IOUtils.getInputStreamFromURLConnection(urlC, timeout);
                    gzip = new GZIPInputStream(ins);
                } else {
                    gzip = new GZIPInputStream(urlC.getInputStream());
                }
                trace.log(80, LOG_MESSAGE_PREFIX_START);
                IOUtils.copyStreams(gzip, out);
                trace.log(80, LOG_MESSAGE_PREFIX_END);
            } else {
                if (trace.isLogging(70)) {
                    trace.log(70, "GzipDataCompression: Gzip data compression is switched off");
                }
                urlC.setDoOutput(true);
                urlC.setDoInput(true);
                trace.log(80, LOG_MESSAGE_PREFIX_START);
                IOUtils.copyStreams(in, urlC.getOutputStream());
                trace.log(80, LOG_MESSAGE_PREFIX_END);
                trace.log(80, LOG_MESSAGE_PREFIX_START);
                InputStream ins = null;
                ins = timeout != -1L ? IOUtils.getInputStreamFromURLConnection(urlC, timeout) : urlC.getInputStream();
                IOUtils.copyStreams(ins, out);
                trace.log(80, LOG_MESSAGE_PREFIX_END);
            }
        }
        catch (HttpConnectionException connex) {
            throw connex;
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/API/Services").log(60, "An Exception ({0}) occurred while http-post: {1}", (Object)ex.getClass().getName(), (Object)IOUtils.asterixForPassword(ex.getMessage()));
            throw new HttpConnectionException("HttpConnectionException while http-post.");
        }
    }

    public static void httpPost(String sUrl, int len, InputStream in, OutputStream out) throws HttpConnectionException {
        IOUtils.httpPost(sUrl, len, in, out, false);
    }

    public static void httpPost(String sUrl, String source, String destination, boolean compressed) throws HttpConnectionException {
        if (sUrl == null) {
            throw new HttpConnectionException("Cannot post to null url", null);
        }
        if (trace.isLogging(90)) {
            trace.log(90, "do httpPost {0} via {1}. Result saved within {2}.", IOUtils.asterixForPassword(sUrl), source, destination);
        }
        try {
            File file = new File(source);
            IOUtils.httpPost(sUrl, (int)file.length(), new FileInputStream(file), new FileOutputStream(destination), compressed);
        }
        catch (HttpConnectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/API/Services").log(50, "An Exception ({0}) occurred while http-post: {1}", (Object)ex.getClass().getName(), (Object)IOUtils.asterixForPassword(ex.getMessage()));
            throw new HttpConnectionException("HttpConnectionException while http-post: " + ex.getMessage());
        }
    }

    public static void httpPost(String sUrl, String source, String destination) throws HttpConnectionException {
        IOUtils.httpPost(sUrl, source, destination, false);
    }

    public static void httpGet(String sUrl, String destination, boolean compressed) throws HttpConnectionException {
        if (trace.isLogging(90)) {
            trace.log(90, "do httpGet from {0}. Result saved within {1}.", (Object)IOUtils.asterixForPassword(sUrl), (Object)destination);
        }
        try {
            IOUtils.httpGet(sUrl, new FileOutputStream(destination), compressed);
        }
        catch (HttpConnectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/API/Services").log(50, "An Exception ({0}) occurred while http-get: {1}", (Object)ex.getClass().getName(), (Object)IOUtils.asterixForPassword(ex.getMessage()));
            throw new HttpConnectionException("HttpConnectionException while http-get: " + ex.getMessage());
        }
    }

    public static void httpGet(String sUrl, String destination) throws HttpConnectionException {
        IOUtils.httpGet(sUrl, destination, false);
    }

    public static void httpGet(String sUrl, OutputStream out, boolean compressed) throws HttpConnectionException {
        try {
            URL url = new URL(sUrl);
            IOUtils.isConnectable(url);
            if (compressed) {
                URLConnection urlC = url.openConnection();
                GZIPInputStream gzipin = new GZIPInputStream(urlC.getInputStream());
                IOUtils.copyStreams(gzipin, out);
            } else {
                URLConnection urlC = url.openConnection();
                IOUtils.copyStreams(urlC.getInputStream(), out);
            }
        }
        catch (HttpConnectionException connex) {
            throw connex;
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/API/Services").log(60, "An Exception ({0}) occurred while http-get: {1}", (Object)ex.getClass().getName(), (Object)IOUtils.asterixForPassword(ex.getMessage()));
            throw new HttpConnectionException("HttpConnectionException while http-get: " + ex.getMessage());
        }
    }

    public static void httpGet(String sUrl, OutputStream out) throws HttpConnectionException {
        IOUtils.httpGet(sUrl, out, false);
    }

    public static void isConnectable(URL url) throws HttpConnectionException {
        int ct = Configuration.getInstance().getInt("MobileEngine.Sync.ConnectionTimeout", -1);
        if (ct != -1) {
            UrlConnectionTest urlTest = UrlConnectionTest.getInstance(url);
            urlTest.runTest();
            if (urlTest.wasSuccessfull()) {
                if (trace.isLogging(80)) {
                    trace.log(80, "URL connection test was successfull!!!");
                }
            } else {
                throw new HttpConnectionException(urlTest.getLastMessage());
            }
        }
    }

    public static void copyStreams(InputStream in, OutputStream out) throws IOException {
        IOUtils.copyStreams(in, out, true, true);
    }

    public static void copyStreams(InputStream in, OutputStream out, boolean closeInputStream, boolean closeOutputStream) throws IOException {
        if (Configuration.getInstance().getLong("MobileEngine.Sync.WaitForResultsTimeout", -1L) > -1L) {
            IOUtils.copyStreamsWithTimeout(in, out, closeInputStream, closeOutputStream);
        } else {
            IOUtils.copyStreamsWithoutTimeout(in, out, closeInputStream, closeOutputStream);
        }
    }

    public static File extractZipFile(ZipFile zip, ZipEntry sourceEntry, String targetFilename) throws IOException {
        if (trace.isLogging(90)) {
            trace.log(90, "Extract ''{0}'' from ''{1}'' to ''{2}'' ...", sourceEntry.getName(), zip.getName(), targetFilename);
        }
        File tempFile = new File(targetFilename);
        File dir = new File(tempFile.getParent());
        dir.mkdirs();
        InputStream is = zip.getInputStream(sourceEntry);
        BufferedInputStream bis = new BufferedInputStream(is);
        FileOutputStream fos = new FileOutputStream(tempFile.getAbsolutePath());
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        int sz = (int)sourceEntry.getSize();
        int ln = 0;
        int N = 512;
        byte[] buf = new byte[512];
        while (sz > 0 && (ln = bis.read(buf, 0, Math.min(512, sz))) != -1) {
            bos.write(buf, 0, ln);
            sz -= ln;
        }
        bos.close();
        bis.close();
        return tempFile;
    }

    public static void serializeVectorToFile(File file, Vector vector) {
        IOUtils.serializeObjectToFile(file, vector);
    }

    public static void saveHashtableToDirectory(File directory, Hashtable hashtable) {
        IOUtils.deleteDirectoryRecursively(directory);
        Enumeration keyEnum = hashtable.keys();
        int i = 0;
        while (keyEnum.hasMoreElements()) {
            String fileName = Integer.toString(i);
            Object key = keyEnum.nextElement();
            File file = new File(directory, fileName + ".key");
            IOUtils.serializeObjectToFile(file, key);
            file = new File(directory, fileName + ".value");
            IOUtils.serializeObjectToFile(file, hashtable.get(key));
            ++i;
        }
    }

    public static Hashtable readHashtableFromDirectory(File directory) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (directory.exists()) {
            int i = 0;
            boolean found = true;
            while (found) {
                String fileName = Integer.toString(i);
                File keyFile = new File(directory, fileName + ".key");
                if (keyFile.exists()) {
                    Object value;
                    File valueFile;
                    Object key = IOUtils.readSerializedObjectFromFile(keyFile);
                    if (key != null && (valueFile = new File(directory, fileName + ".value")).exists() && (value = IOUtils.readSerializedObjectFromFile(valueFile)) != null) {
                        hashtable.put(key, value);
                    }
                } else {
                    found = false;
                }
                ++i;
            }
        }
        return hashtable;
    }

    /*
     * Loose catch block
     */
    public static void serializeObjectToFile(File file, Object object) {
        block13: {
            if (file == null || object == null) {
                return;
            }
            FileOutputStream fs = null;
            ObjectOutputStream objstream = null;
            File parent = new File(file.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
            fs = new FileOutputStream(file.getAbsolutePath());
            objstream = new ObjectOutputStream(fs);
            objstream.writeObject(object);
            Object var7_5 = null;
            try {
                if (objstream != null) {
                    objstream.close();
                }
                break block13;
            }
            catch (IOException e2) {}
            break block13;
            {
                catch (IOException e) {
                    AppLog.getInstance("MI/API/Services").logException(50, "Problems while saving {0}", new Object[]{file.getAbsolutePath()}, e, true);
                    Object var7_6 = null;
                    try {
                        if (objstream != null) {
                            objstream.close();
                        }
                        break block13;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (objstream != null) {
                        objstream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static Vector readSerializedVectorFromFile(File file) {
        Vector deserializedVector = null;
        try {
            deserializedVector = (Vector)IOUtils.readSerializedObjectFromFile(file);
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/API/Services").logException(ex);
        }
        if (deserializedVector == null) {
            deserializedVector = new Vector();
        }
        return deserializedVector;
    }

    /*
     * Loose catch block
     */
    public static Object readSerializedObjectFromFile(File file) {
        Object deserialized;
        block14: {
            deserialized = null;
            if (file == null || !file.exists()) {
                AppLog.getInstance("MI/API/Services").log(60, "Serialized object can not be read because the file {0} does not exist", (Object)(file == null ? "(null)" : file.getAbsolutePath()));
                return deserialized;
            }
            FileInputStream fs = null;
            ObjectInputStream objstream = null;
            fs = new FileInputStream(file.getAbsolutePath());
            objstream = new ObjectInputStream(fs);
            try {
                deserialized = objstream.readObject();
            }
            catch (ClassNotFoundException c) {
                AppLog.getInstance("MI/API/Services").logException(50, "Object can not be deserilized because of Class Loader problems", c, false);
                file.delete();
                deserialized = null;
            }
            Object var6_6 = null;
            try {
                if (objstream != null) {
                    objstream.close();
                }
                break block14;
            }
            catch (IOException e) {}
            break block14;
            {
                catch (Exception ex) {
                    AppLog.getInstance("MI/API/Services").logException(ex);
                    Object var6_7 = null;
                    try {
                        if (objstream != null) {
                            objstream.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (objstream != null) {
                        objstream.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return deserialized;
    }

    public static void copyFile(File source, File target, int bufferLength) throws IOException {
        IOUtils.fileCopy(source, target, bufferLength);
    }

    public static boolean deleteDirectoryRecursively(File dir) {
        return IOUtils.deleteDirectoryRecursively(dir, true);
    }

    public static boolean deleteDirectoryRecursively(File dir, boolean deleteRootFolder) {
        if (dir == null) {
            return true;
        }
        boolean isdeleted = false;
        if (dir.isFile()) {
            isdeleted = dir.delete();
            if (!isdeleted) {
                Trace t = Trace.getInstance("MI/API/Services");
                t.log(60, "Cannot delete file: " + dir.getAbsolutePath());
            }
            return isdeleted;
        }
        if (dir.exists()) {
            int max;
            String[] elements = dir.list();
            boolean result = true;
            int n = max = elements == null ? 0 : elements.length;
            if (elements != null) {
                int i = 0;
                while (i < max) {
                    result = result && IOUtils.deleteDirectoryRecursively(new File(dir, elements[i]), true);
                    ++i;
                }
            }
            if (!(isdeleted = deleteRootFolder ? dir.delete() : true)) {
                Trace t = Trace.getInstance("MI/API/Services");
                t.log(60, "Cannot delete folder: " + dir.getAbsolutePath());
            }
            result = result && isdeleted;
            return result;
        }
        return false;
    }

    public static long getTimeBetweenStreamCopy() {
        return timeBetweenStreamCopy;
    }

    public static void resetTimeBetweenStreamCopy() {
        timeBetweenStreamCopy = 0L;
    }

    public static boolean moveFileToDirectory(File sourceFile, File targetDirectory) {
        Trace t;
        if (sourceFile == null || targetDirectory == null || targetDirectory.isFile() || sourceFile.isDirectory()) {
            return false;
        }
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        File targetFile = new File(targetDirectory, sourceFile.getName());
        boolean result = true;
        if (targetFile.exists() && !(result = targetFile.delete())) {
            t = Trace.getInstance("MI/API/Services");
            t.log(60, "Cannot delete target file (moveFileToDir): " + targetFile.getAbsolutePath());
        }
        if (!(result = sourceFile.renameTo(targetFile))) {
            t = Trace.getInstance("MI/API/Services");
            t.log(60, "Move failed from {0} to {1}", (Object)sourceFile.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
        }
        return result;
    }

    static String asterixForPassword(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(source.length() + 10);
        String pwKey = "password=";
        int p = source.indexOf(pwKey);
        int q = -1;
        int start = 0;
        while (p >= 0) {
            q = source.indexOf("&", p);
            sb.append(source.substring(start, p + pwKey.length()));
            sb.append("**********");
            start = q >= 0 ? q : source.length();
            p = source.indexOf(pwKey, start);
        }
        sb.append(source.substring(start));
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void copyStreamsWithTimeout(InputStream in, OutputStream out, boolean closeInputStream, boolean closeOutputStream) throws IOException {
        int i;
        long starttime = System.currentTimeMillis();
        StreamTimeout streamTimeOut = new StreamTimeout();
        streamTimeOut.setInputStream(in);
        streamTimeOut.setFinished(false);
        Thread timeOutWatcher = new Thread(streamTimeOut);
        timeOutWatcher.start();
        byte[] buffer = new byte[512];
        while ((i = in.read(buffer)) >= 0) {
            void var9_8;
            streamTimeOut.increaseTimeSlept(0L);
            out.write(buffer, 0, (int)var9_8);
        }
        streamTimeOut.setFinished(true);
        if (in != null) {
            in.close();
        }
        if (out != null) {
            out.flush();
            out.close();
        }
        IOUtils.addTimeBetweenStreamCopy(System.currentTimeMillis() - starttime);
        try {
            timeOutWatcher.join(500L);
        }
        catch (InterruptedException e) {
            Log.logException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void copyStreamsWithoutTimeout(InputStream in, OutputStream out, boolean closeInputStream, boolean closeOutputStream) throws IOException {
        int i;
        long starttime = System.currentTimeMillis();
        byte[] buffer = new byte[512];
        while ((i = in.read(buffer)) >= 0) {
            void var7_6;
            out.write(buffer, 0, (int)var7_6);
        }
        if (in != null && closeInputStream) {
            in.close();
        }
        if (out != null) {
            out.flush();
            if (closeOutputStream) {
                out.close();
            }
        }
        IOUtils.addTimeBetweenStreamCopy(System.currentTimeMillis() - starttime);
    }

    private static void addTimeBetweenStreamCopy(long addTimeBetweenStreamCopy) {
        timeBetweenStreamCopy += addTimeBetweenStreamCopy;
    }

    private static InputStream getInputStreamFromURLConnection(URLConnection urlC, long timeout) throws IOException {
        URLInputStreamFetcher t = new URLInputStreamFetcher(urlC);
        long sleepingtime = timeout / 50L;
        if (trace.isLogging(90)) {
            trace.log(90, "Sleeping interval to wait for Mobile Infrastructure Server to respond is" + sleepingtime / 1000L + " seconds");
        }
        t.start();
        for (int tries = 0; tries < 50; ++tries) {
            try {
                if (!t.doOneMoreTime()) break;
                Thread.sleep(sleepingtime);
                continue;
            }
            catch (InterruptedException inex) {
                AppLog.getInstance("MI/API/Services").logException(inex);
                break;
            }
        }
        t.setStopIndicator(true);
        InputStream ins = t.getInputStreamFromURL();
        return ins;
    }

    /*
     * WARNING - void declaration
     */
    private static void fileCopy(File sourceFile, File targetFile, int buffersize) throws IOException {
        IOException e22;
        FileOutputStream to;
        block21: {
            if (!sourceFile.exists()) {
                IOUtils.abort("IOUtils.fileCopy: no such source file: ");
            }
            if (!sourceFile.isFile()) {
                IOUtils.abort("IOUtils.fileCopy: can't copy directory: ");
            }
            if (!sourceFile.canRead()) {
                IOUtils.abort("IOUtils.fileCopy: source file is unreadable: ");
            }
            if (targetFile.isDirectory()) {
                targetFile = new File(targetFile, sourceFile.getName());
            } else {
                File dir;
                String parent = targetFile.getParent();
                if (parent == null) {
                    parent = Configuration.getInstallationDirectory();
                }
                if (!(dir = new File(parent)).exists()) {
                    dir.mkdirs();
                }
                if (dir.isFile()) {
                    IOUtils.abort("IOUtils.fileCopy: destination is not a directory: " + parent);
                }
                if (!dir.canWrite()) {
                    IOUtils.abort("IOUtils.fileCopy: destination directory is unwriteable: " + parent);
                }
            }
            FileInputStream from = null;
            to = null;
            try {
                int bytes_read;
                from = new FileInputStream(sourceFile);
                to = new FileOutputStream(targetFile);
                byte[] buffer = new byte[buffersize];
                while ((bytes_read = from.read(buffer)) != -1) {
                    void var6_6;
                    to.write(buffer, 0, (int)var6_6);
                }
                Object var8_7 = null;
                if (from == null) break block21;
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var8_8 = null;
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                from.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException e22) {}
        }
    }

    private static void abort(String msg) throws IOException {
        throw new IOException(msg);
    }

    private static class URLInputStreamFetcher
    extends Thread {
        private InputStream is = null;
        private URLConnection uc = null;
        private boolean stopIndicator = false;
        private boolean oneMoreTime = true;

        public URLInputStreamFetcher(URLConnection uc) {
            this.uc = uc;
        }

        public void setStopIndicator(boolean flag) {
            this.stopIndicator = flag;
        }

        public void run() {
            while (!this.stopIndicator) {
                try {
                    this.is = this.uc.getInputStream();
                    this.setStopIndicator(true);
                    this.oneMoreTime = false;
                }
                catch (IOException ioex) {
                    AppLog.getInstance("MI/API/Services").logException(ioex);
                    this.setStopIndicator(true);
                    this.oneMoreTime = false;
                }
            }
        }

        public InputStream getInputStreamFromURL() throws IOException {
            if (this.is == null) {
                throw new IOException("No InputStream available from: " + this.uc.getURL().toExternalForm());
            }
            return this.is;
        }

        public boolean doOneMoreTime() {
            return this.oneMoreTime;
        }
    }
}

