/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatter {
    private static final Locale locale = Locale.getDefault();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", locale);
    private static final SimpleDateFormat dateFormatABAP;
    private static final SimpleDateFormat timeFormatABAP;

    public static synchronized Date getDate(String date) throws ParseException {
        return dateFormat.parse(date);
    }

    public static synchronized String getDate(Date date) {
        return dateFormat.format(date);
    }

    public static String getCurrentDate() {
        return DateFormatter.getDate(new Date());
    }

    public static synchronized String getDateABAP(Date date) {
        return dateFormatABAP.format(date);
    }

    public static String getCurrentDateABAP() {
        return DateFormatter.getDateABAP(new Date());
    }

    public static synchronized String getTimeABAP(Date date) {
        return timeFormatABAP.format(date);
    }

    public static String getCurrentTimeABAP() {
        return DateFormatter.getTimeABAP(new Date());
    }

    static {
        dateFormat.setTimeZone(TimeZone.getDefault());
        dateFormatABAP = new SimpleDateFormat("yyyyMMdd", locale);
        dateFormatABAP.setTimeZone(TimeZone.getDefault());
        timeFormatABAP = new SimpleDateFormat("HHmmss", locale);
        timeFormatABAP.setTimeZone(TimeZone.getDefault());
    }
}

