/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateConverter {
    private static final SimpleDateFormat SQLDATEFORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat SQLTIMEFORMATTER = new SimpleDateFormat("HH:mm:ss");
    public static final int DEFAULTYEAR = 1970;
    public static final int DEFAULTMONTH = 0;
    public static final int DEFAULTDAY = 1;
    public static final int DEFAULTHOUR = 0;
    public static final int DEFAULTMINUTE = 0;
    public static final int DEFAULTSECOND = 0;
    public static final int DEFAULTMILLISECOND = 0;
    public static final Calendar INIT_CALENDAR = DateConverter.createInitializedCalendar();

    public static java.sql.Date dateToSqlDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static Time dateToSqlTime(Date date) {
        if (date == null) {
            return null;
        }
        return new Time(date.getTime());
    }

    public static Date sqlTimeToDate(Time time) {
        if (time == null) {
            return null;
        }
        return new Date(time.getTime());
    }

    public static Date sqlDateToDate(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public static Calendar sqlDateTimeToCalendar(java.sql.Date date, Time time, TimeZone timeZone, Locale locale) {
        if (date == null && time == null) {
            return null;
        }
        Calendar calDate = null;
        if (timeZone == null && locale == null) {
            calDate = Calendar.getInstance();
            timeZone = TimeZone.getDefault();
        } else if (timeZone == null) {
            calDate = Calendar.getInstance(locale);
            timeZone = TimeZone.getDefault();
        } else {
            calDate = locale == null ? Calendar.getInstance(timeZone) : Calendar.getInstance(timeZone, locale);
        }
        SQLTIMEFORMATTER.setTimeZone(timeZone);
        SQLDATEFORMATTER.setTimeZone(timeZone);
        DateConverter.setCalendarFields(calDate, date, time);
        return calDate;
    }

    public static Calendar sqlDateTimeToCalendar(java.sql.Date date, Time time, TimeZone timeZone) {
        return DateConverter.sqlDateTimeToCalendar(date, time, timeZone, null);
    }

    public static Calendar sqlDateTimeToCalendar(java.sql.Date date, Time time, Locale locale) {
        return DateConverter.sqlDateTimeToCalendar(date, time, null, locale);
    }

    public static Calendar sqlDateTimeToCalendar(java.sql.Date date, Time time) {
        return DateConverter.sqlDateTimeToCalendar(date, time, null, null);
    }

    public static Calendar createInitializedCalendar() {
        Calendar CALENDAR = Calendar.getInstance();
        CALENDAR.set(1970, 0, 1, 0, 0, 0);
        CALENDAR.set(14, 0);
        return CALENDAR;
    }

    private static void setCalendarFields(Calendar calendar, java.sql.Date date, Time time) {
        int secDash;
        int firstDash;
        if (date != null) {
            String strDate = SQLDATEFORMATTER.format(date);
            firstDash = strDate.indexOf("-");
            secDash = strDate.indexOf("-", firstDash + 1);
            int year = Integer.parseInt(strDate.substring(0, firstDash));
            int month = Integer.parseInt(strDate.substring(firstDash + 1, secDash));
            int day = Integer.parseInt(strDate.substring(secDash + 1));
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
        } else {
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
        }
        if (time != null) {
            String strTime = SQLTIMEFORMATTER.format(time);
            firstDash = strTime.indexOf(":");
            secDash = strTime.indexOf(":", firstDash + 1);
            int hour = Integer.parseInt(strTime.substring(0, firstDash));
            int minute = Integer.parseInt(strTime.substring(firstDash + 1, secDash));
            int second = Integer.parseInt(strTime.substring(secDash + 1));
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }
        calendar.set(14, 0);
    }
}

