/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class BufferedUTF8Reader
extends BufferedReader {
    public BufferedUTF8Reader(File fileToBeRead, int buffersize) throws FileNotFoundException {
        super(BufferedUTF8Reader.getInputStreamReader(BufferedUTF8Reader.getFilename(fileToBeRead)), buffersize);
    }

    public BufferedUTF8Reader(String fileToBeRead, int buffersize) throws FileNotFoundException {
        super(BufferedUTF8Reader.getInputStreamReader(fileToBeRead), buffersize);
    }

    public BufferedUTF8Reader(File fileToBeRead) throws FileNotFoundException {
        super(BufferedUTF8Reader.getInputStreamReader(BufferedUTF8Reader.getFilename(fileToBeRead)));
    }

    public BufferedUTF8Reader(String fileToBeRead) throws FileNotFoundException {
        super(BufferedUTF8Reader.getInputStreamReader(fileToBeRead));
    }

    public BufferedUTF8Reader(InputStream streamToBeRead) {
        super(BufferedUTF8Reader.getInputStreamReader(streamToBeRead));
    }

    private static final InputStreamReader getInputStreamReader(String fname) throws FileNotFoundException {
        InputStreamReader result = null;
        String enc = "UTF8";
        try {
            result = new InputStreamReader((InputStream)new FileInputStream(fname), enc);
        }
        catch (UnsupportedEncodingException encodingException) {
            encodingException.printStackTrace(System.err);
            StringBuffer sb = new StringBuffer(35 + enc.length());
            sb.append("Device does not support ").append(enc).append(" encoding!!");
            throw new RuntimeException(sb.toString());
        }
        return result;
    }

    private static final InputStreamReader getInputStreamReader(InputStream in) {
        InputStreamReader result = null;
        String enc = "UTF8";
        try {
            result = new InputStreamReader(in, enc);
        }
        catch (UnsupportedEncodingException encodingException) {
            encodingException.printStackTrace(System.err);
            StringBuffer sb = new StringBuffer(35 + enc.length());
            sb.append("Device does not support ").append(enc).append(" encoding!!");
            throw new RuntimeException(sb.toString());
        }
        return result;
    }

    private static final String getFilename(File f) {
        String result = null;
        try {
            result = f.getCanonicalPath();
        }
        catch (IOException ioex) {
            System.err.print("Cannot resolve canonical path for file ");
            System.err.println(f);
            result = f.getAbsolutePath();
        }
        return result;
    }
}

