/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.runtime.jsp;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.runtime.Application;
import com.sap.ip.me.api.runtime.jsp.ApplicationHandler;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractMEHttpServlet
extends HttpServlet
implements Application {
    private Trace trace = Trace.getInstance("MI/API/Runtime/JSP");
    private MEResourceBundle resourceBundle;
    private static final String MI_HOME_URL;

    public static String getMIHome() {
        return MI_HOME_URL;
    }

    public final void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!"127.0.0.1".equalsIgnoreCase(request.getRemoteAddr())) {
            AppLog.getInstance("MI/API/Runtime/JSP").log(60, "Attempt to get access from remote machine with IP address {0} was successfully defeated.", (Object)request.getRemoteAddr());
            response.sendError(403);
            return;
        }
        if (UserManager.getInstance().getCurrentUser() == null && !this.getClass().getName().equals("com.sap.ip.me.apps.jsp.LoginServlet")) {
            request.getSession(true);
            response.sendRedirect(AbstractMEHttpServlet.getMIHome());
        }
        Configuration.getInstance().setDefaultProperty("MobileEngine.Runtime.Port", Integer.toString(request.getServerPort()));
        Configuration config = Configuration.getInstance();
        if (config.getBoolean("MobileEngine.UM.SAPLogonTicketSupport", false) && config.getBoolean("MobileEngine.UM.SingleUserMode", false)) {
            String event = request.getParameter("action");
            if (event == null && (event = request.getParameter("event")) == null) {
                event = request.getParameter("~event");
            }
            String eventPrefix = null;
            if (event != null && event.length() > 3) {
                eventPrefix = event.substring(0, 4);
            }
            if ("homesync".equals(event) || "sync".equals(eventPrefix)) {
                if (SyncManager.getInstance().isSyncCredentialAvailable()) {
                    config.setTemporary("MobileEngine.Core.MissingTicketAtSync", "");
                } else {
                    String s = config.getProperty("MobileEngine.Core.ticketRequestTimeout");
                    if (s != null && s.length() > 0) {
                        config.setTemporary("MobileEngine.Core.ticketRequestTimeout", "");
                        config.setTemporary("MobileEngine.Core.MissingTicketAtSync", "");
                    } else {
                        StringBuffer b = new StringBuffer(256);
                        b.append("http://").append(config.getProperty("MobileEngine.Runtime.Host"));
                        b.append(':').append(config.getProperty("MobileEngine.Runtime.Port"));
                        b.append(request.getRequestURI());
                        b.append('?').append(request.getQueryString());
                        config.setTemporary("MobileEngine.Core.MissingTicketAtSync", b.toString());
                        response.sendRedirect("/me/servlet/com.sap.ip.me.apps.jsp.LoginServlet?event=ticketRequestAtSync");
                        return;
                    }
                }
            }
        }
        try {
            ApplicationHandler.getSingleton().register(this.getApplicationName(), this);
        }
        catch (RuntimeException runtimeEx) {
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write("<html><head><title>Error</title></head><body><h1>Error: Cannot start application</h1><br>");
            ((Writer)writer).write("Application '");
            ((Writer)writer).write(this.getApplicationName());
            ((Writer)writer).write("' is not registered; upload application to SAP Web Console");
            ((Writer)writer).write("</body>");
            return;
        }
        super.service(request, response);
    }

    public static String encodeForHtml(char c) {
        return AbstractMEHttpServlet.encodeForHtml("" + c);
    }

    public static String encodeForHtml(String ascii) {
        int length = ascii.length();
        StringBuffer sb = new StringBuffer(length);
        int n = 0;
        while (n < length) {
            char c = ascii.charAt(n);
            switch (c) {
                case '\t': {
                    sb.append("    ");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    break;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    break;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    break;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    break;
                }
                case '\u00c4': {
                    sb.append("&auml;");
                    break;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    break;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    break;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    break;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    break;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    break;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    break;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    break;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    break;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    break;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    break;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    break;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    break;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    break;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    break;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    break;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    break;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    break;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    break;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    break;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    break;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    break;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    break;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    break;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    break;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    break;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    break;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    break;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    break;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    break;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    break;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    break;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    break;
                }
                case '\u00ac': {
                    sb.append("&euro;");
                    break;
                }
                default: {
                    sb.append("" + c);
                }
            }
            ++n;
        }
        return sb.toString();
    }

    public void init() throws ServletException {
        block3: {
            super.init();
            if (this.trace.isLogging(90)) {
                this.trace.log(90, "AbstractMEHttpServlet:init() called");
            }
            try {
                ApplicationHandler.getSingleton().register(this.getApplicationName(), this);
            }
            catch (RuntimeException runtimeEx) {
                String msg = runtimeEx.getMessage();
                if (msg != null && msg.indexOf("no current user") > 0) break block3;
                AppLog.getInstance(this.getApplicationName()).logException(50, "Application '" + this.getApplicationName() + "' cannot be initialized; check WebConsole entry", null, runtimeEx, true);
            }
        }
        this.resourceBundle = null;
        this.doInitialize();
    }

    public void destroy() {
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "AbstractMEHttpServlet:destroy() called");
        }
        this.doDestroy();
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "AbstractMEHttpServlet:doGet(...) called");
        }
        request.getSession().setMaxInactiveInterval(-1);
        String nextJSP = this.doHandleEvent(this.getEvent(request), request, response);
        this.dispatchRequest(nextJSP, request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "AbstractMEHttpServlet:doPost(...) called");
        }
        request.getSession().setMaxInactiveInterval(-1);
        String nextJSP = this.doHandleEvent(this.getEvent(request), request, response);
        this.dispatchRequest(nextJSP, request, response);
    }

    public void doInitialize() throws ServletException {
    }

    public void doDestroy() {
    }

    public abstract String doHandleEvent(String var1, HttpServletRequest var2, HttpServletResponse var3) throws ServletException, IOException;

    public void initApplication() {
    }

    public void activateApplication() {
    }

    public void deactivateApplication() {
    }

    public void destroyApplication() {
    }

    public abstract String getApplicationName();

    protected String getUser() {
        User user = UserManager.getInstance().getCurrentUser();
        return user != null ? user.getUniqueName() : "";
    }

    protected void setResourceBundle(String resourceBundleName) {
        this.resourceBundle = new MEResourceBundle(resourceBundleName, this.getLocale(), this.getClass().getClassLoader());
    }

    protected MEResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    protected Locale getLocale() {
        Locale result = null;
        String language = Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "");
        if (language != null) {
            language = language.toLowerCase();
        }
        if (language.length() > 0) {
            result = new Locale(language, "");
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        return result;
    }

    private String getEvent(HttpServletRequest request) {
        String eventName = null;
        try {
            eventName = request.getParameter("event");
        }
        catch (Exception e) {
            AppLog.getInstance("MI/API/Runtime/JSP").logException(60, e);
        }
        String result = null;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String attr = (String)e.nextElement();
            if (!attr.startsWith("_event_")) continue;
            result = attr.substring("_event_".length());
        }
        if (result != null) {
            eventName = result;
        }
        if (eventName == null) {
            eventName = "";
        }
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "AbstractMEHttpServlet:getEvent() done with event name = '" + eventName + "'");
        }
        return eventName;
    }

    private void dispatchRequest(String nextJSP, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MEResourceBundle meres;
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "AbstractMEHttpServlet:dispatch request to '" + nextJSP + "'");
        }
        if ((meres = this.getResourceBundle()) != null) {
            request.getSession().setAttribute("res", (Object)meres);
        }
        request.getSession().setAttribute("locale", (Object)this.getLocale());
        response.setLocale(this.getLocale());
        if (nextJSP != null) {
            RequestDispatcher jspDispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
            if (jspDispatcher != null) {
                jspDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect(nextJSP);
            }
        }
    }

    static {
        StringBuffer MIHomeURLBuffer = new StringBuffer("http://");
        String host = Configuration.getInstance().getProperty("MobileEngine.Runtime.Host", "localhost");
        String port = Configuration.getInstance().getProperty("MobileEngine.Runtime.Port", "4444");
        MIHomeURLBuffer.append(host).append(':').append(port).append('/');
        MI_HOME_URL = MIHomeURLBuffer.toString();
    }
}

