/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.symbology;

import com.sap.ip.me.api.pios.symbology.InvalidSymbologyException;
import com.sap.ip.me.api.pios.symbology.Symbology2D;

public final class PDF417
extends Symbology2D {
    private int columns;
    private int rows;
    public static final long SECURITY_LEVEL_1 = 1L;
    public static final long SECURITY_LEVEL_2 = 2L;
    public static final long SECURITY_LEVEL_3 = 4L;
    public static final long SECURITY_LEVEL_4 = 8L;
    public static final long SECURITY_LEVEL_5 = 16L;
    public static final long SECURITY_LEVEL_6 = 32L;
    public static final long SECURITY_LEVEL_7 = 64L;
    public static final long SECURITY_LEVEL_8 = 128L;
    public static final long SECURITY_LEVEL_AUTOMATIC = 256L;
    public static final long TRUNCATE = 512L;
    private static final long VALID_OPTIONS = 1023L;

    public PDF417() {
        super(1023L);
    }

    public PDF417(long options) throws InvalidSymbologyException {
        super(1023L);
        this.setOptions(options);
    }

    public String getName() {
        return "PDF417";
    }

    public int getType() {
        return 1024;
    }

    public void setOptions(long options) throws InvalidSymbologyException {
        super.validateOptions(options);
        if (options != 0L) {
            boolean selectedOption = false;
            int i = 0;
            while (i <= 8) {
                long option = 1L << i;
                if ((options & option) == option) {
                    if (!selectedOption) {
                        selectedOption = true;
                    } else {
                        throw new InvalidSymbologyException("Only one security level option can be selected per instance.");
                    }
                }
                ++i;
            }
        }
        this.options = options;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getColums() {
        return this.columns;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }
}

