/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.symbology;

import com.sap.ip.me.api.pios.symbology.InvalidSymbologyException;
import com.sap.ip.me.api.pios.symbology.SymbologyLinear;

public final class Code39
extends SymbologyLinear {
    public static final long STANDARD = 1L;
    public static final long FULLASCII = 2L;
    public static final long CHECK_DIGIT_MOD43 = 4L;
    public static final long CHECK_DIGIT_FRENCH_CIP = 8L;
    private static final long VALID_OPTIONS = 15L;

    public Code39() {
        super(15L);
        this.options = 1L;
    }

    public Code39(long options) throws InvalidSymbologyException {
        super(15L);
        this.setOptions(options);
    }

    public String getName() {
        return "CODE39";
    }

    public int getType() {
        return 4;
    }

    public void setOptions(long options) throws InvalidSymbologyException {
        super.validateOptions(options);
        if ((options & 1L) != 1L && (options & 2L) != 2L) {
            options |= 2L;
        }
        if ((options & 1L) == 1L && (options & 2L) == 2L) {
            throw new InvalidSymbologyException("Only one code set can be selected for this symbology.");
        }
        if ((options & 4L) == 4L && (options & 8L) == 8L) {
            throw new InvalidSymbologyException("CHECK_DIGIT_MOD43 and CHECK_DIGIT_FRENCH_CIP cannot be selected in the same instance");
        }
        this.options = options;
    }
}

