/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.printer;

import com.sap.ip.me.api.pios.PIOSException;
import com.sap.ip.me.api.pios.UnsupportedException;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.connection.Connection;
import com.sap.ip.me.api.pios.printer.FontConfigurationManager;
import com.sap.ip.me.api.pios.printer.PrinterBarcode;
import com.sap.ip.me.api.pios.printer.PrinterException;
import com.sap.ip.me.api.pios.printer.PrinterFont;
import com.sap.ip.me.api.pios.printer.PrinterImage;
import com.sap.ip.me.api.pios.symbology.InvalidSymbologyException;
import com.sap.ip.me.api.pios.symbology.Symbology;
import com.sap.ip.me.api.pios.symbology.SymbologyAttributes;

public abstract class PrinterConnection
extends Connection {
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_OUT_OF_PAPER = 1;
    public static final int STATUS_DATA_ERROR = 2;
    public static final int STATUS_OUT_OF_MEMORY_ERROR = 3;
    public static final int STATUS_FONT_NOT_AVAILABLE_ERROR = 4;
    public static final int STATUS_INVALID_COORDINATE_ERROR = 5;
    public static final int STATUS_UNKNOWN_ERROR = 6;

    protected PrinterConnection() throws PIOSException {
    }

    public abstract int getStatus() throws PrinterException;

    public abstract int getPrinterDPI() throws PrinterException;

    public abstract float getPrintHeadWidth() throws PrinterException;

    public abstract void clearError() throws PrinterException, UnsupportedException;

    public abstract void sendRawBytes(byte[] var1) throws PrinterException, UnsupportedException;

    public abstract PrinterFont[] listFonts(float var1, int var2, long var3) throws PrinterException;

    public abstract PrinterFont getFont(String var1) throws PrinterException;

    public abstract FontConfigurationManager getFontConfigurationManager() throws ConfigurationException;

    public abstract PrinterBarcode createBarcode(Symbology var1, long var2) throws UnsupportedException, InvalidSymbologyException, PrinterException;

    public abstract PrinterImage createImage(String var1, int var2, byte[] var3) throws UnsupportedException, PrinterException;

    public abstract void doPrint(int var1) throws PrinterException;

    public abstract void advance(float var1) throws UnsupportedException, PrinterException;

    public abstract void dispose() throws PrinterException;

    public abstract void loadImage(PrinterImage var1) throws UnsupportedException, PrinterException;

    public abstract void deleteImage(String var1) throws UnsupportedException, PrinterException;

    public static interface Attributes
    extends SymbologyAttributes {
        public static final String GRAPHIC_MODE = "GRAPHIC_MODE";
        public static final String LINE_MODE = "LINE_MODE";
        public static final String ADVANCE_BACK = "ADVANCE_BACK";
        public static final String ADVANCE_FORWARD = "ADVANCE_FORWARD";
        public static final String CONTINUOUS_PAPER = "CONTINUOUS_PAPER";
        public static final String SEND_RAW_BYTES = "SEND_RAW_BYTES";
        public static final String PAGE_METRICS = "PAGE_METRICS";
        public static final String CLEAR_PRINTER_ERROR = "CLEAR_PRINTER_ERROR";
        public static final String IMAGE_LOAD = "IMAGE_LOAD";
        public static final String IMAGE_BMP = "IMAGE_BMP";
        public static final String IMAGE_PCX = "IMAGE_PCX";
        public static final String IMAGE_DELETE = "IMAGE_DELETE";
        public static final String IMAGE_PRINT = "IMAGE_PRINT";
        public static final String FONT_SCALABLE = "FONT_SCALABLE";
        public static final String FONT_BITMAPPED = "FONT_BITMAPPED";
        public static final String TEXT_ROTATION = "TEXT_ROTATION";
        public static final String BARCODE_ROTATION = "BARCODE_ROTATION";
        public static final String IMAGE_ROTATION = "IMAGE_ROTATION";
        public static final String LINE_THICKNESS = "LINE_THICKNESS";
        public static final String LINE_ALIGNMENT = "LINE_ALIGNMENT";
        public static final String GRAPHICS = "GRAPHICS";
        public static final String LINE_SPACING = "LINE_SPACING";
        public static final String CODABAR_SCALABLE = "CODABAR_SCALABLE";
        public static final String CODABAR_HUMAN_READABLE_BELOW = "CODABAR_HUMAN_READABLE_BELOW";
        public static final String CODABAR_HUMAN_READABLE_ABOVE = "CODABAR_HUMAN_READABLE_ABOVE";
        public static final String CODABAR_HUMAN_READABLE_SHOW_CHECK_DIGIT = "CODABAR_HUMAN_READABLE_SHOW_CHECK_DIGIT";
        public static final String CODABAR_HUMAN_READABLE_SHOW_START_STOP = "CODABAR_HUMAN_READABLE_SHOW_START_STOP";
        public static final String CODE128_SCALABLE = "CODE128_SCALABLE";
        public static final String CODE128_START_CODESET_AUTO = "CODE128_START_CODESET_AUTO";
        public static final String CODE128_START_CODESET_MANUAL = "CODE128_START_CODESET_MANUAL";
        public static final String CODE128_HUMAN_READABLE_BELOW = "CODE128_HUMAN_READABLE_BELOW";
        public static final String CODE128_HUMAN_READABLE_ABOVE = "CODE128_HUMAN_READABLE_ABOVE";
        public static final String CODE39_SCALABLE = "CODE39_SCALABLE";
        public static final String CODE39_HUMAN_READABLE_BELOW = "CODE39_HUMAN_READABLE_BELOW";
        public static final String CODE39_HUMAN_READABLE_ABOVE = "CODE39_HUMAN_READABLE_ABOVE";
        public static final String CODE39_HUMAN_READABLE_SHOW_CHECK_DIGIT = "CODE39_HUMAN_READABLE_SHOW_CHECK_DIGIT";
        public static final String CODE39_HUMAN_READABLE_SHOW_START_STOP = "CODE39_HUMAN_READABLE_SHOW_START_STOP";
        public static final String EAN13_SCALABLE = "EAN13_SCALABLE";
        public static final String EAN13_SHOW_HUMAN_READABLE = "EAN13_SHOW_HUMAN_READABLE";
        public static final String EAN8_SCALABLE = "EAN8_SCALABLE";
        public static final String EAN8_SHOW_HUMAN_READABLE = "EAN8_SHOW_HUMAN_READABLE";
        public static final String INTERLEAVED2OF5_SCALABLE = "INTERLEAVED2OF5_SCALABLE";
        public static final String INTERLEAVED2OF5_HUMAN_READABLE_BELOW = "INTERLEAVED2OF5_HUMAN_READABLE_BELOW";
        public static final String INTERLEAVED2OF5_HUMAN_READABLE_ABOVE = "INTERLEAVED2OF5_HUMAN_READABLE_ABOVE";
        public static final String INTERLEAVED2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT = "INTERLEAVED2OF5_HUMAN_READABLE_SHOW_CHECK_DIGIT";
        public static final String PDF417_SCALABLE = "PDF417_SCALABLE";
        public static final String PDF417_TRUNCATE = "PDF417_TRUNCATE";
        public static final String PDF417_SECURITY_LEVEL_AUTOMATIC = "PDF417_SECURITY_LEVEL_AUTOMATIC";
        public static final String UCCEAN128_SCALABLE = "UCCEAN128_SCALABLE";
        public static final String UCCEAN128_HUMAN_READABLE_BELOW = "UCCEAN128_HUMAN_READABLE_BELOW";
        public static final String UCCEAN128_HUMAN_READABLE_ABOVE = "UCCEAN128_HUMAN_READABLE_ABOVE";
        public static final String UPC_A_SCALABLE = "UPC_A_SCALABLE";
        public static final String UPC_A_SHOW_HUMAN_READABLE = "UPC_A_SHOW_HUMAN_READABLE";
    }
}

