/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.connection;

import com.sap.ip.me.api.pios.PIOSException;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.connection.ConnectionType;
import com.sap.ip.me.api.pios.connection.Connector;
import com.sap.ip.me.api.pios.connection.DriverConfigurationManager;
import com.sap.ip.me.api.pios.util.PIOSPaths;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class DriverInfo {
    private static final String VERSION_ATTRIBUTE_NAME = "VERSION";
    private static final String ERROR_DRIVER_NAME = "Missing driver name";
    private String name = null;
    private String description = null;
    private ConnectionType connectionType = null;
    private Properties driverProperties = null;

    private DriverInfo() {
    }

    protected DriverInfo(String name, String description, Object connectionType) {
        this.name = name;
        this.description = description;
        this.connectionType = (ConnectionType)connectionType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    protected Properties getAttributes() throws PIOSException {
        if (this.getName() == null) {
            throw new PIOSException(2, ERROR_DRIVER_NAME);
        }
        if (this.driverProperties == null) {
            String propertiesFile = PIOSPaths.getPIOSPropertiesDir() + this.getName() + ".properties";
            try {
                this.driverProperties = this.loadPropertyFile(propertiesFile);
            }
            catch (Exception ex) {
                throw new PIOSException(13, (Throwable)ex);
            }
        }
        return this.driverProperties;
    }

    private Properties loadPropertyFile(String propPath) throws IOException {
        Properties prop = new Properties();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(propPath);
            bis = new BufferedInputStream(fis);
            prop.load(bis);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                bis.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                fis.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (Exception e) {}
        return prop;
    }

    public boolean isAttributeSupported(String attributeName) throws PIOSException {
        Properties attributes = this.getAttributes();
        String value = attributes.getProperty(attributeName);
        if (value == null) {
            throw new PIOSException(5, "Invalid attribute.");
        }
        return value.trim().equalsIgnoreCase("true");
    }

    public DriverConfigurationManager getConfigurationManager() throws ConfigurationException {
        try {
            String mePath = PIOSPaths.getPIOSConfigDir();
            String mdFile = mePath + this.name + ".md";
            String configFile = mePath + this.name + ".cfg";
            return new DriverConfigurationManager(Connector.getInstance().getConfigurationManager(mdFile, configFile));
        }
        catch (PIOSException e) {
            return null;
        }
    }

    public String getVersion() throws PIOSException {
        Properties attributes = this.getAttributes();
        String version = attributes.getProperty(VERSION_ATTRIBUTE_NAME);
        if (version == null) {
            throw new PIOSException(13, "Missing version attribute.");
        }
        return version;
    }
}

