/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.connection;

import com.sap.ip.me.api.pios.LibraryNotLoadedException;
import com.sap.ip.me.api.pios.PIOSException;
import com.sap.ip.me.api.pios.UnsupportedException;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.configuration.ConfigurationManager;
import com.sap.ip.me.api.pios.connection.Connection;
import com.sap.ip.me.api.pios.connection.ConnectionParameters;
import com.sap.ip.me.api.pios.connection.ConnectionType;
import com.sap.ip.me.api.pios.connection.DriverInfo;

public abstract class Connector {
    private static final String DEFAULT_IMPL = "com.sap.ip.me.api.pios.impl.connection.ConnectorImpl";
    public static final String CONNECTOR_IMPL_KEY = "pios.connector";
    private static Connector connector = null;

    protected Connector() {
    }

    public static Connector getInstance() throws PIOSException {
        if (connector == null) {
            String className = System.getProperties().getProperty(CONNECTOR_IMPL_KEY);
            connector = className != null ? Connector.loadInstance(className) : Connector.loadInstance(DEFAULT_IMPL);
        }
        if (connector == null) {
            throw new PIOSException(3, "No implementations found.");
        }
        return connector;
    }

    private static Connector loadInstance(String className) {
        if (className == null) {
            return null;
        }
        try {
            return (Connector)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public abstract Connection open(ConnectionParameters var1) throws LibraryNotLoadedException, UnsupportedException, PIOSException;

    public abstract DriverInfo[] listDrivers(ConnectionType var1) throws PIOSException, LibraryNotLoadedException;

    public abstract DriverInfo getDefaultDriver(ConnectionType var1) throws PIOSException, LibraryNotLoadedException;

    public abstract void setDefaultDriver(DriverInfo var1) throws PIOSException, LibraryNotLoadedException;

    protected abstract ConfigurationManager getConfigurationManager(String var1, String var2) throws ConfigurationException;
}

