/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.configuration;

import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.configuration.ConfigurationManager;

public class Configuration {
    private String name;
    private String type;
    private ConfigurationManager confManager;

    private Configuration() {
    }

    public Configuration(String name, String type, ConfigurationManager confManager) {
        this.name = name;
        this.type = type;
        this.confManager = confManager;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        try {
            return this.confManager.getParameters(this.type);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getPossibleValues(String parameter) throws ConfigurationException {
        return this.confManager.getPossibleValues(this.type, parameter);
    }

    public String getParameterValue(String parameter) throws ConfigurationException {
        return this.confManager.getParamaterValue(this.name, parameter);
    }

    public void setParameterValue(String parameter, String value) throws ConfigurationException {
        this.confManager.setParameterValue(this.name, parameter, value);
    }
}

