/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MEException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PIOSException
extends MEException {
    private int errorCode = 0;
    public static final int UNSPECIFIED_ERROR = 0;
    public static final int UNKNOWN_ERROR = 1;
    public static final int GENERIC_ERROR = 2;
    public static final int INVALID_OBJECT = 3;
    public static final int ALREADY_CREATED = 4;
    public static final int INVALID_PARAMETER = 5;
    public static final int NOT_CREATED = 6;
    public static final int NOT_OPENED = 7;
    public static final int ALREADY_OPENED = 8;
    public static final int UNSUPPORTED = 9;
    public static final int LIBRARY_NOT_LOADED = 10;
    public static final int TIMEOUT = 11;
    public static final int OUT_OF_MEMORY = 12;
    public static final int CONFIGURATION_ERROR = 13;
    public static final int INVALID_SYMBOLOGY = 14;
    public static final int SPECIFIC_PRINTER_ERROR = 65536;

    public PIOSException() {
        super("PIOS Error");
        this.logException(0, "PIOS Error");
    }

    public PIOSException(int errorCode) {
        this(errorCode, "PIOS Error");
    }

    public PIOSException(String message) {
        this(2, message);
    }

    public PIOSException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        this.logException(errorCode, message);
    }

    public static String getException(Throwable cause) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cause.printStackTrace(pw);
        pw.flush();
        String error = sw.toString();
        try {
            sw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            pw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return error;
    }

    public PIOSException(Throwable cause) {
        super(PIOSException.getException(cause));
        this.logException(0, PIOSException.getException(cause));
    }

    public PIOSException(int errorCode, Throwable cause) {
        super(PIOSException.getException(cause));
        this.errorCode = errorCode;
        this.logException(errorCode, PIOSException.getException(cause));
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private void logException(int errorCode, String description) {
        Trace miTrace = Trace.getInstance("MI/Core");
        if (miTrace.isOn()) {
            miTrace.log(description + " Error Code:(" + errorCode + ")");
        }
    }
}

