/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.persist.meta;

import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.api.smartsync.FixedDecimal;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import sun.io.ByteToCharConverter;

public abstract class AttributeType
implements MeComparator {
    public static final String CODE_PAGE = "UTF8";
    public static final String NULL_STR = "NULL";
    public static final AttributeType STRING = new StringAttributeType();
    public static final AttributeType INTEGER = new IntegerAttributeType();
    public static final AttributeType SHORT = new ShortAttributeType();
    public static final AttributeType LONG = new LongAttributeType();
    public static final AttributeType FLOAT = new FloatAttributeType();
    public static final AttributeType DOUBLE = new DoubleAttributeType();
    public static final AttributeType BOOLEAN = new BooleanAttributeType();
    public static final AttributeType BYTE = new ByteAttributeType();
    public static final AttributeType BINARY = new BinaryAttributeType();
    public static final AttributeType DATE = new DateAttributeType();
    public static final AttributeType DECIMAL = new DecimalAttributeType();
    public static final AttributeType SQLDATE = new SQLDateAttributeType();
    public static final AttributeType SQLTIME = new SQLTimeAttributeType();
    public static final AttributeType BIGDECIMAL = new BigDecimalAttributeType();
    public static final AttributeType BIGINTEGER = new BigIntegerAttributeType();
    public final Class javaType;
    public final int jdbcType;
    public final String sqlType;

    private AttributeType(Class javaType, int jdbcType, String sqlType) {
        this.javaType = javaType;
        this.jdbcType = jdbcType;
        this.sqlType = sqlType;
    }

    private static final void lengthToByte(byte[] arr, int off, int len) {
        arr[off++] = (byte)(len >>> 8 & 0x7F | len >>> 24 & 0x80);
        arr[off] = (byte)(len & 0xFF);
    }

    private static final int byteToLength(byte[] arr, int off) {
        if ((arr[off] & 0x80) > 0) {
            return (arr[off] & 0x7F) << 8 | arr[off + 1] & 0xFF | 0xFFFFFF80;
        }
        return (arr[off] & 0x7F) << 8 | arr[off + 1] & 0xFF;
    }

    private static final void shortToByte(byte[] arr, int off, int val) {
        arr[off++] = (byte)(val >>> 8 & 0xFF);
        arr[off] = (byte)(val & 0xFF);
    }

    private static final int byteToShort(byte[] arr, int off) {
        return (arr[off] & 0xFF) << 8 | arr[off + 1] & 0xFF;
    }

    private static final void intToByte(byte[] arr, int off, int val) {
        arr[off++] = (byte)(val >>> 24 & 0xFF);
        arr[off++] = (byte)(val >>> 16 & 0xFF);
        arr[off++] = (byte)(val >>> 8 & 0xFF);
        arr[off] = (byte)(val & 0xFF);
    }

    private static final int byteToInt(byte[] arr, int off) {
        return (arr[off++] & 0xFF) << 24 | (arr[off++] & 0xFF) << 16 | (arr[off++] & 0xFF) << 8 | arr[off] & 0xFF;
    }

    private static final void longToByte(byte[] arr, int off, long val) {
        arr[off++] = (byte)(val >>> 56 & 0xFFL);
        arr[off++] = (byte)(val >>> 48 & 0xFFL);
        arr[off++] = (byte)(val >>> 40 & 0xFFL);
        arr[off++] = (byte)(val >>> 32 & 0xFFL);
        arr[off++] = (byte)(val >>> 24 & 0xFFL);
        arr[off++] = (byte)(val >>> 16 & 0xFFL);
        arr[off++] = (byte)(val >>> 8 & 0xFFL);
        arr[off] = (byte)(val & 0xFFL);
    }

    private static final long byteToLong(byte[] arr, int off) {
        return ((long)arr[off++] & 0xFFL) << 56 | ((long)arr[off++] & 0xFFL) << 48 | ((long)arr[off++] & 0xFFL) << 40 | ((long)arr[off++] & 0xFFL) << 32 | ((long)arr[off++] & 0xFFL) << 24 | ((long)arr[off++] & 0xFFL) << 16 | ((long)arr[off++] & 0xFFL) << 8 | (long)arr[off] & 0xFFL;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return this.javaType.toString();
    }

    public abstract boolean isValidType(Object var1);

    public abstract int compare(Object var1, Object var2);

    public abstract int compare(byte[] var1, byte[] var2);

    public abstract int toByte(byte[] var1, int var2, Object var3, int var4, int var5);

    public abstract Object toValue(byte[] var1, int var2);

    public abstract int toByteLen(int var1, int var2);

    public abstract boolean contains(byte[] var1, Object var2);

    public abstract boolean startWith(byte[] var1, Object var2);

    public abstract Object getDefaultValue(int var1, int var2);

    public Object cloneMutable(Object o) {
        return o;
    }

    public boolean equals(byte[] b, Object o) {
        return this.compare(this.toValue(b, 0), o) == 0;
    }

    public boolean notEqual(byte[] b, Object o) {
        return !this.equals(b, o);
    }

    public boolean greaterThan(byte[] b, Object o) {
        return this.compare(this.toValue(b, 0), o) > 0;
    }

    public boolean lowerThan(byte[] b, Object o) {
        return this.compare(this.toValue(b, 0), o) < 0;
    }

    protected final int compare(long i1, long i2) {
        return (int)Math.max(-1L, Math.min(1L, i1 - i2));
    }

    protected final int compare(java.util.Date d1, java.util.Date d2) {
        long o2Time;
        long o1Time = d1.getTime();
        return o1Time < (o2Time = d2.getTime()) ? -1 : (o1Time == o2Time ? 0 : 1);
    }

    private static class BigIntegerAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$math$BigInteger;

        private BigIntegerAttributeType() {
            super(class$java$math$BigInteger == null ? (class$java$math$BigInteger = BigIntegerAttributeType.class$("java.math.BigInteger")) : class$java$math$BigInteger, -5, "DECIMAL");
        }

        public Object getDefaultValue(int len, int dec) {
            return new BigInteger("0");
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof BigInteger;
        }

        public final int toByteLen(int len, int dec) {
            return (len + dec >> 1) + 2;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off] = -1;
                return 1;
            }
            if (obj instanceof BigInteger) {
                return this.toByte(arr, off, (BigInteger)obj, len, dec);
            }
            throw new IllegalArgumentException("BIGINTEGER invalid value object type");
        }

        private final int toByte(byte[] arr, int off, BigInteger obj, int len, int dec) {
            byte[] val = obj.toByteArray();
            arr[off++] = (byte)(val.length & 0x7F);
            System.arraycopy(val, 0, arr, off, val.length);
            return off + val.length;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off] == -1) {
                return null;
            }
            int vallen = arr[off++] & 0x7F;
            byte[] val = new byte[vallen];
            System.arraycopy(arr, off, val, 0, vallen);
            return new BigInteger(val);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof BigInteger && o2 instanceof BigInteger) {
                return ((BigInteger)o1).compareTo((BigInteger)o2);
            }
            throw new IllegalArgumentException("BIGINTEGER invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class BigDecimalAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$math$BigDecimal;

        private BigDecimalAttributeType() {
            super(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BigDecimalAttributeType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, 3, "BIGDECIMAL");
        }

        public Object getDefaultValue(int len, int dec) {
            return new BigDecimal(0.0).movePointLeft(dec);
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof BigDecimal;
        }

        public final int toByteLen(int len, int dec) {
            return (len + dec >> 1) + 3;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off] = -1;
                return 1;
            }
            if (obj instanceof BigDecimal) {
                return this.toByte(arr, off, (BigDecimal)obj, len, dec);
            }
            throw new IllegalArgumentException("DECIMAL invalid value object type");
        }

        private final int toByte(byte[] arr, int off, BigDecimal obj, int len, int dec) {
            BigInteger b = obj.movePointRight(dec).toBigInteger();
            byte[] val = b.toByteArray();
            arr[off++] = (byte)(dec & 0x7F);
            arr[off++] = (byte)(len & 0x7F);
            arr[off++] = (byte)(val.length & 0x7F);
            System.arraycopy(val, 0, arr, off, val.length);
            return off + val.length;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off] == -1) {
                return null;
            }
            int dec = arr[off++] & 0x7F;
            int len = arr[off++] & 0x7F;
            int vallen = arr[off++] & 0x7F;
            byte[] val = new byte[vallen];
            System.arraycopy(arr, off, val, 0, vallen);
            return new BigDecimal(new BigInteger(val)).movePointLeft(dec);
        }

        private int compare(BigDecimal o1, BigDecimal o2) {
            return o1.compareTo(o2);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (!(o1 instanceof BigDecimal)) {
                throw new IllegalArgumentException("BIGDECIMAL: invalid compare types");
            }
            BigDecimal b1 = (BigDecimal)o1;
            if (!(o2 instanceof BigDecimal)) {
                throw new IllegalArgumentException("BIGDECIMAL: invalid compare types");
            }
            BigDecimal b2 = (BigDecimal)o2;
            return this.compare(b1, b2);
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SQLTimeAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$sql$Time;

        private SQLTimeAttributeType() {
            super(class$java$sql$Time == null ? (class$java$sql$Time = SQLTimeAttributeType.class$("java.sql.Time")) : class$java$sql$Time, 3, "DECIMAL");
        }

        public Object getDefaultValue(int len, int dec) {
            return Time.valueOf("00:00:00");
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Time;
        }

        public final int toByteLen(int len, int dec) {
            return 8;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                AttributeType.longToByte(arr, off, 0L);
                return 8;
            }
            if (!(obj instanceof Time)) {
                throw new IllegalArgumentException("SQLTIME invalid value object type");
            }
            AttributeType.longToByte(arr, off, ((Time)obj).getTime());
            return 8;
        }

        public final Object toValue(byte[] arr, int off) {
            long time = AttributeType.byteToLong(arr, off);
            if (time == 0L) {
                return null;
            }
            return new Time(time);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Time) {
                return super.compare((Time)o1, (Time)o2);
            }
            throw new IllegalArgumentException("SQLTIME: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(AttributeType.byteToLong(b1, 0), AttributeType.byteToLong(b2, 0));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public Object cloneMutable(Object o) {
            if (o == null) {
                return null;
            }
            return new Time(((Time)o).getTime());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SQLDateAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$sql$Date;

        private SQLDateAttributeType() {
            super(class$java$sql$Date == null ? (class$java$sql$Date = SQLDateAttributeType.class$("java.sql.Date")) : class$java$sql$Date, 3, "DECIMAL");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Date;
        }

        public final int toByteLen(int len, int dec) {
            return 8;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                AttributeType.longToByte(arr, off, 0L);
                return 8;
            }
            if (!(obj instanceof Date)) {
                throw new IllegalArgumentException("SQLDATE invalid value object type");
            }
            AttributeType.longToByte(arr, off, ((Date)obj).getTime());
            return 8;
        }

        public final Object toValue(byte[] arr, int off) {
            long time = AttributeType.byteToLong(arr, off);
            if (time == 0L) {
                return null;
            }
            return new Date(time);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Date) {
                return super.compare((java.util.Date)o1, (java.util.Date)o2);
            }
            throw new IllegalArgumentException("SQLDATE: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(AttributeType.byteToLong(b1, 0), AttributeType.byteToLong(b2, 0));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public Object cloneMutable(Object o) {
            if (o == null) {
                return null;
            }
            return new Date(((Date)o).getTime());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class DecimalAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$math$BigDecimal;

        private DecimalAttributeType() {
            super(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DecimalAttributeType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, 3, "DECIMAL");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof FixedDecimal || obj instanceof BigDecimal;
        }

        public final int toByteLen(int len, int dec) {
            return BIGDECIMAL.toByteLen(len, dec);
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off] = -1;
                return 1;
            }
            if (obj instanceof FixedDecimal) {
                return this.toByte(arr, off, ((FixedDecimal)obj).bigDecimalValue(), len, dec);
            }
            if (obj instanceof BigDecimal) {
                return this.toByte(arr, off, (BigDecimal)obj, len, dec);
            }
            throw new IllegalArgumentException("DECIMAL invalid value object type");
        }

        public final int toByte(byte[] arr, int off, BigDecimal obj, int len, int dec) {
            return BIGDECIMAL.toByte(arr, off, obj, len, dec);
        }

        public final Object toValue(byte[] arr, int off) {
            int vallen;
            int len;
            if (arr[off] == -1) {
                return null;
            }
            int dec = arr[off++] & 0xFF;
            if ((len = arr[off++] & 0xFF) == -1) {
                return null;
            }
            if ((vallen = arr[off++] & 0x7F) == 0) {
                return null;
            }
            byte[] val = new byte[vallen];
            System.arraycopy(arr, off, val, 0, vallen);
            BigDecimal _value = new BigDecimal(new BigInteger(val)).movePointLeft(dec);
            return new FixedDecimal(_value.toString(), len, dec);
        }

        public int compare(BigDecimal o1, BigDecimal o2) {
            return o1.compareTo(o2);
        }

        public int compare(Object o1, Object o2) {
            BigDecimal b2;
            BigDecimal b1;
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof BigDecimal) {
                b1 = (BigDecimal)o1;
            } else if (o1 instanceof FixedDecimal) {
                b1 = ((FixedDecimal)o1).bigDecimalValue();
            } else {
                throw new IllegalArgumentException("DECIMAL: invalid compare types");
            }
            if (o2 instanceof BigDecimal) {
                b2 = (BigDecimal)o2;
            } else if (o2 instanceof FixedDecimal) {
                b2 = ((FixedDecimal)o2).bigDecimalValue();
            } else {
                throw new IllegalArgumentException("DECIMAL: invalid compare types");
            }
            return this.compare(b1, b2);
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class DateAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$util$Calendar;

        private DateAttributeType() {
            super(class$java$util$Calendar == null ? (class$java$util$Calendar = DateAttributeType.class$("java.util.Calendar")) : class$java$util$Calendar, 93, "TIMESTAMP");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Calendar;
        }

        public final int toByteLen(int len, int dec) {
            return 8;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                AttributeType.longToByte(arr, off, 0L);
                return 8;
            }
            if (!(obj instanceof Calendar)) {
                throw new IllegalArgumentException("DATE invalid value object type");
            }
            AttributeType.longToByte(arr, off, ((Calendar)obj).getTime().getTime());
            return 8;
        }

        public final Object toValue(byte[] arr, int off) {
            long time = AttributeType.byteToLong(arr, off);
            if (time == 0L) {
                return null;
            }
            Calendar c = Calendar.getInstance();
            c.setTime(new Date(time));
            return c;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Calendar && o2 instanceof Calendar) {
                return this.compare(((Calendar)o1).getTime().getTime(), ((Calendar)o2).getTime().getTime());
            }
            throw new IllegalArgumentException("DATE: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(AttributeType.byteToLength(b1, 0), AttributeType.byteToLong(b2, 0));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public Object cloneMutable(Object o) {
            if (o == null) {
                return null;
            }
            return ((Calendar)o).clone();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class BinaryAttributeType
    extends AttributeType {
        static /* synthetic */ Class array$Ljava$lang$Byte;

        private BinaryAttributeType() {
            super(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = BinaryAttributeType.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, -2, "BLOB");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof byte[];
        }

        public final int toByteLen(int len, int dec) {
            return len + 2;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                AttributeType.lengthToByte(arr, off, -1);
                return 2;
            }
            if (!(obj instanceof byte[])) {
                throw new IllegalArgumentException("BINARY invalid value object type");
            }
            byte[] val = (byte[])obj;
            len = Math.min(len, val.length);
            AttributeType.lengthToByte(arr, off, len);
            System.arraycopy(val, 0, arr, off + 2, len);
            return len + 2;
        }

        public final Object toValue(byte[] arr, int off) {
            int len = AttributeType.byteToLength(arr, off);
            if (len == -1) {
                return null;
            }
            byte[] val = new byte[len];
            System.arraycopy(arr, off + 2, val, 0, len);
            return val;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                return this.compare((byte[])o1, (byte[])o2);
            }
            throw new IllegalArgumentException("BINARY: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            int i = 0;
            int max = Math.min(b1.length, b2.length);
            while (i < max) {
                if (b1[i] != b2[i]) {
                    return b1[i] > b2[i] ? 1 : -1;
                }
                ++i;
            }
            if (b1.length == b2.length) {
                return 0;
            }
            return b1.length > b2.length ? 1 : -1;
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean equals(byte[] b, Object o) {
            return this.compare(this.toValue(b, 0), o) == 0;
        }

        public boolean notEqual(byte[] b, Object o) {
            return !this.equals(b, o);
        }

        public boolean greaterThan(byte[] b, Object o) {
            return this.compare(this.toValue(b, 0), o) > 0;
        }

        public boolean lowerThan(byte[] b, Object o) {
            return this.compare(this.toValue(b, 0), o) < 0;
        }

        public Object cloneMutable(Object o) {
            if (o == null) {
                return null;
            }
            byte[] b = (byte[])o;
            byte[] clone = new byte[b.length];
            System.arraycopy(b, 0, clone, 0, b.length);
            return clone;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class ByteAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$Byte;

        private ByteAttributeType() {
            super(class$java$lang$Byte == null ? (class$java$lang$Byte = ByteAttributeType.class$("java.lang.Byte")) : class$java$lang$Byte, 5, "SMALLINT");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Byte;
        }

        public final int toByteLen(int len, int dec) {
            return 2;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off++] = 0;
                return 1;
            }
            arr[off++] = 1;
            if (!(obj instanceof Byte)) {
                throw new IllegalArgumentException("BYTE invalid value object type");
            }
            arr[off] = (Byte)obj;
            return 2;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off++] == 0) {
                return null;
            }
            return new Byte(arr[off]);
        }

        public final int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Byte && o2 instanceof Byte) {
                return this.compare(((Byte)o1).byteValue(), ((Byte)o2).byteValue());
            }
            throw new IllegalArgumentException("BYTE: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        private final int compare(int i1, int i2) {
            return Math.max(-1, Math.min(1, i1 - i2));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class BooleanAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$Boolean;

        private BooleanAttributeType() {
            super(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanAttributeType.class$("java.lang.Boolean")) : class$java$lang$Boolean, -7, "BOOLEAN");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Boolean;
        }

        public final int toByteLen(int len, int dec) {
            return 2;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off++] = 0;
                return 1;
            }
            arr[off++] = 1;
            if (!(obj instanceof Boolean)) {
                throw new IllegalArgumentException("BOOLEAN invalid value object type");
            }
            arr[off] = (Boolean)obj != false ? (byte)1 : 0;
            return 2;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off++] == 0) {
                return null;
            }
            return new Boolean(arr[off] != 0);
        }

        public final int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Boolean && o2 instanceof Boolean) {
                return this.compare((Boolean)o1, (Boolean)o2);
            }
            throw new IllegalArgumentException("BOOLEAN: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        private final int compare(boolean p1, boolean p2) {
            return p1 != p2 ? (p1 && !p2 ? 1 : -1) : 0;
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class DoubleAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$Double;

        private DoubleAttributeType() {
            super(class$java$lang$Double == null ? (class$java$lang$Double = DoubleAttributeType.class$("java.lang.Double")) : class$java$lang$Double, 8, "FLOAT");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Double;
        }

        public final int toByteLen(int len, int dec) {
            return 9;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off++] = 0;
                return 1;
            }
            arr[off++] = 1;
            if (!(obj instanceof Double)) {
                throw new IllegalArgumentException("DOUBLE invalid value object type");
            }
            AttributeType.longToByte(arr, off, Double.doubleToLongBits((Double)obj));
            return 9;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off++] == 0) {
                return null;
            }
            return new Double(Double.longBitsToDouble(AttributeType.byteToLong(arr, off)));
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Double && o2 instanceof Double) {
                return this.compare((Double)o1, (Double)o2);
            }
            throw new IllegalArgumentException("DOUBLE: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        private final int compare(double f1, double f2) {
            return f1 > f2 ? 1 : (f1 < f2 ? -1 : 0);
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class FloatAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$Float;

        private FloatAttributeType() {
            super(class$java$lang$Float == null ? (class$java$lang$Float = FloatAttributeType.class$("java.lang.Float")) : class$java$lang$Float, 6, "FLOAT");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Float;
        }

        public final int toByteLen(int len, int dec) {
            return 5;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off++] = 0;
                return 1;
            }
            arr[off++] = 1;
            if (!(obj instanceof Float)) {
                throw new IllegalArgumentException("FLOAT invalid value object type");
            }
            AttributeType.intToByte(arr, off, Float.floatToIntBits(((Float)obj).floatValue()));
            return 5;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off++] == 0) {
                return null;
            }
            return new Float(Float.intBitsToFloat(AttributeType.byteToInt(arr, off)));
        }

        public final int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Float && o2 instanceof Float) {
                return this.compare(((Float)o1).floatValue(), ((Float)o2).floatValue());
            }
            throw new IllegalArgumentException("FLOAT: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        private final int compare(float f1, float f2) {
            return f1 > f2 ? 1 : (f1 < f2 ? -1 : 0);
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class LongAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$Long;

        private LongAttributeType() {
            super(class$java$lang$Long == null ? (class$java$lang$Long = LongAttributeType.class$("java.lang.Long")) : class$java$lang$Long, -5, "INTEGER");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Long;
        }

        public final int toByteLen(int len, int dec) {
            return 9;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off++] = 0;
                return 1;
            }
            arr[off++] = 1;
            if (!(obj instanceof Long)) {
                throw new IllegalArgumentException("LONG invalid value object type");
            }
            AttributeType.longToByte(arr, off, (Long)obj);
            return 9;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off++] == 0) {
                return null;
            }
            return new Long(AttributeType.byteToLong(arr, off));
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Long && o2 instanceof Long) {
                return this.compare((Long)o1, (Long)o2);
            }
            throw new IllegalArgumentException("LONG: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class ShortAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$Short;

        private ShortAttributeType() {
            super(class$java$lang$Short == null ? (class$java$lang$Short = ShortAttributeType.class$("java.lang.Short")) : class$java$lang$Short, 5, "SMALLINT");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Short;
        }

        public final int toByteLen(int len, int dec) {
            return 3;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off++] = 0;
                return 1;
            }
            arr[off++] = 1;
            if (!(obj instanceof Short)) {
                throw new IllegalArgumentException("SHORT invalid value object type");
            }
            AttributeType.shortToByte(arr, off, ((Short)obj).shortValue());
            return 3;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off++] == 0) {
                return null;
            }
            return new Short((short)AttributeType.byteToShort(arr, off));
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Short && o2 instanceof Short) {
                return this.compare(((Short)o1).intValue(), ((Short)o2).intValue());
            }
            throw new IllegalArgumentException("SHORT: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        private final int compare(int i1, int i2) {
            return Math.max(-1, Math.min(1, i1 - i2));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class IntegerAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$Integer;

        private IntegerAttributeType() {
            super(class$java$lang$Integer == null ? (class$java$lang$Integer = IntegerAttributeType.class$("java.lang.Integer")) : class$java$lang$Integer, 4, "INTEGER");
        }

        public Object getDefaultValue(int len, int dec) {
            return null;
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof Integer;
        }

        public final int toByteLen(int len, int dec) {
            return 5;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                arr[off++] = 0;
                return 1;
            }
            arr[off++] = 1;
            if (!(obj instanceof Integer)) {
                throw new IllegalArgumentException("INTEGER invalid value object type");
            }
            AttributeType.intToByte(arr, off, (Integer)obj);
            return 5;
        }

        public final Object toValue(byte[] arr, int off) {
            if (arr[off++] == 0) {
                return null;
            }
            return new Integer(AttributeType.byteToInt(arr, off));
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return this.compare((Integer)o1, (Integer)o2);
            }
            throw new IllegalArgumentException("INTEGER: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toValue(b1, 0), this.toValue(b2, 0));
        }

        private final int compare(int i1, int i2) {
            return Math.max(-1, Math.min(1, i1 - i2));
        }

        public boolean contains(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        public boolean startWith(byte[] b, Object o) {
            throw new RuntimeException("Only Supported for String");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class StringAttributeType
    extends AttributeType {
        static /* synthetic */ Class class$java$lang$String;

        private StringAttributeType() {
            super(class$java$lang$String == null ? (class$java$lang$String = StringAttributeType.class$("java.lang.String")) : class$java$lang$String, 12, "VARCHAR");
        }

        public Object getDefaultValue(int len, int dec) {
            return "";
        }

        public final boolean isValidType(Object obj) {
            return obj == null || obj instanceof String;
        }

        public final int toByteLen(int len, int dec) {
            if (len < 0) {
                return 4;
            }
            return len * 3 + 4;
        }

        public final int toByte(byte[] arr, int off, Object obj, int len, int dec) {
            if (obj == null) {
                AttributeType.intToByte(arr, off, -1);
                return 4;
            }
            if (!(obj instanceof String)) {
                throw new IllegalArgumentException("STRING invalid value object type");
            }
            String str = (String)obj;
            try {
                byte[] buf = str.getBytes(AttributeType.CODE_PAGE);
                if (len * 3 < buf.length) {
                    throw new IllegalArgumentException("Illegal data length for " + obj);
                }
                System.arraycopy(buf, 0, arr, off + 4, buf.length);
                AttributeType.intToByte(arr, off, buf.length);
                return buf.length + 4;
            }
            catch (UnsupportedEncodingException uee) {
                AttributeType.lengthToByte(arr, off, 0);
                return 0;
            }
        }

        public final Object toValue(byte[] arr, int off) {
            int len = AttributeType.byteToInt(arr, off);
            if (len == 0) {
                return "";
            }
            if (len == -1) {
                return null;
            }
            try {
                return new String(arr, off + 4, len, AttributeType.CODE_PAGE);
            }
            catch (UnsupportedEncodingException uee) {
                return null;
            }
        }

        public final char[] toChars(byte[] arr, int off) {
            int len = AttributeType.byteToInt(arr, off);
            if (len == 0) {
                return new char[0];
            }
            return this.getChars(arr, off + 4, len);
        }

        public final char[] toChars(byte[] arr) {
            return this.toChars(arr, 0);
        }

        private char[] getChars(byte[] b) {
            return this.getChars(b, 0, b.length);
        }

        private char[] getChars(byte[] b, int off, int len) {
            try {
                return this.getChars(b, off, len, AttributeType.CODE_PAGE);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF8 encoding is not supported!");
            }
        }

        private char[] getChars(byte[] b, int off, int len, String enc) throws UnsupportedEncodingException {
            return this.getChars(b, off, len, ByteToCharConverter.getConverter((String)enc));
        }

        private char[] getChars(byte[] bytes, int offset, int length, ByteToCharConverter btc) throws UnsupportedEncodingException {
            int count = 0;
            if (length < 0) {
                throw new StringIndexOutOfBoundsException("length must be >= 0");
            }
            if (offset < 0) {
                throw new StringIndexOutOfBoundsException("offset must be >= 0");
            }
            if (offset > bytes.length - length) {
                throw new StringIndexOutOfBoundsException(offset + count);
            }
            int estCount = btc.getMaxCharsPerByte() * length;
            char[] value = new char[estCount];
            try {
                count = btc.convert(bytes, offset, offset + length, value, 0, estCount);
                count += btc.flush(value, btc.nextCharIndex(), estCount);
            }
            catch (CharConversionException x) {
                count = btc.nextCharIndex();
            }
            if (count < estCount) {
                char[] trimValue = new char[count];
                System.arraycopy(value, 0, trimValue, 0, count);
                value = trimValue;
            }
            return value;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof String && o2 instanceof String) {
                return Math.max(-1, Math.min(1, ((String)o1).compareTo((String)o2)));
            }
            throw new IllegalArgumentException("STRING: invalid compare types");
        }

        public int compare(byte[] b1, byte[] b2) {
            return this.compare(this.toChars(b1), this.getChars(b2));
        }

        public int compare(byte[] b, Object o) {
            if (o == null) {
                return -1;
            }
            if (o instanceof String) {
                return this.compare(this.toChars(b), ((String)o).toCharArray());
            }
            throw new IllegalArgumentException("STRING: invalid compare types");
        }

        /*
         * Unable to fully structure code
         */
        public int compare(char[] s1, char[] s2) {
            block3: {
                len1 = s1.length;
                len2 = s2.length;
                n = Math.min(len1, len2);
                i = 0;
                j = 0;
                if (i != j) ** GOTO lbl19
                k = i;
                lim = n + i;
                while (k < lim) {
                    c1 = s1[k];
                    c2 = s2[k];
                    if (c1 != c2) {
                        return c1 - c2;
                    }
                    ++k;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    if ((c1 = s1[i++]) == (c2 = s2[j++])) continue;
                    return c1 - c2;
lbl19:
                    // 2 sources

                    ** while (n-- != 0)
                }
            }
            return len1 - len2;
        }

        public boolean contains(byte[] b1, byte[] b2) {
            return this.contains(this.toChars(b1), this.getChars(b2));
        }

        public boolean contains(byte[] b, Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return this.contains(this.toChars(b), ((String)o).toCharArray());
            }
            throw new IllegalArgumentException("STRING: invalid compare types");
        }

        public boolean contains(char[] s1, char[] s2) {
            return this.indexOf(s1, s2) != -1;
        }

        public int indexOf(char[] s1, char[] s2) {
            int max = s1.length - s2.length;
            if (s1.length <= 0) {
                if (s1.length == 0 && s2.length == 0) {
                    return 0;
                }
                return -1;
            }
            if (s2.length == 0) {
                return 0;
            }
            int strOffset = 0;
            char first = s2[0];
            int i = 0;
            block0: while (true) {
                if (i <= max && s1[i] != first) {
                    ++i;
                    continue;
                }
                if (i > max) {
                    return -1;
                }
                int j = i + 1;
                int end = j + s2.length - 1;
                int k = strOffset + 1;
                while (j < end) {
                    if (s1[j++] == s2[k++]) continue;
                    ++i;
                    continue block0;
                }
                break;
            }
            return i;
        }

        public boolean startWith(byte[] b1, byte[] b2) {
            return this.startWith(this.toChars(b1), this.getChars(b2));
        }

        public boolean startWith(byte[] b, Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return this.startWith(this.toChars(b), ((String)o).toCharArray());
            }
            throw new IllegalArgumentException("STRING: invalid compare types");
        }

        /*
         * Unable to fully structure code
         */
        public boolean startWith(char[] s1, char[] s2) {
            to = 0;
            tlim = s1.length;
            po = 0;
            pc = s2.length;
            if (s1.length - s2.length >= 0) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                if (s1[to++] == s2[po++]) continue;
                return false;
lbl9:
                // 2 sources

                ** while (--pc >= 0)
            }
lbl10:
            // 1 sources

            return true;
        }

        public boolean equals(byte[] b1, byte[] b2) {
            return this.equals(this.toChars(b1), this.getChars(b2));
        }

        public boolean equals(char[] s1, char[] s2) {
            int n = s1.length;
            if (n == s2.length) {
                int i = 0;
                int j = 0;
                while (n-- != 0) {
                    if (s1[i++] == s2[j++]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean notEqual(byte[] b1, byte[] b2) {
            return this.notEqual(this.toChars(b1), this.getChars(b2));
        }

        public boolean notEqual(char[] s1, char[] s2) {
            return !this.equals(s1, s2);
        }

        public boolean greaterThan(byte[] b1, byte[] b2) {
            return this.greaterThan(this.toChars(b1), this.getChars(b2));
        }

        public boolean greaterThan(char[] s1, char[] s2) {
            return this.compare(s1, s2) > 0;
        }

        public boolean lowerThan(byte[] b1, byte[] b2) {
            return this.lowerThan(this.toChars(b1), this.getChars(b2));
        }

        public boolean lowerThan(char[] s1, char[] s2) {
            return this.compare(s1, s2) < 0;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

