/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.persist.core;

public final class PersistenceOperationType {
    public static final PersistenceOperationType INSERT;
    public static final PersistenceOperationType MODIFY;
    public static final PersistenceOperationType DELETE;
    public static final PersistenceOperationType NOOPER;
    private static final PersistenceOperationType[] ALLTYPES;
    private final String string;
    private final int index;
    private PersistenceOperationType onEntityNotExistsAction;
    private PersistenceOperationType onEntityExistsAction;
    private PersistenceOperationType[] mergeAction;

    private PersistenceOperationType(String string, int index) {
        this.string = string;
        this.index = index;
    }

    public static PersistenceOperationType forInt(int intVal) {
        return intVal < ALLTYPES.length ? ALLTYPES[intVal] : null;
    }

    public String toString() {
        return this.string;
    }

    public int toInt() {
        return this.index;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return this.index;
    }

    public PersistenceOperationType getMerged(PersistenceOperationType nextOperationType) {
        return nextOperationType != null ? this.mergeAction[nextOperationType.index] : this;
    }

    public PersistenceOperationType getOnExists(boolean exists) {
        return exists ? this.onEntityExistsAction : this.onEntityNotExistsAction;
    }

    private void setMergeAction(PersistenceOperationType[] mergeAction) {
        this.mergeAction = mergeAction;
    }

    private void setOnExistsAction(PersistenceOperationType exists, PersistenceOperationType notExists) {
        this.onEntityExistsAction = exists;
        this.onEntityNotExistsAction = notExists;
    }

    static {
        int x = 0;
        INSERT = new PersistenceOperationType("i", x++);
        MODIFY = new PersistenceOperationType("m", x++);
        DELETE = new PersistenceOperationType("d", x++);
        NOOPER = new PersistenceOperationType("n", x++);
        INSERT.setMergeAction(new PersistenceOperationType[]{INSERT, INSERT, NOOPER, INSERT});
        MODIFY.setMergeAction(new PersistenceOperationType[]{MODIFY, MODIFY, DELETE, MODIFY});
        DELETE.setMergeAction(new PersistenceOperationType[]{MODIFY, MODIFY, DELETE, DELETE});
        NOOPER.setMergeAction(new PersistenceOperationType[]{INSERT, MODIFY, DELETE, NOOPER});
        INSERT.setOnExistsAction(MODIFY, INSERT);
        MODIFY.setOnExistsAction(MODIFY, INSERT);
        DELETE.setOnExistsAction(DELETE, NOOPER);
        NOOPER.setOnExistsAction(NOOPER, NOOPER);
        ALLTYPES = new PersistenceOperationType[]{INSERT, MODIFY, DELETE, NOOPER};
    }
}

