/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.persist.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.query.JQueryFactory;
import java.util.StringTokenizer;

public abstract class PersistenceImplementation {
    private final String name;
    private final String persRt;
    private final String desRt;
    private final String qRt;
    private static final String PRT_API_TYPE = "com.sap.ip.me.api.persist.core.PersistenceRuntime";
    private static final String QRT_API_TYPE = "com.sap.ip.me.api.persist.query.QueryRuntime";
    private static final String DRT_API_TYPE = "com.sap.ip.me.api.persist.meta.DescriptorRuntime";
    private static final String PERSISTENCE_DB2_DLL = "MobileEngine.Persist.Jdbc.Db2.Dll";
    private static final String JQUERY_FACTORY = "com.sap.ip.me.persist.jdbc.DBJQueryFactoryImpl";
    private final Object[] instances = new Object[3];
    private static final int PRT_INST_IDX = 0;
    private static final int QRT_INST_IDX = 1;
    private static final int DRT_INST_IDX = 2;
    private static final PersistenceImplementation DB2E = new PersistenceImplementation("DB2E", "com.sap.ip.me.persist.jdbc.DBPersistenceRuntimeImpl", "com.sap.ip.me.persist.jdbc.DBDescriptorRuntimeImpl", "com.sap.ip.me.persist.core.QueryRuntimeImpl"){

        void initialize() {
            String dllNames = Configuration.getInstance().getProperty(PersistenceImplementation.PERSISTENCE_DB2_DLL);
            try {
                StringTokenizer st = new StringTokenizer(dllNames, ",");
                while (st.hasMoreTokens()) {
                    String dllName = st.nextToken();
                    if (dllName.indexOf(47) != -1) {
                        Runtime.getRuntime().load(dllName);
                        continue;
                    }
                    System.loadLibrary(dllName);
                }
                Trace.getInstance("MI/Core").log(90, "DB2e DLLs loaded");
            }
            catch (UnsatisfiedLinkError e) {
                Trace.getInstance("MI/Core").log(10, "Failed to load DB2e DLLs!");
                throw new RuntimeException("Fatal Error: Failed to load DB2e DLLs");
            }
        }

        public JQueryFactory getJQueryFactoryInstance() throws Exception {
            return (JQueryFactory)Class.forName(PersistenceImplementation.JQUERY_FACTORY).newInstance();
        }
    };
    private static final PersistenceImplementation MAXDB = new PersistenceImplementation("MAXDB", "com.sap.ip.me.persist.jdbc.DBPersistenceRuntimeImpl", "com.sap.ip.me.persist.jdbc.DBDescriptorRuntimeImpl", "com.sap.ip.me.persist.core.QueryRuntimeImpl"){

        void initialize() {
        }

        public JQueryFactory getJQueryFactoryInstance() throws Exception {
            return (JQueryFactory)Class.forName(PersistenceImplementation.JQUERY_FACTORY).newInstance();
        }
    };
    private static final PersistenceImplementation MIDB = new PersistenceImplementation("MIDB", "com.sap.ip.me.persist.fileio.PersistenceRuntimeImpl", "com.sap.ip.me.persist.core.DescriptorRuntimeImpl", "com.sap.ip.me.persist.fileio.QueryRuntimeImpl"){

        void initialize() {
        }

        public JQueryFactory getJQueryFactoryInstance() throws Exception {
            throw new RuntimeException("JQuery not supported with current Persistence Impl.");
        }
    };
    public static final PersistenceImplementation NONE = new PersistenceImplementation("NONE", null, null, null){

        void initialize() {
        }

        public JQueryFactory getJQueryFactoryInstance() throws Exception {
            throw new RuntimeException("JQuery not supported for current Persistence Impl.");
        }
    };
    private static PersistenceImplementation implementation = null;

    private PersistenceImplementation(String name, String persRt, String desRt, String qRt) {
        this.name = name;
        this.persRt = persRt;
        this.desRt = desRt;
        this.qRt = qRt;
    }

    public Object getSingletonInstance(Class apiType) {
        String typeName = apiType.getName();
        int instIdx = -1;
        String classname = null;
        if (PRT_API_TYPE.equals(typeName)) {
            classname = this.persRt;
            instIdx = 0;
        } else if (QRT_API_TYPE.equals(typeName)) {
            classname = this.qRt;
            instIdx = 1;
        } else if (DRT_API_TYPE.equals(typeName)) {
            classname = this.desRt;
            instIdx = 2;
        }
        return this.getSingletonInstance(classname, instIdx);
    }

    abstract void initialize();

    public abstract JQueryFactory getJQueryFactoryInstance() throws Exception;

    private final Object getSingletonInstance(String className, int instIdx) {
        if (className == null) {
            return null;
        }
        if (this.instances[instIdx] == null) {
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    this.instances[instIdx] = clazz.newInstance();
                }
                catch (InstantiationException e1) {
                    Trace.getInstance("MI/API/Persistence").logException(e1);
                }
                catch (IllegalAccessException e1) {
                    Trace.getInstance("MI/API/Persistence").logException(e1);
                }
            }
            catch (ClassNotFoundException e) {
                Trace.getInstance("MI/API/Persistence").logException(e);
            }
        }
        return this.instances[instIdx];
    }

    public String toString() {
        return new StringBuffer(200).append(this.name).append(" ; ").append(this.persRt).append(" ; ").append(this.qRt).append(" ; ").append(this.desRt).toString();
    }

    public static PersistenceImplementation getImplementation() {
        if (implementation == null) {
            String implementationStr = Configuration.getInstance().getProperty("MobileEngine.Persist.Implementation", "").trim().toUpperCase();
            implementation = PersistenceImplementation.MIDB.name.equals(implementationStr) ? MIDB : (PersistenceImplementation.DB2E.name.equals(implementationStr) ? DB2E : (PersistenceImplementation.MAXDB.name.equals(implementationStr) ? MAXDB : NONE));
            Trace trc = Trace.getInstance("MI/API/Persistence");
            if (trc.isLogging(70)) {
                String msg = new StringBuffer(200).append("Determined PersistenceImplementation (implementation / config paramter value): ").append(PersistenceImplementation.implementation.name).append(" / ").append(implementationStr).toString();
                trc.log(70, msg);
            }
            implementation.initialize();
        }
        return implementation;
    }

    public static void _init() {
        implementation = null;
    }
}

