/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.logging;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.LogWriter;
import java.util.Hashtable;

public class Trace
extends AbstractLogging {
    private static final String TRACENAME = "Trace";
    private static Hashtable instances = new Hashtable(30);
    private static LogWriter out;
    private static int logLevel;
    private static boolean on;
    private static String logwriterClassname;
    private boolean forceSwitchOn = false;

    private Trace(String componentname) {
        this.setComponent(componentname);
        this.refresh();
    }

    public static Trace getInstance(String componentname) {
        Trace result = (Trace)instances.get(componentname);
        if (result == null) {
            result = new Trace(componentname);
            instances.put(componentname, result);
        }
        return result;
    }

    public boolean isLogging(int severity) {
        return this.isOn() && severity <= this.getEffectiveSeverity();
    }

    public boolean switchOn(boolean on) {
        boolean oldstate = this.isOn();
        if (!this.forceSwitchOn && on == oldstate) {
            return true;
        }
        LogWriter lw = this.getLogWriter();
        if (lw == null) {
            return false;
        }
        boolean success = lw.switchOn(on);
        if (success) {
            this.setOn(on);
            if (!oldstate) {
                int current = this.getEffectiveSeverity();
                this.log(70, "Trace severity: {0} ({1})", (Object)this.getLogLevelName(current), (Object)Integer.toString(current));
            }
        }
        return success;
    }

    public String getLogName() {
        return TRACENAME;
    }

    public void refresh() {
        boolean oldState = this.isOn();
        String oldLogWriterImpl = this.getLogWriterClassname();
        this.readConfiguration(TRACENAME);
        String newLogWriterImpl = this.getLogWriterClassname();
        if (this.hasNotChanged(oldState, this.isOn(), oldLogWriterImpl, newLogWriterImpl, this.getLogWriter())) {
            return;
        }
        this.forceSwitchOn = true;
        if (!(!oldState || this.getLogWriterClassname().equals(oldLogWriterImpl) && this.isOn())) {
            this.switchOn(false);
        }
        if (!this.getLogWriterClassname().equals(oldLogWriterImpl) || this.getLogWriter() == null) {
            try {
                LogWriter lw = (LogWriter)Class.forName(newLogWriterImpl).newInstance();
                lw.initialize("MobileEngine.Trace");
                lw.setPrintProlog(true);
                lw.setPrintAppendix(true);
                this.setLogWriter(lw);
            }
            catch (Exception t) {
                System.err.println("Cannot set log writer '" + newLogWriterImpl + "' because: " + t.getMessage());
                t.printStackTrace(System.err);
            }
        }
        this.switchOn(this.isOn());
        this.forceSwitchOn = false;
    }

    public int getEffectiveSeverity() {
        return logLevel;
    }

    public void setEffectiveSeverity(int level) {
        logLevel = level;
        this.writeConfiguration(this.getLogName(), true);
    }

    public boolean isOn() {
        return on;
    }

    protected LogWriter getLogWriter() {
        return out;
    }

    protected void setLogWriter(LogWriter newLogWriter) {
        if (newLogWriter == null || !(newLogWriter instanceof LogWriter)) {
            throw new IllegalArgumentException("Illegal log writer. Either null or not an instance of LogWriter.");
        }
        if (out != newLogWriter) {
            if (out != null) {
                out.switchOn(false);
            }
            out = newLogWriter;
            logwriterClassname = newLogWriter.getClass().getName();
            this.writeConfiguration(this.getLogName(), true);
        }
    }

    protected void readConfiguration(String logName) {
        if (logName == null || logName.length() == 0) {
            throw new IllegalArgumentException("Log name must not be null or empty");
        }
        Configuration config = Configuration.getInstance();
        int prefixlength = "MobileEngine.".length() + logName.length();
        StringBuffer sb = new StringBuffer(prefixlength + 15);
        sb.append("MobileEngine.").append(logName).append(".Enabled");
        on = config.getBoolean(sb.toString(), false);
        sb.setLength(prefixlength);
        sb.append(".Level");
        logLevel = config.getInt(sb.toString(), 60);
        sb.setLength(prefixlength);
        sb.append(".Implementation");
        logwriterClassname = config.getProperty(sb.toString(), "com.sap.ip.me.api.services.DefaultFileLogWriter");
    }

    protected void setOn(boolean newon) {
        on = newon;
        this.writeConfiguration(this.getLogName(), true);
    }

    protected String getLogWriterClassname() {
        return logwriterClassname;
    }

    private boolean hasNotChanged(boolean oldOn, boolean newOn, String oldName, String newName, LogWriter lw) {
        if (oldName == null) {
            oldName = "";
        }
        if (newName == null) {
            newName = "";
        }
        return oldOn == newOn && oldName.equals(newName) && lw != null;
    }

    static {
        logLevel = 60;
        on = false;
        logwriterClassname = null;
    }
}

