/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.logging;

import com.sap.ip.me.api.logging.DefaultMessageFormatter;
import com.sap.ip.me.api.logging.LogWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;

public class DefaultSystemLogWriter
implements LogWriter {
    private DefaultMessageFormatter formatter = new DefaultMessageFormatter();
    private boolean on = false;
    private boolean printProlog = false;
    private boolean printAppendix = false;

    public void logFileContent(int severity, String component, File file, String encoding) {
        if (!this.on) {
            return;
        }
        if (file == null) {
            this.writeln(60, component, "Cannot log 'null' file", null);
            return;
        }
        BufferedReader reader = null;
        try {
            DefaultSystemLogWriter defaultSystemLogWriter = this;
            synchronized (defaultSystemLogWriter) {
                String path = file.getAbsolutePath();
                System.out.println(this.formatter.format(severity, component, "Dumping file ''{0}''", new Object[]{path}));
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
                char[] readbuffer = new char[1024];
                PrintWriter out = new PrintWriter(System.out);
                int charsread = reader.read(readbuffer);
                while (charsread != -1) {
                    out.write(readbuffer, 0, charsread);
                    out.flush();
                    charsread = reader.read(readbuffer);
                }
                System.out.println();
                reader.close();
                System.out.println(this.formatter.format(severity, component, "End of content of file  ''{0}''", new Object[]{path}));
            }
        }
        catch (FileNotFoundException e) {
            this.writeln(60, "MI/API/Logging", "File not found: " + file.getName(), null);
            this.writeln(60, "MI/API/Logging", "", null, e, true);
        }
        catch (IOException e) {
            this.writeln(60, "MI/API/Logging", "Could not open: " + file.getName(), null);
            this.writeln(60, "MI/API/Logging", "", null, e, true);
        }
    }

    public boolean reset() {
        return true;
    }

    public boolean switchOn(boolean on) {
        if (on != this.on) {
            if (on) {
                if (this.printProlog) {
                    System.out.print(this.formatter.getProlog());
                }
            } else if (this.printAppendix) {
                System.out.print(this.formatter.getAppendix());
            }
        }
        this.on = on;
        return true;
    }

    public void writeln(int severity, String component, String message, Object[] params, Throwable t, boolean printStacktrace) {
        if (!this.on) {
            return;
        }
        DefaultSystemLogWriter defaultSystemLogWriter = this;
        synchronized (defaultSystemLogWriter) {
            System.out.println(this.formatter.format(severity, component, message, params, t, printStacktrace));
        }
    }

    public void writeln(int severity, String component, String message, Object[] params) {
        if (!this.on) {
            return;
        }
        DefaultSystemLogWriter defaultSystemLogWriter = this;
        synchronized (defaultSystemLogWriter) {
            System.out.println(this.formatter.format(severity, component, message, params));
        }
    }

    public Vector getLogContent() {
        return new Vector(0);
    }

    public void initialize(String configurationPrefix) {
    }

    public void setPrintProlog(boolean printProlog) {
        this.printProlog = printProlog;
    }

    public void setPrintAppendix(boolean printAppendix) {
        this.printAppendix = printAppendix;
    }
}

