/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.logging;

import com.sap.ip.me.api.conf.MEVersion;
import com.sap.ip.me.api.logging.Severities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class DefaultMessageFormatter {
    private static final String UNKNOWN_COMPONENT = "Unknown";
    private static final String SPACES = "                         ";
    private final String newline = System.getProperty("line.separator", "\n");
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd HH:mm:ss:SSS");
    private final Object[] EMPTY_PARAMS = new Object[0];

    DefaultMessageFormatter() {
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    String format(int severity, String component, String message, Object[] params) {
        StringBuffer sb = new StringBuffer();
        String prefix = this.getMessagePrefix(severity, component);
        if (message == null) {
            message = "(null)";
        }
        if (params == null) {
            sb.append(prefix);
            this.handleLineBreaks(sb, message, prefix);
        } else {
            String resolvedMessage = this.getResolvedMessage(sb, message, params, prefix);
            if (resolvedMessage != null) {
                sb.append(prefix);
                this.handleLineBreaks(sb, resolvedMessage, prefix);
            }
        }
        return sb.toString();
    }

    String format(int severity, String component, String message, Object[] params, Throwable t, boolean printStacktrace) {
        StringBuffer sb = new StringBuffer();
        String prefix = this.getMessagePrefix(severity, component);
        if (params == null) {
            params = this.EMPTY_PARAMS;
        }
        if (t != null) {
            String tmessage = t.getMessage();
            if (tmessage == null) {
                tmessage = "no message available";
            }
            if (message == null) {
                sb.append(prefix);
                sb.append(t.getClass().getName()).append(": ");
                this.handleLineBreaks(sb, tmessage, prefix);
            } else {
                String resolvedMessage = this.getResolvedMessage(sb, message, params, prefix);
                if (resolvedMessage != null) {
                    sb.append(prefix);
                    int len = resolvedMessage.length() + (printStacktrace ? 0 : 20 + tmessage.length());
                    StringBuffer sb2 = new StringBuffer(len);
                    sb2.append(resolvedMessage);
                    if (!printStacktrace) {
                        sb2.append(" (root cause: ").append(tmessage).append(" [").append(t.getClass().getName()).append("])");
                    }
                    this.handleLineBreaks(sb, sb2.toString(), prefix);
                }
            }
        } else {
            sb.append(prefix);
            sb.append("Illegal argument: cannot log 'null' exceptions");
            sb.append(this.newline).append(prefix);
            if (message == null) {
                message = "no message available";
            }
            this.handleLineBreaks(sb, message, prefix);
        }
        if (printStacktrace && t != null) {
            sb.append(this.newline);
            this.handleLineBreaks(sb, this.getStackTrace(t), prefix);
        }
        return sb.toString();
    }

    void handleLineBreaks(StringBuffer target, String message, String prefix) {
        if (message == null) {
            return;
        }
        int currentPosition = 0;
        int toPosition = message.length();
        int length = message.length();
        int crPosition = this.nextCRPosition(message, 0);
        while (crPosition != -1) {
            if (crPosition == currentPosition) {
                if (++currentPosition >= length) break;
                crPosition = this.nextCRPosition(message, currentPosition);
                continue;
            }
            if (currentPosition < toPosition) {
                target.append(message.substring(currentPosition, crPosition));
            }
            currentPosition = crPosition + 1;
            while (currentPosition < length && (message.charAt(currentPosition) == '\n' || message.charAt(currentPosition) == '\r')) {
                ++currentPosition;
            }
            if (currentPosition < length) {
                target.append(this.newline);
            }
            crPosition = this.nextCRPosition(message, currentPosition);
        }
        if (currentPosition < length) {
            target.append(message.substring(currentPosition));
        }
    }

    private final int nextCRPosition(String message, int start) {
        int nextn = message.indexOf(10, start);
        int nextr = message.indexOf(13, start);
        if (nextn == -1 && nextr == -1) {
            return -1;
        }
        if (nextn == -1) {
            return nextr;
        }
        if (nextr == -1) {
            return nextn;
        }
        return Math.min(nextr, nextn);
    }

    String getProlog() {
        StringBuffer sb = new StringBuffer(250);
        String prefix = this.getMessagePrefix(70, "MI/API/Logging");
        sb.append(prefix).append("***** LOG / TRACE SWITCHED ON").append(this.newline);
        sb.append(prefix).append("***** Mobile Engine version: ").append(MEVersion.getFullName()).append(this.newline);
        sb.append(prefix).append("***** Current timezone: ").append(TimeZone.getDefault().getID());
        return sb.toString();
    }

    String getAppendix() {
        StringBuffer sb = new StringBuffer(50);
        String prefix = this.getMessagePrefix(70, "MI/API/Logging");
        sb.append(prefix).append("***** LOG / TRACE SWITCHED OFF");
        return sb.toString();
    }

    private String getMessagePrefix(int severity, String component) {
        StringBuffer sb = new StringBuffer(60);
        Date d = new Date();
        sb.append("[").append(this.dateFormatter.format(d)).append("] ");
        sb.append(Severities.getShortName(severity)).append(" ");
        String componentString = component == null || component.length() == 0 ? UNKNOWN_COMPONENT : component;
        sb.append("[").append(componentString);
        if (componentString.length() < 25) {
            sb.append(SPACES.substring(0, 25 - componentString.length()));
        }
        sb.append("] ");
        return sb.toString();
    }

    private String getMessagePrefixForContinuosLines(String message) {
        if (message == null || message.length() < 24) {
            return message;
        }
        StringBuffer sb = new StringBuffer(message);
        sb.setCharAt(24, 'C');
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String getResolvedMessage(StringBuffer sb, String message, Object[] params, String prefix) {
        block4: {
            block5: {
                try {
                    result = MessageFormat.format(message, params);
                    break block4;
                }
                catch (Exception ex) {
                    sb.append(prefix);
                    sb.append("Error while logging message: ");
                    this.handleLineBreaks(sb, message, prefix);
                    sb.append(this.newline);
                    if (params == null || params.length == 0) {
                        sb.append(prefix);
                        sb.append("    No arguments").append(this.newline);
                        break block5;
                    }
                    i = 0;
                    ** while (i < params.length)
                }
lbl-1000:
                // 1 sources

                {
                    sb.append("{");
                    sb.append(Integer.toString(i));
                    sb.append("} = ");
                    sb.append(params[i] == null ? "null" : params[i].toString()).append(this.newline);
                    ++i;
                    continue;
                }
            }
            sb.append(this.getStackTrace(ex));
            result = null;
        }
        return result;
    }

    private String getStackTrace(Throwable t) {
        StringWriter buf = new StringWriter();
        if (t != null) {
            PrintWriter out = new PrintWriter(buf);
            t.printStackTrace(out);
            out.flush();
        }
        return buf.toString();
    }
}

