/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.logging;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.DefaultMessageFormatter;
import com.sap.ip.me.api.logging.LogWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public class DefaultFileLogWriter
implements LogWriter {
    protected static final String LOG_FILENAME_SUFFIX = ".Filename";
    protected static final String LOG_MAXSIZE_SUFFIX = ".Filesize";
    private static final String BACKUP_EXTENSION = ".bak";
    DefaultMessageFormatter formatter = new DefaultMessageFormatter();
    private boolean switchedOn;
    private long maxSize;
    private long currentSize = 0L;
    private String filename = "";
    private File logFile;
    private PrintWriter writer;
    private String configurationPrefix;
    private boolean printProlog = false;
    private boolean printAppendix = false;

    public void writeln(int severity, String component, String message, Object[] params) {
        if (!this.isSwitchedOn() || this.getWriter() == null) {
            return;
        }
        PrintWriter printWriter = this.getWriter();
        synchronized (printWriter) {
            this.println(this.formatter.format(severity, component, message, params));
            this.getWriter().flush();
        }
    }

    public void writeln(int severity, String component, String message, Object[] params, Throwable t, boolean printStacktrace) {
        if (!this.isSwitchedOn() || this.getWriter() == null) {
            return;
        }
        PrintWriter printWriter = this.getWriter();
        synchronized (printWriter) {
            this.println(this.formatter.format(severity, component, message, params, t, printStacktrace));
            this.getWriter().flush();
        }
    }

    public synchronized boolean reset() {
        boolean s = this.isSwitchedOn();
        boolean success = false;
        File lf = this.getLogFile();
        this.switchOn(false);
        if (lf != null) {
            success = !lf.exists() || lf.delete();
            String lfpath = lf.getAbsolutePath();
            File backupfile = new File(lfpath + BACKUP_EXTENSION);
            boolean bl = success = success && (!backupfile.exists() || backupfile.delete());
        }
        if (s) {
            this.switchOn(true);
        }
        return success;
    }

    public void logFileContent(int severity, String component, File file, String encoding) {
        if (!this.isSwitchedOn() || file == null || this.getWriter() == null) {
            return;
        }
        BufferedReader reader = null;
        try {
            PrintWriter printWriter = this.getWriter();
            synchronized (printWriter) {
                String path = file.getAbsolutePath();
                this.println(this.formatter.format(severity, component, "Dumping file ''{0}''", new Object[]{path}));
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
                char[] readbuffer = new char[1024];
                int charsread = reader.read(readbuffer);
                while (charsread != -1) {
                    this.print(readbuffer, charsread);
                    this.getWriter().flush();
                    charsread = reader.read(readbuffer);
                }
                this.println("");
                reader.close();
                this.println(this.formatter.format(severity, component, "End of content of file  ''{0}''", new Object[]{path}));
            }
        }
        catch (FileNotFoundException e) {
            this.writeln(60, "MI/API/Logging", "File not found: " + file.getName(), null);
            this.writeln(60, "MI/API/Logging", "", null, e, true);
        }
        catch (IOException e) {
            this.writeln(60, "MI/API/Logging", "Could not open: " + file.getName(), null);
            this.writeln(60, "MI/API/Logging", "", null, e, true);
        }
    }

    public boolean switchOn(boolean on) {
        if (on) {
            this.switchOn();
        } else {
            this.switchOff();
        }
        return true;
    }

    public Vector getLogContent() {
        Vector<String> lines = new Vector<String>();
        String line = null;
        BufferedReader reader = null;
        String tracefilename = this.getAbsoluteFilename();
        File tracefile = new File(tracefilename);
        File backupfile = new File(tracefilename + BACKUP_EXTENSION);
        try {
            if (backupfile.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(backupfile), "UTF8"));
                while ((line = reader.readLine()) != null) {
                    lines.addElement(line);
                }
                reader.close();
            }
            if (tracefile.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tracefile), "UTF8"));
                while ((line = reader.readLine()) != null) {
                    lines.addElement(line);
                }
                reader.close();
            }
        }
        catch (FileNotFoundException e) {
            this.writeln(50, "MI/API/Logging", "File not found: " + tracefilename, null);
            this.writeln(60, "MI/API/Logging", "", null, e, true);
        }
        catch (IOException e) {
            this.writeln(50, "MI/API/Logging", "Could not open: " + tracefilename, null);
            this.writeln(60, "MI/API/Logging", "", null, e, true);
        }
        return lines;
    }

    public void initialize(String configurationPrefix) {
        this.configurationPrefix = configurationPrefix;
        this.refresh();
    }

    public void setPrintProlog(boolean printProlog) {
        this.printProlog = printProlog;
    }

    public void setPrintAppendix(boolean printAppendix) {
        this.printAppendix = printAppendix;
    }

    boolean isSwitchedOn() {
        return this.switchedOn;
    }

    void refresh() {
        this.readConfiguration();
    }

    private void createBackupFile() {
        PrintWriter printWriter;
        PrintWriter out;
        if (this.getMaxSize() <= 0L || this.getCurrentSize() / 1024L < this.getMaxSize() || this.getWriter() == null) {
            return;
        }
        File lf = this.getLogFile();
        if (lf != null && lf.exists()) {
            printWriter = out = this.getWriter();
            synchronized (printWriter) {
                if (this.printAppendix) {
                    out.println(this.formatter.getAppendix());
                }
                out.close();
                String fn = this.getAbsoluteFilename() + BACKUP_EXTENSION;
                File backupFile = new File(fn);
                if (backupFile.exists() && backupFile.canWrite()) {
                    backupFile.delete();
                }
                lf.renameTo(backupFile);
                lf = new File(this.getAbsoluteFilename());
                try {
                    if (!lf.exists()) {
                        this.setCurrentSize(0L);
                    } else {
                        this.setCurrentSize(lf.length());
                    }
                    this.setWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(lf.getAbsolutePath(), true), "UTF8")));
                    this.setLogFile(lf);
                }
                catch (IOException e) {
                    PrintStream syserr = System.err;
                    syserr.print("Log file with name: \"");
                    syserr.print(fn);
                    syserr.println("\" cannot be created.");
                    lf = null;
                }
                if (lf == null) {
                    this.setWriter(null);
                    this.setLogFile(null);
                }
            }
        }
        if ((out = this.getWriter()) == null) {
            return;
        }
        printWriter = out;
        synchronized (printWriter) {
            if (this.printProlog) {
                out.println(this.formatter.getProlog());
            }
        }
    }

    private void switchOn() {
        if (this.isSwitchedOn()) {
            return;
        }
        String fn = this.getAbsoluteFilename();
        File f = null;
        if (fn.length() > 0) {
            f = new File(fn);
            try {
                if (f.exists()) {
                    this.setCurrentSize(f.length());
                } else {
                    this.setCurrentSize(0L);
                    int lastFileSep = fn.lastIndexOf(File.separatorChar);
                    if (lastFileSep < 0) {
                        lastFileSep = fn.length();
                    }
                    File dir = new File(fn.substring(0, lastFileSep));
                    dir.mkdirs();
                }
                if (f.canWrite() || !f.exists()) {
                    this.setWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f.getAbsolutePath(), true), "UTF8")));
                    this.setLogFile(f);
                } else {
                    f = null;
                }
            }
            catch (IOException e) {
                PrintStream syserr = System.err;
                syserr.print("Log file with name: \"");
                syserr.print(fn);
                syserr.println("\" cannot be created.");
                e.printStackTrace(System.err);
                f = null;
            }
        }
        if (f == null) {
            this.setLogFile(null);
            this.setWriter(null);
        }
        this.switchedOn = true;
        PrintWriter out = this.getWriter();
        if (out == null) {
            return;
        }
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            if (this.printProlog) {
                out.println(this.formatter.getProlog());
            }
        }
    }

    private void switchOff() {
        if (!this.isSwitchedOn()) {
            return;
        }
        PrintWriter out = this.getWriter();
        if (out == null) {
            return;
        }
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            if (this.printAppendix) {
                out.println(this.formatter.getAppendix());
            }
            this.switchedOn = false;
            out.close();
        }
    }

    private long getMaxSize() {
        return this.maxSize;
    }

    private void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    private long getCurrentSize() {
        return this.currentSize;
    }

    private void setCurrentSize(long currentSize) {
        this.currentSize = currentSize;
    }

    private String getFilename() {
        return this.filename == null ? "" : this.filename;
    }

    private void setFilename(String filename) {
        this.filename = filename;
    }

    private String getAbsoluteFilename() {
        String fn = this.getFilename();
        if (fn != null) {
            if (fn.startsWith("/")) {
                fn = Configuration.getInstallationDirectory() + fn;
            }
        } else {
            fn = "";
        }
        return fn.replace('/', File.separatorChar);
    }

    private File getLogFile() {
        return this.logFile;
    }

    private void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    private PrintWriter getWriter() {
        return this.writer;
    }

    private void setWriter(PrintWriter logWriter) {
        this.writer = logWriter;
    }

    private void println(String msg) {
        if (msg == null || this.getWriter() == null) {
            return;
        }
        PrintWriter out = this.getWriter();
        out.println(msg);
        this.setCurrentSize(this.getCurrentSize() + (long)msg.length());
        this.createBackupFile();
    }

    private void print(char[] msg, int len) {
        if (msg == null || msg.length == 0) {
            return;
        }
        PrintWriter out = this.getWriter();
        out.write(msg, 0, len);
        this.setCurrentSize(this.getCurrentSize() + (long)len);
    }

    private void readConfiguration() {
        Configuration config = Configuration.getInstance();
        int prefixlength = this.configurationPrefix.length();
        StringBuffer sb = new StringBuffer(prefixlength + 15);
        sb.append(this.configurationPrefix);
        sb.append(LOG_FILENAME_SUFFIX);
        String newFilename = config.getProperty(sb.toString(), "");
        if (!newFilename.equals(this.getFilename()) && this.isSwitchedOn()) {
            this.switchOff();
        }
        this.setFilename(newFilename);
        sb.setLength(prefixlength);
        sb.append(LOG_MAXSIZE_SUFFIX);
        this.setMaxSize(config.getLong(sb.toString(), -1L));
    }
}

