/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.logging;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.LogWriter;
import java.io.File;
import java.util.Vector;

public abstract class AbstractLogging {
    protected static final String CONFIGURATION_PREFIX = "MobileEngine.";
    protected static final String LOG_ENABLED_SUFFIX = ".Enabled";
    protected static final String LOG_LEVEL_SUFFIX = ".Level";
    protected static final String LOGWRITER_IMPLEMENTATION_SUFFIX = ".Implementation";
    private static final String NULL = "(null)";
    private String component = "Unknown";

    public final void logFileContent(int severity, File file) {
        this.logFileContent(severity, file, "UTF8");
    }

    public void log(int severity, String message) {
        if (this.isLogging(severity)) {
            this.getLogWriter().writeln(severity, this.getComponent(), message, null);
        }
    }

    public void log(int severity, String message, Object param) {
        if (this.isLogging(severity)) {
            this.getLogWriter().writeln(severity, this.getComponent(), message, new Object[]{param == null ? NULL : param.toString()});
        }
    }

    public void log(int severity, String message, Object param1, Object param2) {
        if (this.isLogging(severity)) {
            this.getLogWriter().writeln(severity, this.getComponent(), message, new Object[]{param1 == null ? NULL : param1.toString(), param2 == null ? NULL : param2.toString()});
        }
    }

    public void log(int severity, String message, Object param1, Object param2, Object param3) {
        if (this.isLogging(severity)) {
            this.getLogWriter().writeln(severity, this.getComponent(), message, new Object[]{param1 == null ? NULL : param1.toString(), param2 == null ? NULL : param2.toString(), param3 == null ? NULL : param3.toString()});
        }
    }

    public void log(int severity, String message, Object[] params) {
        if (this.isLogging(severity)) {
            this.getLogWriter().writeln(severity, this.getComponent(), message, params);
        }
    }

    public void log(String message) {
        if (this.isLogging(70)) {
            this.getLogWriter().writeln(70, this.getComponent(), message, null);
        }
    }

    public void log(String message, Object param1) {
        if (this.isLogging(70)) {
            this.getLogWriter().writeln(70, this.getComponent(), message, new Object[]{param1 == null ? NULL : param1.toString()});
        }
    }

    public void log(String message, Object param1, Object param2) {
        if (this.isLogging(70)) {
            this.getLogWriter().writeln(70, this.getComponent(), message, new Object[]{param1 == null ? NULL : param1.toString(), param2 == null ? NULL : param2.toString()});
        }
    }

    public void log(String message, Object param1, Object param2, Object param3) {
        if (this.isLogging(70)) {
            this.getLogWriter().writeln(70, this.getComponent(), message, new Object[]{param1 == null ? NULL : param1.toString(), param2 == null ? NULL : param2.toString(), param3 == null ? NULL : param3.toString()});
        }
    }

    public void log(String message, Object[] params) {
        if (this.isLogging(70)) {
            this.getLogWriter().writeln(70, this.getComponent(), message, params);
        }
    }

    public void logException(int severity, String message, Object[] params, Throwable t, boolean printStackTrace) {
        this.getLogWriter().writeln(severity, this.getComponent(), message, params, t, printStackTrace);
    }

    public void logException(int severity, String message, Throwable t, boolean printStackTrace) {
        this.getLogWriter().writeln(severity, this.getComponent(), message, null, t, printStackTrace);
    }

    public void logException(String message, Throwable t, boolean printStackTrace) {
        this.getLogWriter().writeln(50, this.getComponent(), message, null, t, printStackTrace);
    }

    public void logException(int severity, Throwable t) {
        this.getLogWriter().writeln(severity, this.getComponent(), null, null, t, true);
    }

    public void logException(int severity, Throwable t, boolean printStackTrace) {
        this.getLogWriter().writeln(severity, this.getComponent(), null, null, t, printStackTrace);
    }

    public void logException(Throwable t) {
        this.getLogWriter().writeln(50, this.getComponent(), null, null, t, true);
    }

    public void logException(Throwable t, boolean printStackTrace) {
        this.getLogWriter().writeln(50, this.getComponent(), null, null, t, printStackTrace);
    }

    public abstract boolean switchOn(boolean var1);

    public void reset() {
        boolean oldState = this.isOn();
        if (oldState) {
            this.switchOn(false);
        }
        this.getLogWriter().reset();
        this.switchOn(oldState);
    }

    public abstract boolean isLogging(int var1);

    public void logFileContent(int severity, File file, String encoding) {
        if (this.isLogging(severity)) {
            this.getLogWriter().logFileContent(severity, this.getComponent(), file, encoding);
        }
    }

    public Vector read() {
        try {
            return this.getLogWriter().getLogContent();
        }
        catch (Exception ex) {
            this.logException(60, "Cannot read log content", null, ex, true);
            return new Vector();
        }
    }

    public abstract int getEffectiveSeverity();

    public abstract void setEffectiveSeverity(int var1);

    public abstract boolean isOn();

    public abstract void refresh();

    public String getComponent() {
        return this.component;
    }

    protected abstract LogWriter getLogWriter();

    protected abstract void setLogWriter(LogWriter var1);

    protected abstract void readConfiguration(String var1);

    protected void writeConfiguration(String logName, boolean userdependant) {
        if (logName == null || logName.length() == 0) {
            throw new IllegalArgumentException("Log name must not be null or empty");
        }
        Configuration config = Configuration.getInstance();
        int prefixlength = CONFIGURATION_PREFIX.length() + logName.length();
        StringBuffer sb = new StringBuffer(prefixlength + 15);
        sb.append(CONFIGURATION_PREFIX).append(logName).append(LOG_ENABLED_SUFFIX);
        if (userdependant) {
            config.setBoolean(sb.toString(), this.isOn());
        } else {
            config.setDefaultProperty(sb.toString(), String.valueOf(this.isOn()));
        }
        sb.setLength(prefixlength);
        sb.append(LOG_LEVEL_SUFFIX);
        if (userdependant) {
            config.setInt(sb.toString(), this.getEffectiveSeverity());
        } else {
            config.setDefaultProperty(sb.toString(), Integer.toString(this.getEffectiveSeverity()));
        }
        sb.setLength(prefixlength);
        sb.append(LOGWRITER_IMPLEMENTATION_SUFFIX);
        if (userdependant) {
            config.setProperty(sb.toString(), this.getLogWriterClassname());
        } else {
            config.setDefaultProperty(sb.toString(), this.getLogWriterClassname());
        }
    }

    protected abstract void setOn(boolean var1);

    protected abstract String getLogWriterClassname();

    protected void setComponent(String componentname) {
        if (componentname == null || componentname.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot set empty component name");
        }
        this.component = componentname.trim();
    }

    protected String getLogLevelName(int logLevel) {
        if (logLevel > 90) {
            return "All";
        }
        if (logLevel > 80) {
            return "Debug";
        }
        if (logLevel > 70) {
            return "Path";
        }
        if (logLevel > 60) {
            return "Info";
        }
        if (logLevel > 50) {
            return "Warning";
        }
        if (logLevel > 10) {
            return "Error";
        }
        if (logLevel > 0) {
            return "Fatal";
        }
        return "Unknown";
    }

    abstract String getLogName();
}

