/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.conf;

import com.sap.ip.me.api.conf.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class MEVersion {
    private static String mainVersion = null;
    private static String initialMainVersion = null;
    private static String build = null;
    private static String fullName = null;

    public static final String getMainVersion() {
        if (mainVersion == null) {
            MEVersion.readBuildFile();
        }
        return mainVersion;
    }

    public static final String getInitialMainVersion() {
        if (initialMainVersion == null) {
            MEVersion.readBuildFile();
        }
        return initialMainVersion;
    }

    public static final String getBuild() {
        if (build == null) {
            MEVersion.readBuildFile();
        }
        return build;
    }

    public static final String getFullName() {
        if (fullName == null) {
            MEVersion.readBuildFile();
        }
        return fullName;
    }

    private static void readBuildFile() {
        BufferedReader reader;
        String line;
        InputStream buildnoStream = null;
        try {
            buildnoStream = Configuration.getInstance().getClass().getResourceAsStream("/com/sap/ip/me/buildno.txt");
        }
        catch (Exception ex) {
            System.err.println("Cannot get build number file as resource");
            buildnoStream = null;
        }
        if (buildnoStream == null) {
            buildnoStream = MEVersion.getBuildNoTxtFileInputStream();
        }
        try {
            if (buildnoStream != null) {
                line = null;
                reader = new BufferedReader(new InputStreamReader(buildnoStream));
                line = reader.readLine().trim();
                if (line != null) {
                    mainVersion = line;
                }
                if ((line = reader.readLine().trim()) != null) {
                    build = line;
                }
                if ((line = reader.readLine().trim()) != null) {
                    fullName = line + " Build " + build;
                }
                reader.close();
            }
        }
        catch (Exception e) {
            System.err.println("Build number cannot be parsed");
        }
        buildnoStream = MEVersion.getBuildNoTxtFileInputStream();
        try {
            if (buildnoStream != null) {
                line = null;
                reader = new BufferedReader(new InputStreamReader(buildnoStream));
                line = reader.readLine().trim();
                if (line != null) {
                    initialMainVersion = line;
                }
                reader.close();
            }
        }
        catch (Exception e) {
            System.err.println("Build number cannot be parsed");
        }
        if (initialMainVersion == null) {
            initialMainVersion = "250900";
        }
        if (mainVersion == null) {
            mainVersion = initialMainVersion;
        }
        if (build == null) {
            build = "XXXX";
        }
        if (fullName == null) {
            fullName = "MI 2.5 SP 09 Patch 00 Build " + build;
        }
    }

    private static InputStream getBuildNoTxtFileInputStream() {
        FileInputStream buildnoStream;
        String s = Configuration.getInstallationDirectory();
        if (s == null) {
            System.err.println("Cannot get installation directory");
            buildnoStream = null;
        } else {
            StringBuffer filename = new StringBuffer(s.length() + 12);
            filename.append(s).append(File.separatorChar).append("buildno.txt");
            try {
                buildnoStream = new FileInputStream(filename.toString());
            }
            catch (FileNotFoundException filenotfound) {
                System.err.println("Cannot read build number file");
                buildnoStream = null;
            }
        }
        return buildnoStream;
    }
}

