/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.conf;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public final class Localization {
    private static final Trace trace = Trace.getInstance("MI/API/Configuration");
    private static final String SETTINGS_COUNTRIES = "MobileEngine.Settings.Countries";
    private static final String SETTINGS_LANGUAGES = "MobileEngine.Settings.Languages";
    private static Locale systemDefaultLocale = null;
    private static TimeZone systemDefaultTimeZone = null;

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void setLocale(Locale locale) {
        Locale.setDefault(locale);
        Configuration conf = Configuration.getInstance();
        conf.setProperty("MobileEngine.Sync.Language", Localization.getLanguageFromLocale(locale).toUpperCase());
        conf.setProperty("MobileEngine.Sync.Country", Localization.getCountryFromLocale(locale));
    }

    public static TimeZone getTimeZone() {
        String timeZoneStr = Configuration.getInstance().getProperty("MobileEngine.Sync.Timezone", "");
        if (timeZoneStr.length() == 0) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(timeZoneStr);
    }

    public static void setTimeZone(TimeZone timeZone) {
        Configuration.getInstance().setProperty("MobileEngine.Sync.Timezone", timeZone.getID());
        Configuration.getInstance().setDefaultProperty("MobileEngine.Sync.Timezone", timeZone.getID());
        TimeZone.setDefault(timeZone);
        trace.log("Formatted Date");
        trace.log(Localization.getFormatedDate());
        trace.log("Formatted Time");
        trace.log(Localization.getFormatedTime());
    }

    public static Vector getAllTimezones() {
        String[] tz = TimeZone.getAvailableIDs();
        Vector<String> timezoneList = new Vector<String>(tz.length);
        int i = 0;
        while (i < tz.length) {
            timezoneList.addElement(tz[i]);
            ++i;
        }
        return timezoneList;
    }

    public static Vector getAllLanguages() {
        Vector<String> languageList = new Vector<String>();
        String langStr = Configuration.getInstance().getProperty(SETTINGS_LANGUAGES, "");
        StringTokenizer st = new StringTokenizer(langStr, ",");
        while (st.hasMoreTokens()) {
            String lang = st.nextToken().trim();
            languageList.addElement(lang);
        }
        return languageList;
    }

    public static String getLanguage() {
        return Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "").toLowerCase();
    }

    public static void setLanguage(String languageIso) {
        Configuration.getInstance().setProperty("MobileEngine.Sync.Language", languageIso.toUpperCase());
        Configuration.getInstance().setDefaultProperty("MobileEngine.Sync.Language", languageIso.toUpperCase());
        Localization.setDefaultLocaleIntern();
    }

    public static Vector getAllCountriesLongName() {
        Vector<String> countryList = new Vector<String>();
        String countryStr = Configuration.getInstance().getProperty(SETTINGS_COUNTRIES, "");
        String currentLang = Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "").toLowerCase();
        StringTokenizer st = new StringTokenizer(countryStr, ",");
        while (st.hasMoreTokens()) {
            String countryIso = st.nextToken().trim().toUpperCase();
            String countryName = new Locale(currentLang.toLowerCase(), countryIso).getDisplayCountry();
            countryList.addElement(countryName);
        }
        return countryList;
    }

    public static Vector getAllCountriesIsoName() {
        Vector<String> countryList = new Vector<String>();
        String countryStr = Configuration.getInstance().getProperty(SETTINGS_COUNTRIES, "");
        StringTokenizer st = new StringTokenizer(countryStr, ",");
        while (st.hasMoreTokens()) {
            String countryIso = st.nextToken().trim().toUpperCase();
            countryList.addElement(countryIso);
        }
        return countryList;
    }

    public static Vector getAllCountries() {
        Vector countryList = new Vector();
        String countryStr = Configuration.getInstance().getProperty(SETTINGS_COUNTRIES, "");
        String currentLang = Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "").toLowerCase();
        StringTokenizer st = new StringTokenizer(countryStr, ",");
        while (st.hasMoreTokens()) {
            String countryIso = st.nextToken().trim().toUpperCase();
            Locale locale = new Locale(currentLang.toLowerCase(), countryIso);
            Localization.insertLocale(countryList, locale);
        }
        return countryList;
    }

    public static Vector getAllCountriesSorted() {
        Vector<String[]> countryList = new Vector<String[]>();
        String countryStr = Configuration.getInstance().getProperty(SETTINGS_COUNTRIES, "");
        String currentLang = Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "").toLowerCase();
        StringTokenizer st = new StringTokenizer(countryStr, ",");
        String[] s = new String[st.countTokens()];
        int i = 0;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        while (st.hasMoreTokens()) {
            String countryIso = st.nextToken().trim().toUpperCase();
            Locale locale = new Locale(currentLang.toLowerCase(), countryIso);
            ht.put(locale.getDisplayCountry(), locale.getCountry());
            s[i++] = locale.getDisplayCountry();
        }
        Localization.quickSort(s, 0, s.length - 1);
        int j = 0;
        while (j < s.length) {
            String[] countryColumn = new String[]{(String)ht.get(s[j]), s[j]};
            countryList.addElement(countryColumn);
            ++j;
        }
        return countryList;
    }

    public static String getCountry() {
        String countryStr = Configuration.getInstance().getProperty("MobileEngine.Sync.Country", "").toUpperCase();
        if (countryStr.length() == 0) {
            countryStr = Localization.getCountryFromLocale(Locale.getDefault());
        }
        return countryStr.toUpperCase();
    }

    public static void setCountry(String isoCountry) {
        Configuration.getInstance().setProperty("MobileEngine.Sync.Country", isoCountry);
        Localization.setDefaultLocaleIntern();
    }

    public static String getFormatedDate() {
        Date curTime = new Date();
        DateFormat df = DateFormat.getDateInstance();
        return df.format(curTime);
    }

    public static String getFormatedDate(long l) {
        Date curTime = new Date(l);
        DateFormat df = DateFormat.getDateInstance();
        return df.format(curTime);
    }

    public static String getFormatedTime() {
        Date curTime = new Date();
        DateFormat tf = DateFormat.getTimeInstance(2, Localization.getLocale());
        return tf.format(curTime);
    }

    public static String getFormatedTime(long l) {
        Date curTime = new Date(l);
        DateFormat tf = DateFormat.getTimeInstance(2, Localization.getLocale());
        return tf.format(curTime);
    }

    private static void insertLocale(Vector countryList, Locale locale) {
        String countryName = locale.getDisplayCountry();
        if (countryList.size() == 0) {
            countryList.addElement(locale);
        } else {
            int i = 0;
            while (i < countryList.size()) {
                String c = ((Locale)countryList.elementAt(i)).getDisplayCountry();
                if (countryName.compareTo(c) == 0) {
                    return;
                }
                if (countryName.compareTo(c) < 0) {
                    countryList.insertElementAt(locale, i);
                    return;
                }
                ++i;
            }
            countryList.addElement(locale);
        }
    }

    private static String getLanguageFromLocale(Locale locale) {
        return locale.getLanguage();
    }

    private static String getCountryFromLocale(Locale locale) {
        return locale.getCountry();
    }

    private static void setDefaultTimezoneIntern() {
        String timezoneStr = Configuration.getInstance().getProperty("MobileEngine.Sync.Timezone", "");
        if (timezoneStr.length() == 0) {
            timezoneStr = systemDefaultTimeZone.getID();
        }
        TimeZone.setDefault(TimeZone.getTimeZone(timezoneStr));
    }

    private static void setDefaultLocaleIntern() {
        String language = Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "").toLowerCase();
        String country = Configuration.getInstance().getProperty("MobileEngine.Sync.Country", "").toUpperCase();
        if (language.length() == 0) {
            language = Localization.getLanguageFromLocale(systemDefaultLocale);
        }
        if (country.length() == 0) {
            country = Localization.getCountryFromLocale(systemDefaultLocale);
        }
        Locale.setDefault(new Locale(language, country));
    }

    /*
     * Unable to fully structure code
     */
    private static void quickSort(String[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl18
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo].compareTo(mid) < 0) continue block0;
                    while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    t = a[hi];
                    a[hi] = a[lo];
                    a[lo] = t;
                    ++lo;
                    --hi;
lbl18:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                Localization.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Localization.quickSort(a, lo, hi0);
            }
        }
    }

    static {
        systemDefaultLocale = Locale.getDefault();
        systemDefaultTimeZone = TimeZone.getDefault();
        Localization.setDefaultLocaleIntern();
        Localization.setDefaultTimezoneIntern();
    }
}

