/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.conf;

import com.sap.ip.me.api.conf.FactoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class Configuration {
    private static final String DEFAULT_PROPERTIES = "/com/sap/ip/me/defaults.properties";
    private static final String GET_INSTANCE = "getInstance";
    private static final Configuration instance;
    private static final int ENCRYPT_KEY = 30;
    private final Properties defaultProperties = new Properties();
    private final MeProperties userDefaultProperties = new MeProperties(this.defaultProperties);
    private final MeProperties properties = new MeProperties(this.userDefaultProperties);
    private final MeProperties temporary = new MeProperties(this.properties);
    private static String SETTINGS_FOLDER;
    private static String INSTALLATION_DIRECTORY;
    private static final Vector EMPTY_VECTOR;
    static /* synthetic */ Class class$com$sap$ip$me$api$conf$Configuration;

    private Configuration() {
        try {
            InputStream defProps = this.getClass().getResourceAsStream(DEFAULT_PROPERTIES);
            this.defaultProperties.load(defProps);
            defProps.close();
        }
        catch (Exception ex) {
            System.err.println("Cannot load default configuration file '/com/sap/ip/me/defaults.properties' because " + ex);
            ex.printStackTrace(System.err);
        }
    }

    public static final String getJVMVendorName() {
        return System.getProperty("java.vendor");
    }

    public static final String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public static final String getMERuntime() {
        return Configuration.getInstance().getProperty("Runtime", "tomcat").toUpperCase();
    }

    public static final String getSettingsFolder() {
        return SETTINGS_FOLDER;
    }

    public static final String getInstallationDirectory() {
        return INSTALLATION_DIRECTORY;
    }

    public static Configuration getInstance() {
        return instance;
    }

    public void loadConfiguration(String configurationFile) {
        this.userDefaultProperties.setPropertyFilename(configurationFile);
        this.finalizeInit();
    }

    public void switchUserConfiguration(String username) {
        int usernamelength = username == null ? 0 : username.length();
        String userFilename = null;
        if (username != null) {
            StringBuffer sb = new StringBuffer(SETTINGS_FOLDER.length() + usernamelength + 8);
            sb.append(SETTINGS_FOLDER).append(username).append(".uconfig");
            userFilename = sb.toString();
        }
        this.properties.setPropertyFilename(userFilename);
    }

    public void setTemporary(String key, String value) {
        ((Hashtable)this.temporary).put(key, value);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setDefaultProperty(String key, String value) {
        this.userDefaultProperties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.temporary.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.temporary.getProperty(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.temporary.getBoolean(key, defaultValue);
    }

    public void setBoolean(String key, boolean value) {
        this.properties.setBoolean(key, value);
    }

    public int getInt(String key, int defaultValue) {
        return this.temporary.getInt(key, defaultValue);
    }

    public void setInt(String key, int value) {
        this.properties.setInt(key, value);
    }

    public long getLong(String key, long defaultValue) {
        return this.temporary.getLong(key, defaultValue);
    }

    public void setLong(String key, long value) {
        this.properties.setLong(key, value);
    }

    public void setEncodedProperty(String key, String value) {
        this.properties.setEncodedProperty(key, value);
    }

    public String getDecodedProperty(String key) {
        return this.temporary.getDecodedProperty(key);
    }

    public Vector getKeysWithPrefix(String prefix) {
        if (prefix == null) {
            return EMPTY_VECTOR;
        }
        Vector result = new Vector(16);
        this.temporary.getPropertyKeysWithPrefix(prefix, result);
        return result;
    }

    public Object getSingletonInstanceForType(String key) {
        Properties props = System.getProperties();
        Object singletonInstance = ((Hashtable)props).get(key);
        if (singletonInstance == null) {
            singletonInstance = this.createInstanceForType(key);
            ((Hashtable)props).put(key, singletonInstance);
        }
        return singletonInstance;
    }

    public Object getInstanceForType(String key) {
        String clazzname = this.getProperty(key);
        try {
            Class clazz = class$com$sap$ip$me$api$conf$Configuration == null ? (class$com$sap$ip$me$api$conf$Configuration = Configuration.class$("com.sap.ip.me.api.conf.Configuration")) : class$com$sap$ip$me$api$conf$Configuration;
            Class<?> clazz2 = Class.forName(clazzname);
            Method m = clazz2.getDeclaredMethod(GET_INSTANCE, null);
            return m.invoke(null, null);
        }
        catch (Exception t) {
            t.printStackTrace(System.err);
            throw new FactoryException("Exception while instantiating " + clazzname, t);
        }
    }

    private Object createInstanceForType(String key) {
        String clazzname = this.getProperty(key);
        try {
            Class clazz = class$com$sap$ip$me$api$conf$Configuration == null ? (class$com$sap$ip$me$api$conf$Configuration = Configuration.class$("com.sap.ip.me.api.conf.Configuration")) : class$com$sap$ip$me$api$conf$Configuration;
            Class<?> clazz2 = Class.forName(clazzname);
            return clazz2.newInstance();
        }
        catch (Exception t) {
            t.printStackTrace(System.err);
            throw new FactoryException("Exception while instantiating " + clazzname, t);
        }
    }

    private void finalizeInit() {
        String instDir;
        INSTALLATION_DIRECTORY = instDir = this.getProperty("MobileEngine.InstallationPath");
        StringBuffer sb = new StringBuffer(instDir.length() + 10);
        sb.append(instDir);
        sb.append(File.separatorChar);
        sb.append("settings");
        sb.append(File.separatorChar);
        SETTINGS_FOLDER = sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SETTINGS_FOLDER = null;
        INSTALLATION_DIRECTORY = null;
        EMPTY_VECTOR = new Vector(0);
        Properties props = System.getProperties();
        Object value = ((Hashtable)props).get("com.sap.ip.me.api.conf.Configuration");
        if (value == null) {
            instance = new Configuration();
            ((Hashtable)props).put("com.sap.ip.me.api.conf.Configuration", instance);
        } else {
            instance = (Configuration)value;
        }
    }

    private class MeProperties
    extends Properties {
        File propertyFile = null;

        MeProperties(Properties parent) {
            super(parent);
        }

        public void loadConfiguration() {
            if (this.propertyFile == null) {
                System.err.println("Cannot load 'null' configuration file.");
                return;
            }
            Properties newProperties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(this.propertyFile);
                newProperties.load(fis);
                fis.close();
                ((Hashtable)this).clear();
                Enumeration keys = ((Hashtable)newProperties).keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ((Hashtable)this).put(key, newProperties.getProperty(key));
                }
            }
            catch (FileNotFoundException fex) {
            }
            catch (IOException ioex) {
                System.err.println("Cannot load configuration file '" + this.propertyFile + "' because " + ioex);
            }
        }

        public Object setProperty(String key, String value) {
            String old = this.getProperty(key);
            if (value != null && !value.equals(old)) {
                ((Hashtable)this).put(key, value);
                this.saveConfiguration();
            }
            return old;
        }

        public String getProperty(String key) {
            return super.getProperty(key);
        }

        public String getProperty(String key, String defaultValue) {
            return super.getProperty(key, defaultValue);
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            String value = super.getProperty(key);
            if (value == null) {
                return defaultValue;
            }
            return "true".equalsIgnoreCase(value) || "x".equalsIgnoreCase(value);
        }

        public void setBoolean(String key, boolean value) {
            this.setProperty(key, String.valueOf(value));
        }

        public int getInt(String key, int defaultValue) {
            int result = defaultValue;
            try {
                result = Integer.parseInt(super.getProperty(key));
            }
            catch (Exception ex) {
                // empty catch block
            }
            return result;
        }

        public void setInt(String key, int value) {
            this.setProperty(key, Integer.toString(value, 10));
        }

        public long getLong(String key, long defaultValue) {
            long result = defaultValue;
            try {
                result = Long.parseLong(super.getProperty(key));
            }
            catch (Exception ex) {
                // empty catch block
            }
            return result;
        }

        public void setLong(String key, long value) {
            this.setProperty(key, Long.toString(value, 10));
        }

        public void setEncodedProperty(String key, String value) {
            if (value == null) {
                value = "";
            }
            ((Hashtable)this).put(key, this.xorString(value, 30));
            this.saveConfiguration();
        }

        public String getDecodedProperty(String key) {
            String property = super.getProperty(key);
            if (property == null) {
                property = "";
            }
            return this.xorString(property, 30);
        }

        void getPropertyKeysWithPrefix(String prefix, Vector result) {
            String key;
            if (prefix == null) {
                return;
            }
            Enumeration keys = ((Hashtable)this).keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.startsWith(prefix) || result.contains(key)) continue;
                result.addElement(key);
            }
            if (this.defaults == null) {
                return;
            }
            if (this.defaults instanceof MeProperties) {
                ((MeProperties)this.defaults).getPropertyKeysWithPrefix(prefix, result);
            } else {
                keys = ((Hashtable)this.defaults).keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    if (!key.startsWith(prefix) || result.contains(key)) continue;
                    result.addElement(key);
                }
            }
        }

        void setPropertyFilename(String filename) {
            if (filename == null) {
                this.propertyFile = null;
                ((Hashtable)this).clear();
            } else {
                this.propertyFile = new File(filename);
                this.loadConfiguration();
            }
        }

        private String xorString(String string, int key) {
            char[] source = string.toCharArray();
            int i = 0;
            while (i < source.length) {
                source[i] = (char)(source[i] ^ key);
                ++i;
            }
            return new String(source);
        }

        private void saveConfiguration() {
            if (this.propertyFile == null) {
                return;
            }
            try {
                String folder;
                if (!this.propertyFile.exists() && (folder = this.propertyFile.getParent()) != null) {
                    File dir = new File(folder);
                    dir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(this.propertyFile);
                this.save(fos, null);
                fos.close();
            }
            catch (IOException ioex) {
                System.err.println("Cannot save configuration file '" + this.propertyFile + "' because " + ioex);
                ioex.printStackTrace(System.err);
            }
        }
    }
}

