/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.util;

import java.io.Serializable;
import java.util.Vector;

public final class StringBuf
implements Serializable {
    private int fCapacity;
    private int fLength;
    private char[] fCharArray;

    public StringBuf() {
        this(16);
    }

    public StringBuf(int pCapacity) {
        this.fCapacity = 1 > pCapacity ? 16 : pCapacity;
        this.fCharArray = new char[this.fCapacity];
        this.fLength = 0;
    }

    public StringBuf(int pLength, char pFillChar) {
        this(pLength);
        while (this.fLength < pLength) {
            this.fCharArray[this.fLength++] = pFillChar;
        }
    }

    public StringBuf(char[] pCharArray) {
        this(null != pCharArray ? pCharArray.length + 16 : 16);
        if (null != pCharArray) {
            this.fLength = pCharArray.length;
            System.arraycopy(pCharArray, 0, this.fCharArray, 0, this.fLength);
        }
    }

    public StringBuf(char[] pCharArray, int pOffset, int pLength) {
        this(null != pCharArray ? pLength + 16 : 16);
        if (null != pCharArray) {
            if (0 > pOffset || 1 > pLength || pOffset + pLength > pCharArray.length) {
                this.throwOutOfBounds(pOffset + pLength);
            }
            this.fLength = pLength;
            System.arraycopy(pCharArray, 0, this.fCharArray, pOffset, this.fLength);
        }
    }

    public StringBuf(StringBuf pStrBuf) {
        this(null != pStrBuf ? pStrBuf.fLength + 16 : 16);
        if (null != pStrBuf) {
            this.fLength = pStrBuf.fLength;
            System.arraycopy(pStrBuf.fCharArray, 0, pStrBuf.fCharArray, 0, this.fLength);
        }
    }

    public StringBuf(StringBuf pStrBuf, int pOffset, int pLength) {
        this(0 > pLength ? pLength + 16 : 16);
        if (null != pStrBuf) {
            if (0 > pOffset || 1 > pLength || pOffset + pLength > pStrBuf.fLength) {
                this.throwOutOfBounds(pOffset + pLength);
            }
            this.fLength = pLength;
            System.arraycopy(pStrBuf.fCharArray, pOffset, this.fCharArray, 0, this.fLength);
        }
    }

    public StringBuf(String pString) {
        this(null != pString ? pString.length() + 16 : 16);
        if (null != pString) {
            this.fLength = pString.length();
            pString.getChars(0, this.fLength, this.fCharArray, 0);
        }
    }

    public StringBuf(String pString, int pOffset, int pLength) {
        this(null != pString ? pString.length() + 16 : 16);
        if (null != pString) {
            if (0 > pOffset || 1 > pLength || pOffset + pLength > pString.length()) {
                this.throwOutOfBounds(pOffset + pLength);
            }
            this.fLength = pLength;
            pString.getChars(0, this.fLength, this.fCharArray, 0);
        }
    }

    public void ensureCapacity(int pTotalCapacity) {
        if (this.fCapacity < pTotalCapacity) {
            char[] newCharArray = new char[pTotalCapacity];
            System.arraycopy(this.fCharArray, 0, newCharArray, 0, this.fCapacity);
            this.fCharArray = newCharArray;
            this.fCapacity = pTotalCapacity;
        }
    }

    public void ensureFreeCapacity(int pFreeCapacity) {
        if (this.fCapacity < pFreeCapacity + this.fLength) {
            this.ensureCapacity(this.fLength + 4 + 1 * pFreeCapacity);
        }
    }

    public char[] createCharArray(int pOffset, int pLength) {
        if (1 > pLength || 0 > pOffset || this.fLength < pLength + pOffset) {
            this.throwOutOfBounds(pLength + pOffset);
        }
        char[] newCharArray = new char[pLength];
        System.arraycopy(this.fCharArray, pOffset, newCharArray, 0, pLength);
        return newCharArray;
    }

    public StringBuf createStringBuf(int pOffset, int pLength) {
        return new StringBuf(this, pOffset, pLength);
    }

    public String createString(int pOffset, int pLength) {
        if (1 > pLength || 0 > pOffset || this.fLength < pLength + pOffset) {
            this.throwOutOfBounds(pLength + pOffset);
        }
        return new String(this.fCharArray, pOffset, pLength);
    }

    public StringBuf append(char pNewChar) {
        this.ensureFreeCapacity(1);
        this.fCharArray[this.fLength++] = pNewChar;
        return this;
    }

    public StringBuf append(char[] pSrcArray) {
        int addLength = pSrcArray.length;
        this.ensureFreeCapacity(addLength);
        System.arraycopy(pSrcArray, 0, this.fCharArray, this.fLength, addLength);
        this.fLength += addLength;
        return this;
    }

    public StringBuf append(StringBuf pSrcBuf) {
        if (null == pSrcBuf || 0 == pSrcBuf.fLength) {
            return this;
        }
        int addLength = pSrcBuf.fLength;
        this.ensureFreeCapacity(addLength);
        System.arraycopy(pSrcBuf.fCharArray, 0, this.fCharArray, this.fLength, addLength);
        this.fLength += addLength;
        return this;
    }

    public StringBuf append(String pSrcString) {
        int addLength = pSrcString.length();
        this.ensureFreeCapacity(addLength);
        pSrcString.getChars(0, addLength, this.fCharArray, this.fLength);
        this.fLength += addLength;
        return this;
    }

    public void copyValue(int pPos, int pLength, char[] pDstArray, int pOffset) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pDstArray.length) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pPos || pPos + pLength > this.fLength) {
            this.throwOutOfBounds(pPos + pLength);
        }
        System.arraycopy(this.fCharArray, pPos, pDstArray, pOffset, pLength);
    }

    public void copyValue(int pPos, int pLength, StringBuf pDstBuf, int pOffset) {
        if (0 > pOffset || 1 > pLength || pOffset > pDstBuf.fLength) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pPos || pPos + pLength > this.fLength) {
            this.throwOutOfBounds(pPos + pLength);
        }
        if (pOffset + pLength > pDstBuf.fLength) {
            pDstBuf.ensureCapacity(pLength + pOffset);
            pDstBuf.fLength = pLength + pOffset;
            System.arraycopy(this.fCharArray, pPos, pDstBuf.fCharArray, pOffset, pLength);
        } else {
            System.arraycopy(this.fCharArray, pPos, pDstBuf.fCharArray, pOffset, pLength);
        }
    }

    public boolean equals(char[] pCompareArray) {
        if (pCompareArray.length != this.fLength) {
            return false;
        }
        int ii = 0;
        while (ii < this.fLength) {
            if (this.fCharArray[ii] != pCompareArray[ii]) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public boolean equals(StringBuf pCompareBuf) {
        if (pCompareBuf.fLength != this.fLength) {
            return false;
        }
        int ii = 0;
        while (ii < this.fLength) {
            if (this.fCharArray[ii] != pCompareBuf.fCharArray[ii]) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public boolean equals(String pCompareString) {
        if (pCompareString.length() != this.fLength) {
            return false;
        }
        char[] compareArray = pCompareString.toCharArray();
        int ii = 0;
        while (ii < this.fLength) {
            if (this.fCharArray[ii] != compareArray[ii]) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public StringBuf insertAt(int pPos, char pNewChar) {
        return this.insertAt(pPos, pNewChar, 1);
    }

    public StringBuf insertAt(int pPos, char pNewChar, int pRepetitions) {
        this.ensureFreeCapacity(pRepetitions);
        if (this.fLength <= pPos || 0 > pRepetitions) {
            while (0 < pRepetitions) {
                this.fCharArray[this.fLength++] = pNewChar;
                --pRepetitions;
            }
        } else {
            int moveLength = this.fLength - pPos;
            int moveOffset = pPos + pRepetitions;
            System.arraycopy(this.fCharArray, pPos, this.fCharArray, moveOffset, moveLength);
            while (0 < pRepetitions) {
                this.fCharArray[pPos++] = pNewChar;
                --pRepetitions;
            }
        }
        return this;
    }

    public StringBuf insertAt(int pPos, char[] pSrcArray, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pSrcArray.length) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        this.ensureFreeCapacity(pLength);
        if (this.fLength <= pPos) {
            System.arraycopy(pSrcArray, pOffset, this.fCharArray, this.fLength, pLength);
        } else {
            int moveLength = this.fLength - pPos;
            int moveOffset = pPos + pLength;
            System.arraycopy(this.fCharArray, pPos, this.fCharArray, moveOffset, moveLength);
            System.arraycopy(pSrcArray, pOffset, this.fCharArray, pPos, pLength);
        }
        this.fLength += pLength;
        return this;
    }

    public StringBuf insertAt(int pPos, StringBuf pSrcBuf, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pSrcBuf.fLength) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        this.ensureFreeCapacity(pLength);
        if (this.fLength <= pPos) {
            System.arraycopy(pSrcBuf.fCharArray, pOffset, this.fCharArray, this.fLength, pLength);
        } else {
            int moveLength = this.fLength - pPos;
            int moveOffset = pPos + pLength;
            System.arraycopy(this.fCharArray, pPos, this.fCharArray, moveOffset, moveLength);
            System.arraycopy(pSrcBuf.fCharArray, pOffset, this.fCharArray, pPos, pLength);
        }
        this.fLength += pLength;
        return this;
    }

    public StringBuf insertAt(int pPos, String pSrcStr) {
        return this.insertAt(pPos, pSrcStr, 0, pSrcStr.length());
    }

    public StringBuf insertAt(int pPos, String pSrcStr, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pSrcStr.length()) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        this.ensureFreeCapacity(pLength);
        if (this.fLength <= pPos) {
            pSrcStr.getChars(pOffset, pOffset + pLength, this.fCharArray, this.fLength);
        } else {
            int moveLength = this.fLength - pPos;
            int moveOffset = pPos + pLength;
            System.arraycopy(this.fCharArray, pPos, this.fCharArray, moveOffset, moveLength);
            pSrcStr.getChars(pOffset, pOffset + pLength, this.fCharArray, pPos);
        }
        this.fLength += pLength;
        return this;
    }

    public StringBuf modifyAt(int pPos, char pNewChar, int pRepetitions) {
        if (0 > pPos || 1 > pRepetitions || pPos + pRepetitions > this.fLength) {
            this.throwOutOfBounds(pPos + pRepetitions);
        }
        while (0 < pRepetitions) {
            this.fCharArray[pPos++] = pNewChar;
            --pRepetitions;
        }
        return this;
    }

    public StringBuf modifyAt(int pPos, char[] pSrcArray, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pSrcArray.length) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pPos || pPos + pLength > this.fLength) {
            this.throwOutOfBounds(pPos + pLength);
        }
        System.arraycopy(pSrcArray, pOffset, this.fCharArray, pPos, pLength);
        return this;
    }

    public StringBuf modifyAt(int pPos, StringBuf pSrcBuf, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pSrcBuf.fLength) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pPos || pPos + pLength > this.fLength) {
            this.throwOutOfBounds(pPos + pLength);
        }
        System.arraycopy(pSrcBuf.fCharArray, pOffset, this.fCharArray, pPos, pLength);
        return this;
    }

    public StringBuf modifyAt(int pPos, String pSrcStr, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pSrcStr.length()) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pPos || pPos + pLength > this.fLength) {
            this.throwOutOfBounds(pPos + pLength);
        }
        pSrcStr.getChars(pOffset, pOffset + pLength, this.fCharArray, pPos);
        return this;
    }

    public StringBuf removeAt(int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > this.fLength) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (pLength == this.fLength) {
            this.fLength = 0;
        } else {
            int posTail = pOffset + pLength;
            if (posTail < this.fLength) {
                int lenTail = this.fLength - posTail;
                System.arraycopy(this.fCharArray, posTail, this.fCharArray, pOffset, lenTail);
            }
            this.fLength -= pLength;
        }
        this.fCharArray[this.fLength] = '\u0000';
        return this;
    }

    public StringBuf replace(char pOld, char pNew) {
        int ii = 0;
        while (ii < this.fLength) {
            if (pOld == this.fCharArray[ii]) {
                this.fCharArray[ii] = pNew;
            }
            ++ii;
        }
        return this;
    }

    public StringBuf replace(char[] pOld, char pNew) {
        int ii = 0;
        while (ii < this.fLength) {
            int jj = 0;
            while (jj < pOld.length) {
                if (pOld[jj] == this.fCharArray[ii]) {
                    this.fCharArray[ii] = pNew;
                }
                ++jj;
            }
            ++ii;
        }
        return this;
    }

    public StringBuf replace(char[] pOldArray, char[] pNewArray) {
        int sumDelta;
        int lenDelta;
        int oldLen = pOldArray.length;
        int newLen = pNewArray.length;
        if (0 == oldLen) {
            return this;
        }
        IVector modPositions = new IVector();
        int curPos = 0;
        int nxtPos = this.indexOf(curPos, pOldArray, 0, oldLen);
        while (0 <= nxtPos) {
            modPositions.add(nxtPos);
            curPos = nxtPos + oldLen;
            nxtPos = this.indexOf(curPos, pOldArray, 0, oldLen);
        }
        if (0 == curPos) {
            return this;
        }
        if (oldLen == newLen) {
            int ii = 0;
            while (ii < modPositions.getLength()) {
                this.modifyAt(modPositions.getValue(ii), pNewArray, 0, oldLen);
                ++ii;
            }
        } else if (oldLen < newLen) {
            int posMove;
            lenDelta = newLen - oldLen;
            sumDelta = modPositions.getLength() * lenDelta;
            this.ensureFreeCapacity(sumDelta);
            int posTail = this.fLength;
            int ii = modPositions.getLength() - 1;
            while (ii >= 0) {
                int posRead = modPositions.getValue(ii);
                int lenMove = posTail - posRead;
                posMove = posRead + lenDelta * (ii + 1);
                posTail = posRead;
                System.arraycopy(this.fCharArray, posRead, this.fCharArray, posMove, lenMove);
                --ii;
            }
            this.fLength += sumDelta;
            int jj = 0;
            while (jj < modPositions.getLength()) {
                int posOrig = modPositions.getValue(jj);
                posMove = posOrig + lenDelta * jj;
                System.arraycopy(pNewArray, 0, this.fCharArray, posMove, newLen);
                ++jj;
            }
        } else {
            int posMove;
            int posOrig;
            lenDelta = oldLen - newLen;
            sumDelta = modPositions.getLength() * lenDelta;
            modPositions.add(this.fLength);
            int posHead = modPositions.getValue(0);
            int ii = 1;
            while (ii < modPositions.getLength()) {
                posOrig = modPositions.getValue(ii);
                int lenMove = posOrig - posHead;
                int posRead = posHead + oldLen;
                posMove = posRead - lenDelta * ii;
                if (0 != lenMove) {
                    System.arraycopy(this.fCharArray, posRead, this.fCharArray, posMove, lenMove);
                }
                posHead = posOrig;
                ++ii;
            }
            this.fLength -= sumDelta;
            int jj = 0;
            while (jj < modPositions.getLength() - 1) {
                posOrig = modPositions.getValue(jj);
                posMove = posOrig - lenDelta * jj;
                System.arraycopy(pNewArray, 0, this.fCharArray, posMove, newLen);
                ++jj;
            }
        }
        return this;
    }

    public StringBuf replace(StringBuf pOldBuf, StringBuf pNewBuf) {
        int sumDelta;
        int lenDelta;
        int oldLen = pOldBuf.fLength;
        int newLen = pNewBuf.fLength;
        if (0 == oldLen) {
            return this;
        }
        IVector modPositions = new IVector();
        int curPos = 0;
        int nxtPos = this.indexOf(curPos, pOldBuf, 0, oldLen);
        while (0 <= nxtPos) {
            modPositions.add(nxtPos);
            curPos = nxtPos + oldLen;
            nxtPos = this.indexOf(curPos, pOldBuf, 0, oldLen);
        }
        if (0 == curPos) {
            return this;
        }
        if (oldLen == newLen) {
            int ii = 0;
            while (ii < modPositions.getLength()) {
                this.modifyAt(modPositions.getValue(ii), pNewBuf, 0, oldLen);
                ++ii;
            }
        } else if (oldLen < newLen) {
            int posMove;
            lenDelta = newLen - oldLen;
            sumDelta = modPositions.getLength() * lenDelta;
            this.ensureFreeCapacity(sumDelta);
            int posTail = this.fLength;
            int ii = modPositions.getLength() - 1;
            while (ii >= 0) {
                int posRead = modPositions.getValue(ii);
                int lenMove = posTail - posRead;
                posMove = posRead + lenDelta * (ii + 1);
                posTail = posRead;
                System.arraycopy(this.fCharArray, posRead, this.fCharArray, posMove, lenMove);
                --ii;
            }
            this.fLength += sumDelta;
            int jj = 0;
            while (jj < modPositions.getLength()) {
                int posOrig = modPositions.getValue(jj);
                posMove = posOrig + lenDelta * jj;
                System.arraycopy(pNewBuf.fCharArray, 0, this.fCharArray, posMove, newLen);
                ++jj;
            }
        } else {
            int posMove;
            int posOrig;
            lenDelta = oldLen - newLen;
            sumDelta = modPositions.getLength() * lenDelta;
            modPositions.add(this.fLength);
            int posHead = modPositions.getValue(0);
            int ii = 1;
            while (ii < modPositions.getLength()) {
                posOrig = modPositions.getValue(ii);
                int lenMove = posOrig - posHead;
                int posRead = posHead + oldLen;
                posMove = posRead - lenDelta * ii;
                if (0 != lenMove) {
                    System.arraycopy(this.fCharArray, posRead, this.fCharArray, posMove, lenMove);
                }
                posHead = posOrig;
                ++ii;
            }
            this.fLength -= sumDelta;
            int jj = 0;
            while (jj < modPositions.getLength() - 1) {
                posOrig = modPositions.getValue(jj);
                posMove = posOrig - lenDelta * jj;
                System.arraycopy(pNewBuf.fCharArray, 0, this.fCharArray, posMove, newLen);
                ++jj;
            }
        }
        return this;
    }

    public StringBuf replace(String pOldStr, String pNewStr) {
        int sumDelta;
        int lenDelta;
        int oldLen = pOldStr.length();
        int newLen = pNewStr.length();
        if (0 == oldLen) {
            return this;
        }
        char[] scanArray = pOldStr.toCharArray();
        IVector modPositions = new IVector();
        int curPos = 0;
        int nxtPos = this.indexOf(curPos, scanArray, 0, oldLen);
        while (0 <= nxtPos) {
            modPositions.add(nxtPos);
            curPos = nxtPos + oldLen;
            nxtPos = this.indexOf(curPos, scanArray, 0, oldLen);
        }
        if (0 == curPos) {
            return this;
        }
        if (oldLen == newLen) {
            int ii = 0;
            while (ii < modPositions.getLength()) {
                this.modifyAt(modPositions.getValue(ii), pNewStr, 0, oldLen);
                ++ii;
            }
        } else if (oldLen < newLen) {
            int posMove;
            lenDelta = newLen - oldLen;
            sumDelta = modPositions.getLength() * lenDelta;
            this.ensureFreeCapacity(sumDelta);
            int posTail = this.fLength;
            int ii = modPositions.getLength() - 1;
            while (ii >= 0) {
                int posRead = modPositions.getValue(ii);
                int lenMove = posTail - posRead;
                posMove = posRead + lenDelta * (ii + 1);
                posTail = posRead;
                System.arraycopy(this.fCharArray, posRead, this.fCharArray, posMove, lenMove);
                --ii;
            }
            this.fLength += sumDelta;
            int jj = 0;
            while (jj < modPositions.getLength()) {
                int posOrig = modPositions.getValue(jj);
                posMove = posOrig + lenDelta * jj;
                pNewStr.getChars(0, newLen, this.fCharArray, posMove);
                ++jj;
            }
        } else {
            int posMove;
            int posOrig;
            lenDelta = oldLen - newLen;
            sumDelta = modPositions.getLength() * lenDelta;
            modPositions.add(this.fLength);
            int posHead = modPositions.getValue(0);
            int ii = 1;
            while (ii < modPositions.getLength()) {
                posOrig = modPositions.getValue(ii);
                int lenMove = posOrig - posHead;
                int posRead = posHead + oldLen;
                posMove = posRead - lenDelta * ii;
                if (0 != lenMove) {
                    System.arraycopy(this.fCharArray, posRead, this.fCharArray, posMove, lenMove);
                }
                posHead = posOrig;
                ++ii;
            }
            this.fLength -= sumDelta;
            int jj = 0;
            while (jj < modPositions.getLength() - 1) {
                posOrig = modPositions.getValue(jj);
                posMove = posOrig - lenDelta * jj;
                pNewStr.getChars(0, newLen, this.fCharArray, posMove);
                ++jj;
            }
        }
        return this;
    }

    public StringBuf replaceAt(int pDstPos, int pOldLen, char[] pSrcArray, int pSrcPos, int pNewLen) {
        if (pOldLen == pNewLen) {
            return this.modifyAt(pDstPos, pSrcArray, pSrcPos, pOldLen);
        }
        if (0 > pSrcPos || 1 > pNewLen || pSrcPos + pNewLen > pSrcArray.length) {
            this.throwOutOfBounds(pSrcPos + pNewLen);
        }
        if (0 > pDstPos || 1 > pOldLen || pDstPos + pOldLen > this.fLength) {
            this.throwOutOfBounds(pDstPos + pOldLen);
        }
        if (pOldLen < pNewLen) {
            int deltaLen = pNewLen - pOldLen;
            int moveLen = this.fLength - (pDstPos + pOldLen);
            this.ensureFreeCapacity(deltaLen);
            if (0 < moveLen) {
                System.arraycopy(this.fCharArray, pDstPos + pOldLen, this.fCharArray, pDstPos + pNewLen, moveLen);
            }
            this.fLength += deltaLen;
            System.arraycopy(pSrcArray, pSrcPos, this.fCharArray, pDstPos, pNewLen);
        } else {
            int deltaLen = pOldLen - pNewLen;
            int moveLen = this.fLength - (pDstPos + pOldLen);
            if (0 < moveLen) {
                System.arraycopy(this.fCharArray, pDstPos + pOldLen, this.fCharArray, pDstPos + pNewLen, moveLen);
            }
            this.fLength -= deltaLen;
            System.arraycopy(pSrcArray, pSrcPos, this.fCharArray, pDstPos, pNewLen);
        }
        return this;
    }

    public StringBuf replaceAt(int pDstPos, int pOldLen, StringBuf pSrcBuf, int pSrcPos, int pNewLen) {
        if (pOldLen == pNewLen) {
            return this.modifyAt(pDstPos, pSrcBuf, pSrcPos, pOldLen);
        }
        if (0 > pSrcPos || 1 > pNewLen || pSrcPos + pNewLen > pSrcBuf.fLength) {
            this.throwOutOfBounds(pSrcPos + pNewLen);
        }
        if (0 > pDstPos || 1 > pOldLen || pDstPos + pOldLen > this.fLength) {
            this.throwOutOfBounds(pDstPos + pOldLen);
        }
        if (pOldLen < pNewLen) {
            int deltaLen = pNewLen - pOldLen;
            int moveLen = this.fLength - (pDstPos + pOldLen);
            this.ensureFreeCapacity(deltaLen);
            if (0 < moveLen) {
                System.arraycopy(this.fCharArray, pDstPos + pOldLen, this.fCharArray, pDstPos + pNewLen, moveLen);
            }
            this.fLength += deltaLen;
            System.arraycopy(pSrcBuf.fCharArray, pSrcPos, this.fCharArray, pDstPos, pNewLen);
        } else {
            int deltaLen = pOldLen - pNewLen;
            int moveLen = this.fLength - (pDstPos + pOldLen);
            if (0 < moveLen) {
                System.arraycopy(this.fCharArray, pDstPos + pOldLen, this.fCharArray, pDstPos + pNewLen, moveLen);
            }
            this.fLength -= deltaLen;
            System.arraycopy(pSrcBuf.fCharArray, pSrcPos, this.fCharArray, pDstPos, pNewLen);
        }
        return this;
    }

    public StringBuf replaceAt(int pDstPos, int pOldLen, String pSrcStr, int pSrcPos, int pNewLen) {
        if (pOldLen == pNewLen) {
            return this.modifyAt(pDstPos, pSrcStr, pSrcPos, pOldLen);
        }
        if (0 > pSrcPos || 1 > pNewLen || pSrcPos + pNewLen > pSrcStr.length()) {
            this.throwOutOfBounds(pSrcPos + pNewLen);
        }
        if (0 > pDstPos || 1 > pOldLen || pDstPos + pOldLen > this.fLength) {
            this.throwOutOfBounds(pDstPos + pOldLen);
        }
        if (pOldLen < pNewLen) {
            int deltaLen = pNewLen - pOldLen;
            int moveLen = this.fLength - (pDstPos + pOldLen);
            this.ensureFreeCapacity(deltaLen);
            if (0 < moveLen) {
                System.arraycopy(this.fCharArray, pDstPos + pOldLen, this.fCharArray, pDstPos + pNewLen, moveLen);
            }
            this.fLength += deltaLen;
            pSrcStr.getChars(pSrcPos, pSrcPos + pNewLen, this.fCharArray, pDstPos);
        } else {
            int deltaLen = pOldLen - pNewLen;
            int moveLen = this.fLength - (pDstPos + pOldLen);
            if (0 < moveLen) {
                System.arraycopy(this.fCharArray, pDstPos + pOldLen, this.fCharArray, pDstPos + pNewLen, moveLen);
            }
            this.fLength -= deltaLen;
            pSrcStr.getChars(pSrcPos, pSrcPos + pNewLen, this.fCharArray, pDstPos);
        }
        return this;
    }

    public StringBuf replaceWhitespace() {
        int ii = 0;
        while (ii < this.fLength) {
            if (Character.isWhitespace(this.fCharArray[ii])) {
                this.fCharArray[ii] = 32;
            }
            ++ii;
        }
        return this;
    }

    public int getCapacity() {
        return this.fCapacity;
    }

    public char getCharAt(int pPos) {
        if (0 > pPos || pPos >= this.fLength) {
            return '\u0000';
        }
        return this.fCharArray[pPos];
    }

    public int getLength() {
        return this.fLength;
    }

    public StringBuf setLength(int pLength) {
        if (pLength > this.fLength) {
            this.ensureCapacity(pLength);
            while (this.fLength < pLength) {
                this.fCharArray[this.fLength++] = '\u0000';
            }
        } else if (pLength < 1) {
            this.fLength = 0;
            this.fCharArray[0] = '\u0000';
        } else {
            this.fLength = pLength;
            this.fCharArray[this.fLength] = '\u0000';
        }
        return this;
    }

    public int lastIndexOf(char pChar) {
        return this.lastIndexOf(this.fLength - 1, pChar);
    }

    public int lastIndexOf(int pUprNdx, char pChar) {
        if (pUprNdx >= this.fLength) {
            pUprNdx = this.fLength - 1;
        }
        int ii = pUprNdx;
        while (ii >= 0) {
            if (this.fCharArray[ii] == pChar) {
                return ii;
            }
            --ii;
        }
        return -1;
    }

    public int lastIndexOf(char[] pArray) {
        return this.lastIndexOf(0, pArray, 0, pArray.length);
    }

    public int lastIndexOf(int pUprNdx, char[] pArray) {
        return this.lastIndexOf(pUprNdx, pArray, 0, pArray.length);
    }

    public int lastIndexOf(String pString) {
        return this.lastIndexOf(pString.toCharArray());
    }

    public int lastIndexOf(int pUprNdx, char[] pArray, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pArray.length) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pUprNdx || pUprNdx > this.fLength) {
            return -1;
        }
        if (pUprNdx + pLength > this.fLength) {
            pUprNdx = this.fLength - pLength;
        }
        int ii = pUprNdx;
        while (ii >= 0) {
            block6: {
                int jj = pOffset;
                int kk = ii;
                while (jj < pLength) {
                    if (pArray[jj] == this.fCharArray[kk]) {
                        ++jj;
                        ++kk;
                        continue;
                    }
                    break block6;
                }
                return ii;
            }
            --ii;
        }
        return -1;
    }

    public int lastIndexOf(StringBuf pBuf) {
        return this.lastIndexOf(this.fLength, pBuf, 0, pBuf.fLength);
    }

    public int lastIndexOf(int pUprNdx, StringBuf pBuf) {
        return this.lastIndexOf(pUprNdx, pBuf, 0, pBuf.fLength);
    }

    public int lastIndexOf(int pUprNdx, StringBuf pBuf, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pBuf.fLength) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pUprNdx || pUprNdx > this.fLength) {
            return -1;
        }
        if (pUprNdx + pLength > this.fLength) {
            pUprNdx = this.fLength - pLength;
        }
        char[] scanArray = pBuf.fCharArray;
        int ii = pUprNdx;
        while (ii >= 0) {
            block6: {
                int jj = pOffset;
                int kk = ii;
                while (jj < pLength) {
                    if (scanArray[jj] == this.fCharArray[kk]) {
                        ++jj;
                        ++kk;
                        continue;
                    }
                    break block6;
                }
                return ii;
            }
            --ii;
        }
        return -1;
    }

    public int indexOf(char pChar) {
        return this.indexOf(0, pChar);
    }

    public int indexOf(int pLwrNdx, char pChar) {
        if (0 > pLwrNdx) {
            return -1;
        }
        int ii = pLwrNdx;
        while (ii < this.fLength) {
            if (this.fCharArray[ii] == pChar) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public int indexOf(char[] pArray) {
        return this.indexOf(0, pArray, 0, pArray.length);
    }

    public int indexOf(int pLwrNdx, char[] pArray) {
        return this.indexOf(pLwrNdx, pArray, 0, pArray.length);
    }

    public int indexOf(int pLwrNdx, char[] pArray, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pArray.length) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pLwrNdx || pLwrNdx > this.fLength) {
            return -1;
        }
        int lastPos = this.fLength - pLength;
        int ii = pLwrNdx;
        while (ii <= lastPos) {
            block5: {
                int jj = pOffset;
                int kk = ii;
                while (jj < pLength) {
                    if (pArray[jj] == this.fCharArray[kk]) {
                        ++jj;
                        ++kk;
                        continue;
                    }
                    break block5;
                }
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public int indexOf(String pString) {
        return this.indexOf(pString.toCharArray());
    }

    public int indexOf(StringBuf pBuf) {
        return this.indexOf(0, pBuf, 0, pBuf.fLength);
    }

    public int indexOf(int pLwrNdx, StringBuf pBuf) {
        return this.indexOf(pLwrNdx, pBuf, 0, pBuf.fLength);
    }

    public int indexOf(int pLwrNdx, StringBuf pBuf, int pOffset, int pLength) {
        if (0 > pOffset || 1 > pLength || pOffset + pLength > pBuf.fLength) {
            this.throwOutOfBounds(pOffset + pLength);
        }
        if (0 > pLwrNdx || pLwrNdx > this.fLength) {
            return -1;
        }
        char[] cmpArray = pBuf.fCharArray;
        int lastPos = this.fLength - pLength;
        int ii = pLwrNdx;
        while (ii <= lastPos) {
            block5: {
                int jj = pOffset;
                int kk = ii;
                while (jj < pLength) {
                    if (cmpArray[jj] == this.fCharArray[kk]) {
                        ++jj;
                        ++kk;
                        continue;
                    }
                    break block5;
                }
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public boolean endsWith(char[] postfix) {
        int offset = this.fLength - postfix.length;
        if (0 <= offset) {
            int count = 0;
            char[] cmpArray = postfix;
            while (count < postfix.length) {
                if (cmpArray[count] != this.fCharArray[offset + count]) {
                    return false;
                }
                ++count;
            }
            return true;
        }
        return false;
    }

    public boolean endsWith(String postfix) {
        int offset = this.fLength - postfix.length();
        if (0 <= offset) {
            int count = 0;
            char[] cmpArray = postfix.toCharArray();
            while (count < postfix.length()) {
                if (cmpArray[count] != this.fCharArray[offset + count]) {
                    return false;
                }
                ++count;
            }
            return true;
        }
        return false;
    }

    public boolean endsWith(StringBuf postfix) {
        int offset = this.fLength - postfix.fLength;
        if (0 <= offset) {
            int count = 0;
            char[] cmpArray = postfix.fCharArray;
            while (count < postfix.fLength) {
                if (cmpArray[count] != this.fCharArray[offset + count]) {
                    return false;
                }
                ++count;
            }
            return true;
        }
        return false;
    }

    public String[] splitToString(char[] pSeparator) {
        if (null == pSeparator || 0 == pSeparator.length) {
            this.throwOutOfBounds(0);
        }
        int pos_cur = 0;
        int pos_nxt = 0;
        pos_nxt = this.indexOf(pos_cur, pSeparator, 0, pSeparator.length);
        if (0 > pos_nxt) {
            return new String[]{this.toString()};
        }
        Vector<String> result = new Vector<String>(10);
        int len_nxt = pos_nxt - pos_cur;
        if (0 < len_nxt) {
            result.add(this.createString(pos_cur, len_nxt));
        }
        pos_cur = pos_nxt + pSeparator.length;
        while (pos_cur < this.fLength) {
            pos_nxt = this.indexOf(pos_cur, pSeparator, 0, pSeparator.length);
            if (0 > pos_nxt) {
                len_nxt = this.fLength - pos_cur;
                result.add(this.createString(pos_cur, len_nxt));
                pos_cur = this.fLength + 1;
                continue;
            }
            len_nxt = pos_nxt - pos_cur;
            if (0 < len_nxt) {
                result.add(this.createString(pos_cur, len_nxt));
            }
            pos_cur = pos_nxt + pSeparator.length;
        }
        Object[] resultArray = new String[result.size()];
        result.copyInto(resultArray);
        return resultArray;
    }

    public StringBuf[] splitToStringBuf(char[] pSeparator) {
        if (null == pSeparator || 0 == pSeparator.length) {
            this.throwOutOfBounds(0);
        }
        int pos_cur = 0;
        int pos_nxt = 0;
        pos_nxt = this.indexOf(pos_cur, pSeparator, 0, pSeparator.length);
        if (0 > pos_nxt) {
            return new StringBuf[]{new StringBuf(this)};
        }
        Vector<StringBuf> result = new Vector<StringBuf>(10);
        int len_nxt = pos_nxt - pos_cur;
        if (0 < len_nxt) {
            result.add(this.createStringBuf(pos_cur, len_nxt));
        }
        pos_cur = pos_nxt + pSeparator.length;
        while (pos_cur < this.fLength) {
            pos_nxt = this.indexOf(pos_cur, pSeparator, 0, pSeparator.length);
            if (0 > pos_nxt) {
                len_nxt = this.fLength - pos_cur;
                result.add(this.createStringBuf(pos_cur, len_nxt));
                pos_cur = this.fLength + 1;
                continue;
            }
            len_nxt = pos_nxt - pos_cur;
            if (0 < len_nxt) {
                result.add(this.createStringBuf(pos_cur, len_nxt));
            }
            pos_cur = pos_nxt + pSeparator.length;
        }
        Object[] resultArray = new StringBuf[result.size()];
        result.copyInto(resultArray);
        return resultArray;
    }

    public boolean startsWith(char[] prefix) {
        int upperNdx = prefix.length;
        if (this.fLength >= upperNdx) {
            char[] cmpArray = prefix;
            while (upperNdx-- > 0) {
                if (cmpArray[upperNdx] == this.fCharArray[upperNdx]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean startsWith(String prefix) {
        int upperNdx = prefix.length();
        if (this.fLength >= upperNdx) {
            char[] cmpArray = prefix.toCharArray();
            while (upperNdx-- > 0) {
                if (cmpArray[upperNdx] == this.fCharArray[upperNdx]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean startsWith(StringBuf prefix) {
        int upperNdx = prefix.fLength;
        if (this.fLength >= upperNdx) {
            char[] cmpArray = prefix.fCharArray;
            while (upperNdx-- > 0) {
                if (cmpArray[upperNdx] == this.fCharArray[upperNdx]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void throwOutOfBounds(int length) {
        throw new StringIndexOutOfBoundsException(length);
    }

    public StringBuf toLower() {
        int ii = 0;
        while (ii < this.fLength) {
            if (Character.isUpperCase(this.fCharArray[ii])) {
                this.fCharArray[ii] = Character.toLowerCase(this.fCharArray[ii]);
            }
            ++ii;
        }
        return this;
    }

    public StringBuf toUpper() {
        int ii = 0;
        while (ii < this.fLength) {
            if (Character.isLowerCase(this.fCharArray[ii])) {
                this.fCharArray[ii] = Character.toUpperCase(this.fCharArray[ii]);
            }
            ++ii;
        }
        return this;
    }

    public String toString() {
        return new String(this.fCharArray, 0, this.fLength);
    }

    public StringBuf trim() {
        int jj = this.fLength - 1;
        while (0 < this.fLength && Character.isWhitespace(this.fCharArray[jj])) {
            --jj;
            --this.fLength;
        }
        jj = 0;
        while (jj < this.fLength && Character.isWhitespace(this.fCharArray[jj])) {
            ++jj;
        }
        if (0 != jj) {
            this.fLength -= jj;
            System.arraycopy(this.fCharArray, jj, this.fCharArray, 0, this.fLength);
        }
        return this;
    }

    static class IVector {
        private int[] fIntArray = new int[10];
        private int fLength = 0;
        private int fCapacity = 10;

        protected IVector() {
        }

        protected void add(int pValue) {
            if (this.fLength == this.fCapacity) {
                this.fCapacity += 10;
                int[] newArray = new int[this.fCapacity];
                System.arraycopy(this.fIntArray, 0, newArray, 0, this.fLength);
                this.fIntArray = newArray;
            }
            this.fIntArray[this.fLength++] = pValue;
        }

        protected int getLength() {
            return this.fLength;
        }

        protected int getValue(int pIndex) {
            if (0 > pIndex || pIndex > this.fLength) {
                throw new ArrayIndexOutOfBoundsException(pIndex);
            }
            return this.fIntArray[pIndex];
        }
    }
}

