/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.util;

import com.sap.tc.jtools.jver.ide.eclipse.util.StringBuf;

public final class StackInfo {
    private static final String AT = "at";
    private String fClazzName;
    private String fPackageName;
    private String fFullName;
    private int fLineNumber;

    public static StackInfo newInstance(String pTraceLine) {
        StackInfo newInst = new StackInfo();
        StackInfo.decomposeTraceLine(newInst, pTraceLine);
        return newInst;
    }

    public void setTrace(String pTraceLine) {
        this.init();
        StackInfo.decomposeTraceLine(this, pTraceLine);
    }

    public String getClassName() {
        return this.fClazzName;
    }

    public String getFullName() {
        return this.fFullName;
    }

    public String getPackageName() {
        return this.fPackageName;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    private StackInfo() {
        this.init();
    }

    private void init() {
        this.fClazzName = null;
        this.fFullName = null;
        this.fLineNumber = -1;
        this.fPackageName = null;
    }

    private static void decomposeTraceLine(StackInfo pInst, String pTraceLine) {
        try {
            int jj;
            int cntDot;
            String clasName = null;
            String pckgName = null;
            String javaName = null;
            String fullName = null;
            int lineNbr = -1;
            StringBuf lineBuf = new StringBuf(pTraceLine).trim();
            if (0 != lineBuf.indexOf(AT)) {
                return;
            }
            int posLPara = lineBuf.lastIndexOf('(');
            int posRPara = lineBuf.lastIndexOf(')');
            int posDolar = lineBuf.lastIndexOf('$');
            int posDoubl = lineBuf.lastIndexOf(':');
            int posStart = 3;
            while (' ' == lineBuf.getCharAt(posStart)) {
                ++posStart;
            }
            if (0 >= posDolar) {
                cntDot = -2;
                jj = posLPara;
                while (0 < jj && null == pckgName) {
                    if ('.' == lineBuf.getCharAt(jj)) {
                        if (0 == ++cntDot) {
                            pckgName = lineBuf.createString(posStart, jj - posStart);
                        } else if (-1 == cntDot) {
                            fullName = lineBuf.createString(posStart, jj - posStart);
                        }
                    }
                    --jj;
                }
            } else if (lineBuf.indexOf(posDolar, '.') < posLPara) {
                fullName = lineBuf.createString(posStart, posDolar - posStart);
                pckgName = fullName.substring(0, fullName.lastIndexOf(46));
            } else {
                cntDot = -2;
                jj = posDolar;
                while (0 < jj && null == pckgName) {
                    if ('.' == lineBuf.getCharAt(jj)) {
                        if (0 == ++cntDot) {
                            pckgName = lineBuf.createString(posStart, jj - posStart);
                        } else if (-1 == cntDot) {
                            fullName = lineBuf.createString(posStart, jj - posStart);
                        }
                    }
                    --jj;
                }
            }
            if (0 < posDoubl) {
                try {
                    int posLineNbr = posDoubl + 1;
                    int lenLineNbr = posRPara - posLineNbr;
                    lineNbr = Integer.parseInt(lineBuf.createString(posLineNbr, lenLineNbr));
                }
                catch (NumberFormatException ignore) {
                    lineNbr = -1;
                }
                javaName = lineBuf.createString(posLPara + 1, posDoubl - posLPara - 1);
                if (javaName.endsWith(".java")) {
                    clasName = lineBuf.createString(posLPara + 1, posDoubl - posLPara - 6);
                }
            } else {
                clasName = fullName.substring(fullName.lastIndexOf(46) + 1);
                lineNbr = -1;
            }
            pInst.fFullName = fullName;
            pInst.fPackageName = pckgName;
            pInst.fClazzName = clasName;
            pInst.fLineNumber = lineNbr;
        }
        catch (StringIndexOutOfBoundsException eIgnore) {
            pInst.init();
        }
    }
}

