/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.util;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler fgSingleton = new ExceptionHandler();

    public static void handle(CoreException pException, Shell pParentShell, String pTitle, String pMessage) {
        Plugin.log(pException);
        IStatus status = pException.getStatus();
        if (null != status) {
            ErrorDialog.openError((Shell)pParentShell, (String)pTitle, (String)pMessage, (IStatus)status);
        } else {
            ExceptionHandler.displayMessageDialog(pException, pException.getMessage(), pParentShell, pTitle, pMessage);
        }
    }

    public static void handle(InvocationTargetException pException, Shell pParentShell, String pTitle, String pMessage) {
        Throwable target = pException.getTargetException();
        if (target instanceof CoreException) {
            ExceptionHandler.handle((CoreException)target, pParentShell, pTitle, pMessage);
        } else {
            Plugin.log(pException);
            if (pException.getMessage() != null && 0 < pException.getMessage().length()) {
                ExceptionHandler.displayMessageDialog(pException, pException.getMessage(), pParentShell, pTitle, pMessage);
            } else {
                ExceptionHandler.displayMessageDialog(pException, target.getMessage(), pParentShell, pTitle, pMessage);
            }
        }
    }

    public static void handle(Throwable pException, Shell pParentShell, String pTitle, String pMessage) {
        if (pException instanceof CoreException) {
            ExceptionHandler.handle((CoreException)pException, pParentShell, pTitle, pMessage);
        } else {
            Plugin.log(pException);
            if (pException.getMessage() != null && 0 < pException.getMessage().length()) {
                ExceptionHandler.displayMessageDialog(pException, pException.getMessage(), pParentShell, pTitle, pMessage);
            } else {
                ExceptionHandler.displayMessageDialog(pException, pException.toString(), pParentShell, pTitle, pMessage);
            }
        }
    }

    private static void displayMessageDialog(Throwable pThrowable, String pExceptionMessage, Shell pParentShell, String pTitle, String pMessage) {
        StringWriter msg = new StringWriter();
        if (null != pMessage) {
            msg.write(pMessage);
            msg.write("\n\n");
        }
        if (null != pExceptionMessage && 0 != pExceptionMessage.length()) {
            msg.write(pExceptionMessage);
        }
        MessageDialog.openError((Shell)pParentShell, (String)pTitle, (String)msg.toString());
    }
}

