/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.sorcerer;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.sorcerer.LayoutTool;
import com.sap.tc.jtools.jver.ide.eclipse.sorcerer.TemplateMethodButtonGroup;
import com.sap.tc.jtools.jver.ide.eclipse.sorcerer.TextKeySrc;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TestsetConjurerPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "Jver.TestsetConjurerPage";
    private static final String TESTSET_NAME = "Jver.TestsetConjurerPage.testsetname";
    private static final int NDX_ATTRIBS = 0;
    private static final int NDX_PREPARE = 1;
    private static final int NDX_CLEANUP = 2;
    private static final int NDX_SAMPLE = 3;
    private static final int NDX_VERBOSE = 4;
    protected static final String VERBOSE_COMMENTS = "Jver.TestsetConjurerPage.VERBOSECOMMENTS";
    protected static final String STORE_CREATEATTRIBUTES = "Jver.TestsetConjurerPage.CREATEATTRIBUTES";
    protected static final String STORE_PREPARE = "Jver.TestsetConjurerPage.PREPARE";
    protected static final String STORE_CLEANUP = "Jver.TestsetConjurerPage.CLEANUP";
    protected static final String STORE_SAMPLE = "Jver.TestsetConjurerPage.SAMPLE";
    private IPackageFragment fCurrentPackage;
    private Label fTestsetNameLabel;
    private Text fTestsetNameText;
    private String fTestsetNameTextInitialValue = "";
    private TemplateMethodButtonGroup fMethodStubsButtons;
    private boolean fUpdatedExistingClassButton;
    protected IStatus fTestsetNameStatus;
    private boolean fInitDone = false;
    private boolean fFirstTime = true;
    private final IStatus[] fSuccessStatus;

    public TestsetConjurerPage() {
        super(true, PAGE_NAME);
        this.setTitle(TextKeySrc.T104.getText());
        this.setDescription(TextKeySrc.T105.getText());
        String[] buttonNames = new String[]{TextKeySrc.T107.getText(), TextKeySrc.T108.getText(), TextKeySrc.T109.getText(), TextKeySrc.T111.getText(), TextKeySrc.T106.getText()};
        this.fMethodStubsButtons = new TemplateMethodButtonGroup(32, buttonNames, 1);
        this.fMethodStubsButtons.setLabelText(TextKeySrc.T110.getText());
        this.fSuccessStatus = new IStatus[1];
        this.fSuccessStatus[0] = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.setSuperClass("com.sap.tc.jtools.jver.framework.Test", true);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTestsetNameControl(composite, nColumns);
        this.setTestsetName("TestThis", true);
        this.createSeparator(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        this.fInitDone = true;
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutTool.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutTool.createEmptySpace(composite, 1);
        LayoutTool.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.fMethodStubsButtons.setSelection(0, false);
        this.fMethodStubsButtons.setSelection(1, true);
        this.fMethodStubsButtons.setSelection(2, true);
        this.fMethodStubsButtons.setSelection(3, true);
        this.fMethodStubsButtons.setSelection(4, true);
        this.doStatusUpdate();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewTypeWizardPage.package")) {
            this.fPackageStatus = this.packageChanged();
            ((NewContainerWizardPage)this).fContainerStatus = this.checkJverLibExistence();
        } else if (fieldName.equals(TESTSET_NAME)) {
            this.fTestsetNameStatus = this.testsetChanged();
            ((NewContainerWizardPage)this).fContainerStatus = this.checkJverLibExistence();
        } else if (fieldName.equals("NewContainerWizardPage.container")) {
            ((NewContainerWizardPage)this).fContainerStatus = this.checkJverLibExistence();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        if (!this.fInitDone) {
            this.updateStatus(this.fSuccessStatus);
            return;
        }
        IStatus[] tempStatus = new IStatus[3];
        int curCount = 0;
        if (null != ((NewContainerWizardPage)this).fContainerStatus && !((NewContainerWizardPage)this).fContainerStatus.isOK()) {
            tempStatus[curCount++] = ((NewContainerWizardPage)this).fContainerStatus;
        }
        if (null != this.fPackageStatus && !this.fPackageStatus.isOK()) {
            tempStatus[curCount++] = this.fPackageStatus;
        }
        if (null != this.fTestsetNameStatus && !this.fTestsetNameStatus.isOK()) {
            tempStatus[curCount++] = this.fTestsetNameStatus;
        }
        if (0 == curCount) {
            this.updateStatus(this.fSuccessStatus);
        } else if (tempStatus.length == curCount) {
            this.updateStatus(tempStatus);
        } else {
            IStatus[] curStatus = new IStatus[curCount];
            System.arraycopy(tempStatus, 0, curStatus, 0, curCount);
            this.updateStatus(curStatus);
        }
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        if (this.fMethodStubsButtons.isEnabled()) {
            boolean verboseComments = this.fMethodStubsButtons.isSelected(4);
            this.writeImports(imports);
            if (this.fMethodStubsButtons.isSelected(0)) {
                this.createCreateAttributes(type, verboseComments);
            }
            if (this.fMethodStubsButtons.isSelected(1)) {
                this.createPrepare(type, verboseComments);
            }
            if (this.fMethodStubsButtons.isSelected(2)) {
                this.createCleanUp(type, verboseComments);
            }
            if (this.fMethodStubsButtons.isSelected(3)) {
                this.createSample(type, verboseComments);
            }
        }
    }

    protected void createCreateAttributes(IType type, boolean pVerbose) throws JavaModelException {
        type.createMethod(this.fMethodStubsButtons.generateAdjustAttributesMethodContent(pVerbose), null, false, null);
    }

    protected void createPrepare(IType type, boolean pVerbose) throws JavaModelException {
        type.createMethod(this.fMethodStubsButtons.generatePrepareMethodContent(pVerbose), null, false, null);
    }

    protected void createCleanUp(IType type, boolean pVerbose) throws JavaModelException {
        type.createMethod(this.fMethodStubsButtons.generateCleanUpMethodContent(pVerbose), null, false, null);
    }

    protected void createSample(IType type, boolean pVerbose) throws JavaModelException {
        type.createMethod(this.fMethodStubsButtons.generateTestMethodContent(pVerbose), null, false, null);
    }

    protected void createTestsetNameControl(Composite composite, int nColumns) {
        this.fTestsetNameLabel = new Label(composite, 16448);
        this.fTestsetNameLabel.setFont(composite.getFont());
        this.fTestsetNameLabel.setText(TextKeySrc.T050.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fTestsetNameLabel.setLayoutData((Object)gd);
        this.fTestsetNameText = new Text(composite, 2052);
        this.fTestsetNameText.setEnabled(true);
        this.fTestsetNameText.setFont(composite.getFont());
        this.fTestsetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestsetConjurerPage.this.handleFieldChanged(TestsetConjurerPage.TESTSET_NAME);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        this.fTestsetNameText.setLayoutData((Object)gd);
        Label space = new Label(composite, 16384);
        space.setText(" ");
        gd = new GridData();
        gd.horizontalSpan = 1;
        space.setLayoutData((Object)gd);
    }

    public String getTestsetName() {
        if (null == this.fTestsetNameText || 0 == this.fTestsetNameText.getText().length()) {
            return this.fTestsetNameTextInitialValue;
        }
        return this.fTestsetNameText.getText();
    }

    public void setTestsetName(String pTestsetName, boolean pCanBeModified) {
        if (null == this.fTestsetNameText) {
            this.fTestsetNameTextInitialValue = pTestsetName;
        } else {
            this.fTestsetNameText.setText(pTestsetName);
            this.fTestsetNameText.setEnabled(pCanBeModified);
        }
    }

    public String getTypeName() {
        return this.getTestsetName();
    }

    protected IStatus testsetChanged() {
        ICompilationUnit cu;
        StatusInfo status = new StatusInfo();
        String testsetName = this.getTestsetName();
        if (testsetName.length() == 0) {
            status.setError(TextKeySrc.T120.getText());
            return status;
        }
        if (-1 < testsetName.indexOf(46)) {
            status.setError(TextKeySrc.T121.getText());
            return status;
        }
        IPackageFragment pack = this.getPackageFragment();
        if (null != pack && (cu = pack.getCompilationUnit(testsetName + ".java")).exists()) {
            status.setError(TextKeySrc.T124.getText());
            this.fMethodStubsButtons.setEnabled(false);
            return status;
        }
        if (0 > testsetName.indexOf("Test")) {
            status.setError(TextKeySrc.T125.getText());
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)testsetName);
        if (val.getSeverity() == 4) {
            status.setError(TextKeySrc.T122.getText() + val.getMessage());
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(TextKeySrc.T123.getText() + val.getMessage());
        }
        this.fMethodStubsButtons.setEnabled(true);
        return status;
    }

    protected void setFocus() {
        this.fTestsetNameText.setFocus();
    }

    private void writeImports(NewTypeWizardPage.ImportsManager imports) {
        if (this.fMethodStubsButtons.isSelected(0)) {
            imports.addImport("com.sap.tc.jtools.jver.framework.*");
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (null != settings) {
            boolean verboseComments = settings.getBoolean(VERBOSE_COMMENTS);
            boolean generateCreateAttributes = settings.getBoolean(STORE_CREATEATTRIBUTES);
            boolean generatePrepare = settings.getBoolean(STORE_PREPARE);
            boolean generateCleanup = settings.getBoolean(STORE_CLEANUP);
            boolean generateSample = settings.getBoolean(STORE_SAMPLE);
            this.fMethodStubsButtons.setSelection(0, generateCreateAttributes);
            this.fMethodStubsButtons.setSelection(1, generatePrepare);
            this.fMethodStubsButtons.setSelection(2, generateCleanup);
            this.fMethodStubsButtons.setSelection(3, generateSample);
            this.fMethodStubsButtons.setSelection(4, verboseComments);
        }
    }

    void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (null != settings) {
            settings.put(STORE_CREATEATTRIBUTES, this.fMethodStubsButtons.isSelected(0));
            settings.put(STORE_PREPARE, this.fMethodStubsButtons.isSelected(1));
            settings.put(STORE_CLEANUP, this.fMethodStubsButtons.isSelected(2));
            settings.put(STORE_SAMPLE, this.fMethodStubsButtons.isSelected(3));
            settings.put(VERBOSE_COMMENTS, this.fMethodStubsButtons.isSelected(4));
        }
    }

    private static String getLineDelimiterUsed(ICompilationUnit pCu) {
        try {
            if (pCu != null && pCu.exists()) {
                IBuffer buf = pCu.getBuffer();
                int length = buf.getLength();
                int i = 0;
                while (i < length) {
                    char ch = buf.getChar(i);
                    if (ch == '\r') {
                        if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                            return "\r\n";
                        }
                        return "\r";
                    }
                    if (ch == '\n') {
                        return "\n";
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return System.getProperty("line.separator", "\n");
    }

    private IStatus checkJverLibExistence() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            status.setError(TextKeySrc.T112.getText());
            return status;
        }
        IJavaProject jp = root.getJavaProject();
        try {
            if (null != jp.findType(Plugin.DRIVER_CLASSNAME)) {
                status.setOK();
                return status;
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        status.setWarning(TextKeySrc.T112.getText());
        return status;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fFirstTime) {
            this.handleFieldChanged(TESTSET_NAME);
            this.fFirstTime = false;
        }
        if (visible) {
            this.setFocus();
        }
    }
}

