/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.misc;

import com.sap.tc.jtools.jver.ide.eclipse.misc.ITestName;
import com.sap.tc.jtools.jver.ide.eclipse.misc.ITestStatus;
import com.sap.tc.jtools.jver.ide.eclipse.misc.TestcaseName;
import com.sap.tc.jtools.jver.ide.eclipse.misc.TestsetName;

public final class TestStatus
implements ITestStatus {
    private static final int TYPE_TESTCASE = 123;
    private static final int TYPE_TESTSET = 234;
    private final ITestName fTestName;
    private final int fType;
    private String fTrace;
    private int fStatus;

    public TestStatus(String pTestClassName, String pTestMethodName) {
        this.fTestName = new TestcaseName(pTestClassName, pTestMethodName);
        this.fType = 123;
        this.fTrace = "";
        this.fStatus = 0;
    }

    public TestStatus(String pTestsetName) {
        this.fTestName = new TestsetName(pTestsetName);
        this.fType = 234;
        this.fTrace = "";
        this.fStatus = -11;
    }

    public boolean isTestset() {
        return 234 == this.fType;
    }

    public boolean isTestcase() {
        return 123 == this.fType;
    }

    public String getTestName() {
        return this.fTestName.getName();
    }

    public String getClassName() {
        return this.fTestName.getClassName();
    }

    public String getMethodName() {
        return this.fTestName.getMethodName();
    }

    public int getStatus() {
        if (123 != this.fType) {
            throw new IllegalAccessError();
        }
        return this.fStatus;
    }

    public String getTrace() {
        if (null != this.fTrace) {
            return this.fTrace;
        }
        return "";
    }

    public void setStatus(int pStatus) {
        if (123 != this.fType) {
            throw new IllegalAccessError();
        }
        this.fStatus = pStatus;
    }

    public void setTrace(String pTrace) {
        this.fTrace = pTrace;
    }

    public int hashCode() {
        return this.fTestName.hashCode();
    }

    public boolean equals(Object pObject) {
        if (pObject instanceof TestStatus) {
            TestStatus otherStatus = (TestStatus)pObject;
            return this.fTestName.equals(otherStatus.fTestName);
        }
        return false;
    }
}

