/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.launch.TextKeyTcp;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IFileEditorInput;

public class ScanToolTestset {
    private static final String TEST_BASE_CLASS = "com.sap.tc.jtools.jver.framework.Test";

    public static IType[] findTests(IRunnableContext context, final boolean pDoArchiveScan, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    int nElements = elements.length;
                    pm.beginTask(TextKeyTcp.T109.getText(), nElements);
                    try {
                        int i = 0;
                        while (i < nElements) {
                            try {
                                ScanToolTestset.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), pDoArchiveScan, result);
                            }
                            catch (JavaModelException e) {
                                Plugin.log(e.getStatus());
                            }
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++i;
                        }
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        pm.done();
                        throw throwable;
                    }
                    pm.done();
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void collectTypes(Object pElement, IProgressMonitor pMonitor, boolean pDoArchiveScan, Set pResult) throws JavaModelException {
        if (pElement instanceof IJavaProject) {
            IJavaProject javaProj = (IJavaProject)pElement;
            try {
                IJavaElement[] subElementArray = javaProj.getChildren();
                if (null == subElementArray) return;
                int ii = 0;
                while (ii < subElementArray.length) {
                    ScanToolTestset.collectTypes(subElementArray[ii], pMonitor, pDoArchiveScan, pResult);
                    ++ii;
                }
                return;
            }
            catch (JavaModelException modelExp) {
                Plugin.log(modelExp);
                throw modelExp;
            }
        } else if (pElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot javaPackage = (IPackageFragmentRoot)pElement;
            if (!javaPackage.isArchive()) {
                try {
                    IJavaElement[] subElementArray = javaPackage.getChildren();
                    if (null == subElementArray) return;
                    int ii = 0;
                    while (ii < subElementArray.length) {
                        ScanToolTestset.collectTypes(subElementArray[ii], pMonitor, pDoArchiveScan, pResult);
                        ++ii;
                    }
                    return;
                }
                catch (JavaModelException modelExp) {
                    Plugin.log(modelExp);
                    throw modelExp;
                }
            } else {
                String packageName;
                if (!pDoArchiveScan || (packageName = javaPackage.getElementName()).startsWith("java") || packageName.startsWith("sun.") || packageName.startsWith("com.sap.tc.jtools.jver.")) return;
                try {
                    IJavaElement[] subElementArray = javaPackage.getChildren();
                    if (null == subElementArray) return;
                    int ii = 0;
                    while (ii < subElementArray.length) {
                        ScanToolTestset.collectTypes(subElementArray[ii], pMonitor, pDoArchiveScan, pResult);
                        ++ii;
                    }
                    return;
                }
                catch (JavaModelException modelExp) {
                    Plugin.log(modelExp);
                    throw modelExp;
                }
            }
        } else if (pElement instanceof IPackageFragment) {
            IPackageFragment javaPackage = (IPackageFragment)pElement;
            String packageName = javaPackage.getElementName();
            if (packageName.startsWith("java") || packageName.startsWith("sun.") || packageName.startsWith("com.sap.tc.jtools.jver.")) return;
            try {
                IJavaElement[] subElementArray = javaPackage.getChildren();
                if (null == subElementArray) return;
                int ii = 0;
                while (ii < subElementArray.length) {
                    ScanToolTestset.collectTypes(subElementArray[ii], pMonitor, pDoArchiveScan, pResult);
                    ++ii;
                }
                return;
            }
            catch (JavaModelException modelExp) {
                Plugin.log(modelExp);
                throw modelExp;
            }
        } else {
            Object curElement = ScanToolTestset.computeScope(pElement);
            while (curElement instanceof IJavaElement && !(curElement instanceof ICompilationUnit) && curElement instanceof ISourceReference) {
                if (curElement instanceof IType && ScanToolTestset.isTestType((IType)curElement)) {
                    pResult.add(curElement);
                    return;
                }
                curElement = ((IJavaElement)curElement).getParent();
            }
            if (!(curElement instanceof ICompilationUnit)) return;
            ICompilationUnit cu = (ICompilationUnit)curElement;
            IType[] types = cu.getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (ScanToolTestset.isTestType(types[i])) {
                    pResult.add(types[i]);
                }
                ++i;
            }
        }
    }

    private static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        if (element instanceof IClassFile) {
            IClassFile cf = (IClassFile)element;
            element = cf.getType();
        }
        return element;
    }

    private static boolean isTestType(IType type) throws JavaModelException {
        if (Flags.isAbstract((int)type.getFlags())) {
            return false;
        }
        if (!Flags.isPublic((int)type.getFlags())) {
            return false;
        }
        IType[] parents = type.newSupertypeHierarchy(null).getAllSuperclasses(type);
        int ii = 0;
        while (parents.length > ii) {
            String qualifiedName = parents[ii].getFullyQualifiedName();
            if (qualifiedName.equals(TEST_BASE_CLASS)) {
                return true;
            }
            ++ii;
        }
        return false;
    }
}

