/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.launch.TextKeyTcp;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

class ScanToolIFile {
    ScanToolIFile() {
    }

    static IFile[] findFiles(IRunnableContext context, final IAdaptable[] elements, final boolean pDoArchiveScan, final String pExtension) throws InvocationTargetException, InterruptedException {
        final Vector result = new Vector(20, 30);
        if (null == pExtension || 1 > pExtension.length()) {
            throw new IllegalArgumentException("no valid extension filter");
        }
        if (0 < elements.length) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    int nElements = elements.length;
                    pm.beginTask(TextKeyTcp.T109.getText(), nElements);
                    try {
                        int i = 0;
                        while (i < nElements) {
                            try {
                                ScanToolIFile.collectRecursive((IProgressMonitor)new SubProgressMonitor(pm, 1), elements[i], pDoArchiveScan, pExtension, result);
                            }
                            catch (JavaModelException e) {
                                Plugin.log(e.getStatus());
                            }
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++i;
                        }
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        pm.done();
                        throw throwable;
                    }
                    pm.done();
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IFile[result.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void collectRecursive(IProgressMonitor pMonitor, IAdaptable pElement, boolean pDoArchiveScan, String pExtension, Vector pResult) throws JavaModelException {
        if (pElement instanceof IJavaProject) {
            IJavaProject javaProj = (IJavaProject)pElement;
            try {
                ScanToolIFile.collectIterative(javaProj.getNonJavaResources(), pExtension, pResult);
                IJavaElement[] subElementArray = javaProj.getChildren();
                if (null == subElementArray) return;
                int ii = 0;
                while (ii < subElementArray.length) {
                    ScanToolIFile.collectRecursive(pMonitor, (IAdaptable)subElementArray[ii], pDoArchiveScan, pExtension, pResult);
                    ++ii;
                }
                return;
            }
            catch (JavaModelException modelExp) {
                Plugin.log(modelExp);
                throw modelExp;
            }
        }
        if (pElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot javaPackage = (IPackageFragmentRoot)pElement;
            if (javaPackage.isArchive() && !pDoArchiveScan) return;
            try {
                ScanToolIFile.collectIterative(javaPackage.getNonJavaResources(), pExtension, pResult);
                IJavaElement[] subElementArray = javaPackage.getChildren();
                if (null == subElementArray) return;
                int ii = 0;
                while (ii < subElementArray.length) {
                    ScanToolIFile.collectRecursive(pMonitor, (IAdaptable)subElementArray[ii], pDoArchiveScan, pExtension, pResult);
                    ++ii;
                }
                return;
            }
            catch (JavaModelException modelExp) {
                Plugin.log(modelExp);
                throw modelExp;
            }
        }
        if (pElement instanceof IPackageFragment || !(pElement instanceof IPackageFragment)) return;
        IPackageFragment javaPackage = (IPackageFragment)pElement;
        try {
            ScanToolIFile.collectIterative(javaPackage.getNonJavaResources(), pExtension, pResult);
            IJavaElement[] subElementArray = javaPackage.getChildren();
            if (null == subElementArray) return;
            int ii = 0;
            while (ii < subElementArray.length) {
                ScanToolIFile.collectRecursive(pMonitor, (IAdaptable)subElementArray[ii], pDoArchiveScan, pExtension, pResult);
                ++ii;
            }
            return;
        }
        catch (JavaModelException modelExp) {
            Plugin.log(modelExp);
            throw modelExp;
        }
    }

    private static void collectIterative(Object[] pObjects, String pExtension, Vector pResult) {
        if (null == pObjects) {
            return;
        }
        int ii = 0;
        while (ii < pObjects.length) {
            IFile curFile;
            if (pObjects[ii] instanceof IFile && ScanToolIFile.isMatchingExtension(curFile = (IFile)pObjects[ii], pExtension)) {
                pResult.add(curFile);
            }
            ++ii;
        }
    }

    private static boolean isMatchingExtension(IFile pFile, String pExtension) {
        if (null != pFile) {
            String extension = pFile.getFileExtension();
            return null != extension && extension.equals(pExtension);
        }
        return false;
    }
}

