/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.launch.AbsolutePathTool;
import com.sap.tc.jtools.jver.ide.eclipse.launch.AbstractLaunchConfig;
import com.sap.tc.jtools.jver.ide.eclipse.launch.AbstractLaunchConfigTab;
import com.sap.tc.jtools.jver.ide.eclipse.launch.BlinkComposite;
import com.sap.tc.jtools.jver.ide.eclipse.launch.ClassHierachyProvider;
import com.sap.tc.jtools.jver.ide.eclipse.launch.ClassSelectionDialog;
import com.sap.tc.jtools.jver.ide.eclipse.launch.IconKeyTcp;
import com.sap.tc.jtools.jver.ide.eclipse.launch.JobWildcard;
import com.sap.tc.jtools.jver.ide.eclipse.launch.JobWildcardDialog;
import com.sap.tc.jtools.jver.ide.eclipse.launch.ScanToolFile;
import com.sap.tc.jtools.jver.ide.eclipse.launch.ScanToolTestset;
import com.sap.tc.jtools.jver.ide.eclipse.launch.TextKeyTcp;
import com.sap.tc.jtools.jver.ide.eclipse.util.StringBuf;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchTab
extends AbstractLaunchConfigTab
implements SelectionListener {
    private static final int INDEX_STANDARD_TYPE = 0;
    private static final int INDEX_JVERJOB_TYPE = 1;
    private Text fProjText;
    private Button fProjButton;
    private Text fJverjobFileText;
    private Button fJverjobFileButton;
    private Table fJobWildcards;
    private Text fAttribFileText;
    private Button fAttribFileButton;
    private Table fSwtTestsetTable;
    private Button fAddButton;
    private Button fRemoveButton;
    private Image fIcon = null;
    private boolean fStandardType = true;
    private int fUpdateCounter = 0;
    private Combo fTypeCombo;
    private Button fDeepscanButton;
    private Composite fStandardTypeArea;
    private Composite fJverjobTypeArea;
    private boolean fIsDirty = true;

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 16);
        this.setControl((Control)base);
        GridLayout baseLayout = new GridLayout();
        base.setLayout((Layout)baseLayout);
        base.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite(base, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)topLayout);
        comp.setLayoutData((Object)new GridData(256));
        Label projLabel = new Label(comp, 0);
        projLabel.setText(TextKeyTcp.T050.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        projLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(comp, 2052);
        this.fProjText.setLayoutData((Object)new GridData(768));
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchTab.super.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = new Button(comp, 8);
        this.fProjButton.setText(TextKeyTcp.T052.getText());
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchTab.this.handleProjectButtonSelected();
            }
        });
        this.setButtonGridData(this.fProjButton);
        Label typeLabel = new Label(comp, 0);
        typeLabel.setText(TextKeyTcp.T131.getText());
        gd = new GridData();
        gd.horizontalSpan = 2;
        typeLabel.setLayoutData((Object)gd);
        this.fTypeCombo = new Combo(comp, 8);
        this.fTypeCombo.setToolTipText(TextKeyTcp.T132.getText());
        this.fTypeCombo.add(TextKeyTcp.T133.getText());
        this.fTypeCombo.add(TextKeyTcp.T134.getText());
        this.fTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchTab.this.syncConfigTypeFromUI();
            }
        });
        this.fDeepscanButton = new Button(comp, 32);
        this.fDeepscanButton.setText(TextKeyTcp.T135.getText());
        this.fDeepscanButton.setToolTipText(TextKeyTcp.T136.getText());
        this.setButtonGridData(this.fDeepscanButton);
        this.fDeepscanButton.setEnabled(false);
        try {
            this.fIcon = IconKeyTcp.ECLIPSE.create(comp.getShell().getDisplay());
        }
        catch (Exception ignore) {
            this.fIcon = null;
        }
        Composite typeArea = new Composite(base, 2048);
        typeArea.setLayout((Layout)new GridLayout());
        typeArea.setLayoutData((Object)new GridData(1808));
        this.fStandardTypeArea = this.createStandard(typeArea);
        this.fJverjobTypeArea = this.createJverjob(typeArea);
        this.updateConfigTypeDisplay();
        PaintListener pl = new PaintListener(){

            public void paintControl(PaintEvent e) {
                LaunchTab.this.redrawTypeArea(true);
            }
        };
        base.addPaintListener(pl);
    }

    protected Composite createStandard(Composite parentComposite) {
        BlinkComposite comp = new BlinkComposite(parentComposite, 0);
        GridLayout compLayout = new GridLayout();
        compLayout.numColumns = 2;
        compLayout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)compLayout);
        comp.setLayoutData(new GridData(1808));
        this.createTestsetTable(comp);
        this.createAddRemovePanel(comp);
        Label attribFileLabel = new Label((Composite)comp, 0);
        attribFileLabel.setText(TextKeyTcp.T056.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        attribFileLabel.setLayoutData((Object)gd);
        this.fAttribFileText = new Text((Composite)comp, 2052);
        this.fAttribFileText.setLayoutData((Object)new GridData(768));
        this.fAttribFileText.setToolTipText(TextKeyTcp.T057.getText());
        this.fAttribFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchTab.super.updateLaunchConfigurationDialog();
            }
        });
        this.fAttribFileButton = new Button((Composite)comp, 8);
        this.fAttribFileButton.setText(TextKeyTcp.T052.getText());
        this.fAttribFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchTab.this.handleAttribFileButtonSelected();
            }
        });
        this.setButtonGridData(this.fAttribFileButton);
        return comp;
    }

    protected Composite createJverjob(Composite parentComposite) {
        BlinkComposite comp = new BlinkComposite(parentComposite, 0);
        GridLayout compLayout = new GridLayout();
        compLayout.numColumns = 2;
        compLayout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)compLayout);
        comp.setLayoutData(new GridData(1808));
        Label jverjobFileLabel = new Label((Composite)comp, 0);
        jverjobFileLabel.setText(TextKeyTcp.T141.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        jverjobFileLabel.setLayoutData((Object)gd);
        this.fJverjobFileText = new Text((Composite)comp, 2052);
        this.fJverjobFileText.setLayoutData((Object)new GridData(768));
        this.fJverjobFileText.setToolTipText(TextKeyTcp.T057.getText());
        this.fJverjobFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchTab.super.updateLaunchConfigurationDialog();
            }
        });
        this.fJverjobFileButton = new Button((Composite)comp, 8);
        this.fJverjobFileButton.setText(TextKeyTcp.T052.getText());
        this.setButtonGridData(this.fJverjobFileButton);
        this.fJverjobFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchTab.this.handleJverjobFileButtonSelected();
            }
        });
        new Label((Composite)comp, 0).setText(TextKeyTcp.T160.getText());
        new Composite((Composite)comp, 0);
        this.fJobWildcards = new Table((Composite)comp, 67588);
        this.fJobWildcards.setToolTipText(TextKeyTcp.T161.getText());
        this.fJobWildcards.setLayoutData((Object)new GridData(1808));
        new TableColumn(this.fJobWildcards, 0).setText(TextKeyTcp.T162.getText());
        new TableColumn(this.fJobWildcards, 0).setText(TextKeyTcp.T163.getText());
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(40, false));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        this.fJobWildcards.setHeaderVisible(true);
        this.fJobWildcards.setLayout((Layout)tl);
        Composite compButton = new Composite((Composite)comp, 0);
        compButton.setLayout((Layout)new GridLayout());
        compButton.setLayoutData((Object)new GridData(1808));
        Button createButton = new Button(compButton, 8);
        createButton.setText(TextKeyTcp.T054.getText());
        this.setButtonGridData(createButton);
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JobWildcardDialog dlg = new JobWildcardDialog(Plugin.getActiveWorkbenchShell());
                if (0 == dlg.open() && null != dlg.getResult()) {
                    LaunchTab.this.fIsDirty = true;
                    JobWildcard result = dlg.getResult();
                    TableItem[] items = LaunchTab.this.fJobWildcards.getItems();
                    int ii = 0;
                    while (ii < items.length) {
                        if (items[ii].getText().equalsIgnoreCase(result.fToken)) {
                            items[ii].setText(new String[]{result.fToken, result.fValue});
                            items[ii].setData((Object)result);
                            return;
                        }
                        ++ii;
                    }
                    TableItem newItem = new TableItem(LaunchTab.this.fJobWildcards, 0);
                    newItem.setText(new String[]{result.fToken, result.fValue});
                    newItem.setData((Object)result);
                }
            }
        });
        Button deleteButton = new Button(compButton, 8);
        deleteButton.setText(TextKeyTcp.T055.getText());
        this.setButtonGridData(deleteButton);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int delNdx = LaunchTab.this.fJobWildcards.getSelectionIndex();
                if (0 <= delNdx) {
                    LaunchTab.this.fIsDirty = true;
                    LaunchTab.this.fJobWildcards.remove(delNdx);
                    if (delNdx < LaunchTab.this.fJobWildcards.getItemCount()) {
                        LaunchTab.this.fJobWildcards.setSelection(delNdx);
                    } else if (0 != LaunchTab.this.fJobWildcards.getItemCount()) {
                        LaunchTab.this.fJobWildcards.setSelection(0);
                    }
                }
            }
        });
        return comp;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateUpdateCounterFromConfig(config);
        this.updateCfgKindFromConfig(config);
        this.updateProjectFromConfig(config);
        this.updateJverjobFileFromConfig(config);
        this.updateJverjobWildcardsFromConfig(config);
        this.updateAttribFileFromConfig(config);
        this.updateTestsetsFromConfig(config);
        this.updateConfigTypeDisplay();
        this.fIsDirty = false;
        if (1 > this.fUpdateCounter) {
            this.fUpdateCounter = 1;
        } else if (20000 < this.fUpdateCounter) {
            ++this.fUpdateCounter;
        }
    }

    protected void updateCfgKindFromConfig(ILaunchConfiguration pCfg) {
        try {
            this.fStandardType = pCfg.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.TYPE", true);
        }
        catch (CoreException ce) {
            this.fStandardType = true;
        }
    }

    protected void updateUpdateCounterFromConfig(ILaunchConfiguration pCfg) {
        try {
            this.fUpdateCounter = pCfg.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.UPDATES", 0);
        }
        catch (CoreException ce) {
            this.fUpdateCounter = 0;
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fProjText.setText(projectName);
    }

    protected void updateJverjobFileFromConfig(ILaunchConfiguration config) {
        String cfgName = "";
        try {
            cfgName = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.JVERJOB.FILE.NAME", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fJverjobFileText.setText(cfgName);
    }

    protected void updateJverjobWildcardsFromConfig(ILaunchConfiguration config) {
        this.fJobWildcards.removeAll();
        try {
            JobWildcard[] wildCards = AbstractLaunchConfig.getJobWildcards(config);
            String[] disp = new String[2];
            int ii = 0;
            while (ii < wildCards.length) {
                TableItem item = new TableItem(this.fJobWildcards, 0);
                item.setData((Object)wildCards[ii]);
                disp[0] = wildCards[ii].fToken;
                disp[1] = wildCards[ii].fValue;
                item.setText(disp);
                ++ii;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void updateAttribFileFromConfig(ILaunchConfiguration config) {
        String cfgName = "";
        try {
            cfgName = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.ATTRIB.FILE.NAME", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fAttribFileText.setText(cfgName);
    }

    protected void updateTestsetsFromConfig(ILaunchConfiguration config) {
        this.fSwtTestsetTable.removeAll();
        List testsetList = null;
        try {
            testsetList = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST", new ArrayList(0));
        }
        catch (CoreException ce) {
            // empty catch block
        }
        if (null != testsetList && !testsetList.isEmpty()) {
            int ii = 0;
            while (ii < testsetList.size()) {
                this.addTestset(testsetList.get(ii).toString());
                ++ii;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (!this.fIsDirty) {
            return;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.TYPE", this.fStandardType);
        if (this.fStandardType) {
            int testsetCount = this.fSwtTestsetTable.getItemCount();
            ArrayList<String> testsetList = new ArrayList<String>(testsetCount);
            int ii = 0;
            while (ii < testsetCount) {
                String testsetName = this.fSwtTestsetTable.getItem(ii).getText();
                if (0 == ii) {
                    config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, testsetName);
                }
                testsetList.add(testsetName);
                ++ii;
            }
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST", testsetList);
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.ATTRIB.FILE.NAME", this.fAttribFileText.getText());
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.JVERJOB.FILE.NAME", "");
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.JOB.WILDCARD.LIST", new ArrayList(0));
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fProjText.getText());
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.JVERJOB.FILE.NAME", this.fJverjobFileText.getText());
            int size = this.fJobWildcards.getItemCount();
            Vector<String> buffer = new Vector<String>(size);
            int ii = 0;
            while (ii < size) {
                JobWildcard wildCard = (JobWildcard)this.fJobWildcards.getItem(ii).getData();
                if (0 < wildCard.fToken.length() && 0 < wildCard.fValue.length()) {
                    buffer.add(wildCard.toString());
                }
                ++ii;
            }
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.JOB.WILDCARD.LIST", buffer);
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST", new ArrayList(0));
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.ATTRIB.FILE.NAME", "");
        }
        if (this.fUpdateCounter < 20000) {
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.UPDATES", this.fUpdateCounter);
        }
        this.fIsDirty = false;
    }

    public void dispose() {
        if (null != this.fIcon && !this.fIcon.isDisposed()) {
            this.fIcon.dispose();
            this.fIcon = null;
        }
    }

    protected void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        if (!this.fProjText.getText().equals(projectName)) {
            this.fProjText.setText(projectName);
            this.fAttribFileText.setText("");
            this.fSwtTestsetTable.removeAll();
            this.fJverjobFileText.setText("");
            this.fIsDirty = true;
        }
    }

    protected IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            Plugin.log(e.getStatus());
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(TextKeyTcp.T104.getText());
        dialog.setMessage(TextKeyTcp.T105.getText());
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private boolean checkJverLibExistence(String projectName) {
        IJavaProject[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            Plugin.log(e.getStatus());
            return false;
        }
        int i = 0;
        while (i < projects.length) {
            IJavaProject jp = projects[i];
            if (jp.getElementName().equals(projectName)) {
                try {
                    return null != jp.findType(Plugin.DRIVER_CLASSNAME);
                }
                catch (JavaModelException me) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    protected void handleAttribFileButtonSelected() {
        String attribFileName = this.chooseFile(".properties", TextKeyTcp.T121.getText(), TextKeyTcp.T122.getText());
        if (null == attribFileName) {
            return;
        }
        if (!this.fAttribFileText.getText().equals(attribFileName)) {
            this.fAttribFileText.setText(attribFileName);
            this.fIsDirty = true;
        }
    }

    protected void handleJverjobFileButtonSelected() {
        String jverjobFileName = this.chooseFile(".jvertask", TextKeyTcp.T141.getText(), TextKeyTcp.T142.getText());
        if (null == jverjobFileName) {
            return;
        }
        if (!this.fJverjobFileText.getText().equals(jverjobFileName)) {
            this.fJverjobFileText.setText(jverjobFileName);
            this.fIsDirty = true;
        }
    }

    protected String chooseFile(String pExtension, String pDialogTitle, String pDialogMessage) {
        File file;
        Object[] scanFiles;
        IJavaProject javaProject = this.getJavaProject();
        if (null == javaProject) {
            return null;
        }
        try {
            File[] scanDirs = AbsolutePathTool.getProjectOutAndLib(javaProject, true, this.fDeepscanButton.getSelection(), true);
            scanFiles = ScanToolFile.findFiles((IRunnableContext)new BusyIndicatorRunnableContext(), scanDirs, this.fDeepscanButton.getSelection(), pExtension);
        }
        catch (JavaModelException e) {
            Plugin.log(e);
            return null;
        }
        catch (InterruptedException e) {
            Plugin.log(e);
            scanFiles = new File[]{};
        }
        catch (InvocationTargetException e) {
            Plugin.log(e);
            scanFiles = new File[]{};
        }
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object pElement) {
                if (pElement instanceof File) {
                    return ((File)pElement).getName();
                }
                if (pElement instanceof IFile) {
                    return ((IFile)pElement).getName();
                }
                return pElement.toString();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(pDialogTitle);
        dialog.setMessage(pDialogMessage);
        dialog.setElements(scanFiles);
        if (0 == dialog.open() && null != (file = (File)dialog.getFirstResult())) {
            StringBuf fileNameBuf = new StringBuf(file.getPath());
            return fileNameBuf.replace('\\', '/').toString();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    protected String getProjectOutDir() {
        IJavaProject javaProject = this.getJavaProject();
        if (null != javaProject) {
            try {
                IPath fullPath = javaProject.getOutputLocation();
                IPath relativePath = fullPath.removeFirstSegments(1);
                return relativePath.toString();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return "bin";
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid() {
        return this.isValid(null);
    }

    public boolean isValid(ILaunchConfiguration pConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (0 < name.length()) {
            if (!ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
                this.setErrorMessage(TextKeyTcp.T106.getText());
                return false;
            }
            if (!this.checkJverLibExistence(name)) {
                this.setErrorMessage(TextKeyTcp.T120.getText());
                return false;
            }
        } else {
            this.setErrorMessage(TextKeyTcp.T106.getText());
            return false;
        }
        if (this.fStandardType) {
            int numTestset = this.fSwtTestsetTable.getItemCount();
            if (1 > numTestset) {
                this.setErrorMessage(TextKeyTcp.T178.getText());
                return false;
            }
        } else {
            name = this.fJverjobFileText.getText().trim();
            if (1 > name.length()) {
                this.setErrorMessage(TextKeyTcp.T179.getText());
                return false;
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST", new ArrayList(0));
        }
        this.initializeTestTypeAndName(javaElement, config);
        this.fIsDirty = true;
    }

    protected void initializeTestTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        int index;
        String name = "";
        try {
            if (javaElement instanceof ICompilationUnit || javaElement instanceof ISourceReference || javaElement instanceof IClassFile) {
                IType[] types = ScanToolTestset.findTests((IRunnableContext)new BusyIndicatorRunnableContext(), false, new Object[]{javaElement});
                if (types == null || types.length < 1) {
                    return;
                }
                name = types[0].getFullyQualifiedName();
            }
        }
        catch (InterruptedException ie) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        if (null == name) {
            name = "";
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        if (0 <= name.indexOf("Test")) {
            ArrayList<String> testsetList = new ArrayList<String>(1);
            testsetList.add(name);
            config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST", testsetList);
        }
        if ((index = name.lastIndexOf(46)) > 0) {
            name = name.substring(index + 1);
        }
        name = this.getLaunchConfigurationDialog().generateName(name);
        config.rename(name);
    }

    public String getName() {
        return TextKeyTcp.T107.getText();
    }

    public Image getImage() {
        return this.fIcon;
    }

    public void widgetDefaultSelected(SelectionEvent pSelectionEvent) {
        this.widgetSelected(pSelectionEvent);
    }

    public void widgetSelected(SelectionEvent pSelectionEvent) {
        if (pSelectionEvent.getSource().equals(this.fRemoveButton)) {
            int[] removeIndicies;
            int oldIndex = this.fSwtTestsetTable.getSelectionIndex();
            if (0 <= oldIndex && null != (removeIndicies = this.fSwtTestsetTable.getSelectionIndices())) {
                this.fSwtTestsetTable.remove(removeIndicies);
                this.fIsDirty = true;
            }
            if (0 < oldIndex && oldIndex <= this.fSwtTestsetTable.getItemCount()) {
                this.fSwtTestsetTable.select(oldIndex - 1);
            } else if (0 < this.fSwtTestsetTable.getItemCount()) {
                this.fSwtTestsetTable.select(0);
            } else {
                this.fRemoveButton.setEnabled(false);
            }
        } else if (pSelectionEvent.getSource().equals(this.fAddButton)) {
            this.openTestsetDialog();
            int lastIndex = this.fSwtTestsetTable.getItemCount() - 1;
            if (0 <= lastIndex) {
                this.fSwtTestsetTable.setSelection(lastIndex);
                this.fRemoveButton.setEnabled(true);
            } else {
                this.fRemoveButton.setEnabled(false);
            }
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void openTestsetDialog() {
        Shell shell = this.getShell();
        Object[] testsetArray = null;
        ScanToolTestset testsetScanner = new ScanToolTestset();
        BusyIndicatorRunnableContext runnableContext = new BusyIndicatorRunnableContext();
        IJavaProject javaProject = this.getJavaProject();
        try {
            testsetArray = ScanToolTestset.findTests((IRunnableContext)runnableContext, this.fDeepscanButton.getSelection(), new Object[]{javaProject});
        }
        catch (InvocationTargetException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (null == testsetArray) {
            testsetArray = new IType[]{};
        }
        if (0 != testsetArray.length) {
            TableItem[] tabItems = this.fSwtTestsetTable.getItems();
            HashSet<String> nameCache = new HashSet<String>(tabItems.length);
            Vector<Object> newTestsets = new Vector<Object>(testsetArray.length);
            int ii = 0;
            while (ii < tabItems.length) {
                nameCache.add(tabItems[ii].getText());
                ++ii;
            }
            int jj = 0;
            while (jj < testsetArray.length) {
                if (!nameCache.contains(testsetArray[jj].getFullyQualifiedName())) {
                    newTestsets.add(testsetArray[jj]);
                }
                ++jj;
            }
            testsetArray = new IType[newTestsets.size()];
            newTestsets.copyInto(testsetArray);
        }
        ClassHierachyProvider contentProvider = new ClassHierachyProvider((IType[])testsetArray);
        ClassSelectionDialog dialog = new ClassSelectionDialog(shell, contentProvider);
        dialog.setTitle(TextKeyTcp.T150.getText());
        dialog.setMessage(TextKeyTcp.T151.getText());
        dialog.setEmptyListMessage(TextKeyTcp.T152.getText());
        if (dialog.open() == 1) {
            return;
        }
        IType[] testsetResults = dialog.getSelectedTestsetsResult();
        if (testsetResults == null || testsetResults.length < 1) {
            return;
        }
        int ii = 0;
        while (ii < testsetResults.length) {
            String testsetName = testsetResults[ii].getFullyQualifiedName();
            this.addTestset(testsetName);
            ++ii;
        }
        if (0 < this.fSwtTestsetTable.getItemCount()) {
            this.fSwtTestsetTable.setSelection(this.fSwtTestsetTable.getItemCount() - 1);
        }
    }

    protected void createTestsetTable(Composite pComposite) {
        Label label = new Label(pComposite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        label.setLayoutData((Object)gridData);
        label.setText(TextKeyTcp.T112.getText());
        this.fSwtTestsetTable = new Table(pComposite, 2050);
        gridData = new GridData(1808);
        this.fSwtTestsetTable.setLayoutData((Object)gridData);
        this.fSwtTestsetTable.addSelectionListener((SelectionListener)this);
        if (0 > this.fSwtTestsetTable.getItemCount()) {
            this.fSwtTestsetTable.setSelection(0);
        }
    }

    protected void createAddRemovePanel(Composite pComposite) {
        Composite buttonPanel = new Composite(pComposite, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        buttonPanel.setLayoutData((Object)gd);
        this.createAddButton(buttonPanel);
        this.createRemoveButton(buttonPanel);
    }

    protected void createAddButton(Composite buttonPanel) {
        this.fAddButton = new Button(buttonPanel, 8);
        this.fAddButton.setText(TextKeyTcp.T054.getText());
        this.setButtonGridData(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)this);
    }

    protected void createRemoveButton(Composite buttonPanel) {
        this.fRemoveButton = new Button(buttonPanel, 8);
        this.fRemoveButton.setText(TextKeyTcp.T055.getText());
        this.setButtonGridData(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
    }

    protected void addTestset(String pNewEntry) {
        if (null != pNewEntry) {
            TableItem[] tableItems = this.fSwtTestsetTable.getItems();
            int ii = 0;
            while (ii < tableItems.length) {
                if (pNewEntry.equals(tableItems[ii].getText())) {
                    return;
                }
                ++ii;
            }
            TableItem tableItem = new TableItem(this.fSwtTestsetTable, 0);
            tableItem.setText(pNewEntry);
            this.fIsDirty = true;
        }
    }

    protected CTabItem createTabItem(CTabFolder pTabFolder) {
        Composite composite = new Composite((Composite)pTabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        CTabItem tabItem = new CTabItem(pTabFolder, 0);
        tabItem.setControl((Control)composite);
        return tabItem;
    }

    protected void updateConfigTypeDisplay() {
        if (null != this.fTypeCombo) {
            if (this.fStandardType) {
                this.fTypeCombo.select(0);
            } else {
                this.fTypeCombo.select(1);
            }
        }
        this.redrawTypeArea(true);
    }

    protected void syncConfigTypeFromUI() {
        boolean oldType = this.fStandardType;
        if (null != this.fTypeCombo) {
            boolean bl = this.fStandardType = 1 != this.fTypeCombo.getSelectionIndex();
        }
        if (oldType != this.fStandardType) {
            this.fIsDirty = true;
        }
        this.redrawTypeArea(oldType != this.fStandardType);
    }

    protected void redrawTypeArea(boolean pHide) {
        if (null != this.fStandardTypeArea && null != this.fJverjobTypeArea) {
            if (this.fStandardType) {
                if (pHide) {
                    this.fJverjobTypeArea.setVisible(false);
                    this.fStandardTypeArea.setVisible(true);
                }
                this.fStandardTypeArea.setBounds(this.fStandardTypeArea.getParent().getClientArea());
            } else {
                if (pHide) {
                    this.fStandardTypeArea.setVisible(false);
                    this.fJverjobTypeArea.setVisible(true);
                }
                this.fJverjobTypeArea.setBounds(this.fJverjobTypeArea.getParent().getClientArea());
            }
        }
    }
}

