/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.launch.LaunchSingleTestsetTool;
import com.sap.tc.jtools.jver.ide.eclipse.launch.ScanToolTestset;
import com.sap.tc.jtools.jver.ide.eclipse.launch.TextKeyTcp;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchShortcut
implements ILaunchShortcut,
IJavaLaunchConfigurationConstants,
IDebugUIConstants {
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    protected void searchAndLaunch(Object[] search, String mode) {
        IType[] types = null;
        if (search != null) {
            try {
                types = this.findLaunchTypes(search);
            }
            catch (InterruptedException e) {
                Plugin.log(e);
                return;
            }
            catch (InvocationTargetException e) {
                Plugin.log(e);
                return;
            }
            IType type = null;
            if (types.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TextKeyTcp.T110.getText(), (String)TextKeyTcp.T111.getText());
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    private IType[] findLaunchTypes(Object[] pSearch) throws InvocationTargetException, InterruptedException {
        return ScanToolTestset.findTests((IRunnableContext)new ProgressMonitorDialog(this.getShell()), false, pSearch);
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IJavaElement je = (IJavaElement)input.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = LaunchShortcut.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        if (je != null) {
            this.searchAndLaunch(new Object[]{je}, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    protected IType chooseType(IType[] types, String mode) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setElements((Object[])types);
        dialog.setTitle(TextKeyTcp.T112.getText());
        if (mode.equals("debug")) {
            dialog.setMessage(TextKeyTcp.T114.getText());
        } else {
            dialog.setMessage(TextKeyTcp.T113.getText());
        }
        dialog.setMultipleSelection(false);
        if (0 == dialog.open()) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IType type, String mode) {
        block4: {
            try {
                ILaunchConfiguration config = this.findLaunchConfiguration(type, mode);
                if (config == null) break block4;
                try {
                    LaunchSingleTestsetTool.pushException(config, type);
                    config.launch(mode, null);
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    LaunchSingleTestsetTool.popException(config);
                    throw throwable;
                }
                LaunchSingleTestsetTool.popException(config);
                {
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)TextKeyTcp.T115.getText(), (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, String mode) {
        ILaunchConfigurationType configType = this.getJverLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            String testsetName = type.getFullyQualifiedName();
            String projectName = type.getJavaProject().getElementName();
            int i = 0;
            while (i < configs.length) {
                String configProject;
                ILaunchConfiguration config = configs[i];
                boolean configStandardType = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.TYPE", false);
                if (configStandardType && (configProject = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "")).equals(projectName)) {
                    try {
                        List configTestsetList = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST", new ArrayList(0));
                        boolean match = false;
                        int j = 0;
                        while (j < configTestsetList.size() && !match) {
                            String configTestset = (String)configTestsetList.get(j);
                            match = testsetName.equals(configTestset);
                            ++j;
                        }
                        if (match) {
                            candidateConfigs.add(config);
                        }
                    }
                    catch (CoreException ce) {
                        Plugin.log(ce);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Plugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (1 == candidateCount) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(TextKeyTcp.T116.getText());
        if (mode.equals("debug")) {
            dialog.setMessage(TextKeyTcp.T118.getText());
        } else {
            dialog.setMessage(TextKeyTcp.T117.getText());
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getJverLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.TYPE", true);
            wc.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.UPDATES", 1);
            String testsetName = type.getFullyQualifiedName();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, testsetName);
            ArrayList<String> testsetList = new ArrayList<String>(1);
            testsetList.add(testsetName);
            wc.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST", testsetList);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_DEBUG_PERSPECTIVE, "perspective_default");
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, "perspective_none");
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            wc.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.DRIVER", false);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            Plugin.log(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getJverLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("com.sap.tc.jtools.jver.ide.eclipse.launch.launchconfig");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return Plugin.getActiveWorkbenchShell();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

