/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.launch.IconKeyTcp;
import com.sap.tc.jtools.jver.ide.eclipse.launch.LaunchCheckboxesGroup;
import com.sap.tc.jtools.jver.ide.eclipse.launch.LayoutTool;
import com.sap.tc.jtools.jver.ide.eclipse.launch.TextKeyTcp;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LaunchOptionTab
extends AbstractLaunchConfigurationTab {
    private LaunchCheckboxesGroup fOptions;
    private Image fIcon = null;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        this.createOptionsControl(comp, 4);
        try {
            this.fIcon = IconKeyTcp.ECLIPSE.create(comp.getShell().getDisplay());
        }
        catch (Exception ignore) {
            this.fIcon = null;
        }
    }

    protected void createOptionsControl(Composite composite, int nColumns) {
        String[] optionNames = new String[]{TextKeyTcp.T300.getText(), TextKeyTcp.T301.getText(), TextKeyTcp.T302.getText(), TextKeyTcp.T303.getText()};
        this.fOptions = new LaunchCheckboxesGroup(32, optionNames, 1);
        this.fOptions.setLabelText(TextKeyTcp.T310.getText());
        LayoutTool.setHorizontalSpan((Control)this.fOptions.getLabelControl(composite), nColumns);
        LayoutTool.createEmptySpace(composite, 1);
        LayoutTool.setHorizontalSpan((Control)this.fOptions.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateOptionsFromConfig(config);
    }

    protected void updateOptionsFromConfig(ILaunchConfiguration config) {
        boolean curVal;
        try {
            curVal = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.APL", false);
        }
        catch (CoreException ignore) {
            curVal = false;
        }
        this.fOptions.setSelection(0, curVal);
        try {
            curVal = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.DRIVER", false);
        }
        catch (CoreException ignore) {
            curVal = false;
        }
        this.fOptions.setSelection(1, curVal);
        try {
            curVal = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.MODE.PERFORMANCE", false);
        }
        catch (CoreException ignore) {
            curVal = false;
        }
        this.fOptions.setSelection(2, curVal);
        try {
            curVal = config.getAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.DEBUG_PLUGIN", false);
        }
        catch (CoreException ignore) {
            curVal = false;
        }
        this.fOptions.setSelection(3, curVal);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.APL", this.fOptions.isSelected(0));
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.DRIVER", this.fOptions.isSelected(1));
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.MODE.PERFORMANCE", this.fOptions.isSelected(2));
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.DEBUG_PLUGIN", this.fOptions.isSelected(3));
    }

    public void dispose() {
        if (null != this.fIcon && !this.fIcon.isDisposed()) {
            this.fIcon.dispose();
            this.fIcon = null;
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid() {
        return this.isValid(null);
    }

    public boolean isValid(ILaunchConfiguration pConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.APL", false);
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.DRIVER", false);
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.MODE.PERFORMANCE", false);
        config.setAttribute("com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.DEBUG_PLUGIN", false);
    }

    public String getName() {
        return TextKeyTcp.T108.getText();
    }

    public Image getImage() {
        return this.fIcon;
    }
}

