/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.gui.JverPreferencePage;
import com.sap.tc.jtools.jver.ide.eclipse.launch.AbstractLaunchConfig;
import com.sap.tc.jtools.jver.ide.eclipse.launch.JobWildcard;
import com.sap.tc.jtools.jver.ide.eclipse.launch.LaunchSingleTestsetTool;
import com.sap.tc.jtools.jver.ide.eclipse.launch.TextKeyTcp;
import com.sap.tc.jtools.jver.ide.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jver.ide.eclipse.util.StringBuf;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class LaunchConfig
extends AbstractLaunchConfig {
    public static final String ECLIPSE_ID = "com.sap.tc.jtools.jver.ide.eclipse.launch.launchconfig";

    protected VMRunnerConfiguration createVMRunner(ILaunchConfiguration pConfiguration, IJavaProject pProject, int pTcpPort, String pRunMode) throws CoreException, NoClassDefFoundError {
        String[] classPath = this.createClassPath(pConfiguration);
        IType singleTestset = LaunchSingleTestsetTool.popException(pConfiguration);
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration("com.sap.tc.jtools.jver.remotedriver.tcp.Driver", classPath);
        Vector<String> argv = new Vector<String>(50);
        argv.add(Integer.toString(pTcpPort));
        if (this.isApplicationTraceRequested(pConfiguration)) {
            argv.add("-a");
            argv.add(JverPreferencePage.getApplicationLog());
        }
        if (this.isDriverTraceRequested(pConfiguration)) {
            argv.add("-d");
            argv.add("verbose");
            argv.add(JverPreferencePage.getDriverLog());
        }
        if (this.isPerformanceModeRequested(pConfiguration)) {
            argv.add("-p");
            argv.add(JverPreferencePage.getPerformanceLog());
        }
        if (this.isPluginDebuggingRequested(pConfiguration)) {
            argv.add("-D");
        }
        if (this.isTestsetTypeDesired(pConfiguration)) {
            String attribFile = this.getAttribFileName(pConfiguration);
            if (null != attribFile && 0 < attribFile.length()) {
                argv.add("-i");
                argv.add(attribFile);
            }
            if (null == singleTestset) {
                IType[] testsetArray = this.getTestsets(pConfiguration, pProject);
                int ii = 0;
                while (ii < testsetArray.length) {
                    argv.add(testsetArray[ii].getFullyQualifiedName());
                    ++ii;
                }
            } else {
                argv.add(singleTestset.getFullyQualifiedName());
            }
        } else {
            String jobFile = this.getJobFileName(pConfiguration);
            if (null != jobFile && 0 < jobFile.length()) {
                argv.add("-j");
                argv.add(jobFile);
            }
        }
        Object[] args = new String[argv.size()];
        argv.copyInto(args);
        vmConfig.setProgramArguments((String[])args);
        return vmConfig;
    }

    public String getVMArguments(ILaunchConfiguration pConfiguration) throws CoreException {
        StringBuf argBuf = new StringBuf(super.getVMArguments(pConfiguration));
        if (!this.isTestsetTypeDesired(pConfiguration)) {
            argBuf.append(' ');
            JobWildcard[] wildCards = AbstractLaunchConfig.getJobWildcards(pConfiguration);
            int ii = 0;
            while (ii < wildCards.length) {
                argBuf.append(wildCards[ii].toCmdOption());
                ++ii;
            }
        }
        return argBuf.toString();
    }

    private String[] createClassPath(ILaunchConfiguration pConfiguration) throws CoreException {
        URL url = Plugin.getDefault().getDescriptor().getInstallURL();
        String[] cp = this.getClasspath(pConfiguration);
        if (!BootLoader.inDevelopmentMode()) {
            String[] classPath = new String[cp.length + 1];
            System.arraycopy(cp, 0, classPath, 1, cp.length);
            IOException expCaught = null;
            try {
                classPath[0] = Platform.asLocalURL((URL)new URL(url, "com_sap_ide_eclipse_plugin_jver.jar")).getFile();
            }
            catch (MalformedURLException e) {
                expCaught = e;
            }
            catch (IOException e) {
                expCaught = e;
            }
            if (null != expCaught) {
                ExceptionHandler.handle(expCaught, Plugin.getActiveWorkbenchShell(), TextKeyTcp.T200.getText(), TextKeyTcp.T201.getFormattedText("com_sap_ide_eclipse_plugin_jver.jar"));
            }
            return classPath;
        }
        String[] classPath = new String[cp.length + 2];
        System.arraycopy(cp, 0, classPath, 2, cp.length);
        IOException expCaught = null;
        String relativePath = this.getProjectOutDir();
        if (null == relativePath) {
            relativePath = "";
        }
        try {
            classPath[0] = 0 == relativePath.length() ? "." : Platform.asLocalURL((URL)new URL(url, relativePath)).getFile();
        }
        catch (MalformedURLException e) {
            expCaught = e;
        }
        catch (IOException e) {
            expCaught = e;
        }
        if (null != expCaught) {
            ExceptionHandler.handle(expCaught, Plugin.getActiveWorkbenchShell(), TextKeyTcp.T200.getText(), TextKeyTcp.T201.getFormattedText(relativePath));
            expCaught = null;
        }
        try {
            classPath[1] = Platform.asLocalURL((URL)new URL(url, "com_sap_ide_eclipse_plugin_jver.jar")).getFile();
        }
        catch (MalformedURLException e) {
            expCaught = e;
        }
        catch (IOException e) {
            expCaught = e;
        }
        if (null != expCaught) {
            ExceptionHandler.handle(expCaught, Plugin.getActiveWorkbenchShell(), TextKeyTcp.T200.getText(), TextKeyTcp.T201.getFormattedText("com_sap_ide_eclipse_plugin_jver.jar"));
        }
        return classPath;
    }
}

