/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.launch.LayoutTool;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LaunchCheckboxesGroup {
    private Label fLabel = null;
    protected String fLabelText = "";
    private SelectionButtonGroupListener fGroupListener;
    private boolean fEnabled = true;
    private Composite fButtonComposite;
    private Button[] fButtons;
    private String[] fButtonNames;
    private boolean[] fButtonsSelected;
    private boolean[] fButtonsEnabled;
    private int fGroupBorderStyle;
    private int fGroupNumberOfColumns;
    private int fButtonsStyle;

    public LaunchCheckboxesGroup(int pStyle, String[] pButtonNames, int pNumberOfColumns) {
        this(pStyle, pButtonNames, pNumberOfColumns, 0);
    }

    public LaunchCheckboxesGroup(int pStyle, String[] pButtonNames, int pNumberOfColumns, int pBorderStyle) {
        Assert.isTrue((pStyle == 16 || pStyle == 32 || pStyle == 2 ? 1 : 0) != 0);
        this.fButtonNames = pButtonNames;
        int nButtons = this.fButtonNames.length;
        this.fButtonsSelected = new boolean[nButtons];
        this.fButtonsEnabled = new boolean[nButtons];
        int ii = 0;
        while (ii < nButtons) {
            this.fButtonsSelected[ii] = false;
            this.fButtonsEnabled[ii] = true;
            ++ii;
        }
        if (this.fButtonsStyle == 16) {
            this.fButtonsSelected[0] = true;
        }
        this.fButtonsStyle = pStyle;
        this.fGroupBorderStyle = pBorderStyle;
        this.fGroupNumberOfColumns = 0 >= pNumberOfColumns ? nButtons : pNumberOfColumns;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        if (this.fGroupBorderStyle == 0) {
            Label label = this.getLabelControl(parent);
            label.setLayoutData((Object)LaunchCheckboxesGroup.gridDataForLabel(1));
            Composite buttonsgroup = this.getSelectionButtonsGroup(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = nColumns - 1;
            buttonsgroup.setLayoutData((Object)gd);
            return new Control[]{label, buttonsgroup};
        }
        Composite buttonsgroup = this.getSelectionButtonsGroup(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        buttonsgroup.setLayoutData((Object)gd);
        return new Control[]{buttonsgroup};
    }

    public Composite getSelectionButtonsGroup(Composite parent) {
        if (this.fButtonComposite == null) {
            this.assertCompositeNotNull(parent);
            GridLayout layout = new GridLayout();
            layout.makeColumnsEqualWidth = true;
            layout.numColumns = this.fGroupNumberOfColumns;
            if (this.fGroupBorderStyle != 0) {
                Group group = new Group(parent, this.fGroupBorderStyle);
                if (this.fLabelText != null && this.fLabelText.length() > 0) {
                    group.setText(this.fLabelText);
                }
                this.fButtonComposite = group;
            } else {
                this.fButtonComposite = new Composite(parent, 0);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
            }
            this.fButtonComposite.setLayout((Layout)layout);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    LaunchCheckboxesGroup.this.doWidgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    LaunchCheckboxesGroup.this.doWidgetSelected(e);
                }
            };
            int nButtons = this.fButtonNames.length;
            this.fButtons = new Button[nButtons];
            int i = 0;
            while (i < nButtons) {
                this.fButtons[i] = this.createSelectionButton(i, this.fButtonComposite, listener);
                ++i;
            }
            int nRows = nButtons / this.fGroupNumberOfColumns;
            int nFillElements = nRows * this.fGroupNumberOfColumns - nButtons;
            int i2 = 0;
            while (i2 < nFillElements) {
                LaunchCheckboxesGroup.createEmptySpace(this.fButtonComposite);
                ++i2;
            }
        }
        return this.fButtonComposite;
    }

    public Button getSelectionButton(int index) {
        if (index >= 0 && index < this.fButtons.length) {
            return this.fButtons[index];
        }
        return null;
    }

    private void doWidgetSelected(SelectionEvent e) {
        Button button = (Button)e.widget;
        int i = 0;
        while (i < this.fButtons.length) {
            if (this.fButtons[i] == button) {
                this.fButtonsSelected[i] = button.getSelection();
                this.dialogFieldChanged();
                return;
            }
            ++i;
        }
    }

    public int getNumberOfControls() {
        return this.fGroupBorderStyle == 0 ? 2 : 1;
    }

    private Button createSelectionButton(int index, Composite group, SelectionListener listener) {
        Button button = new Button(group, this.fButtonsStyle | 0x4000);
        button.setFont(group.getFont());
        button.setText(this.fButtonNames[index]);
        button.setEnabled(this.isEnabled() && this.fButtonsEnabled[index]);
        button.setSelection(this.fButtonsSelected[index]);
        button.addSelectionListener(listener);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    public boolean isSelected(int index) {
        if (index >= 0 && index < this.fButtonsSelected.length) {
            return this.fButtonsSelected[index];
        }
        return false;
    }

    public void setSelection(int index, boolean selected) {
        if (index >= 0 && index < this.fButtonsSelected.length && this.fButtonsSelected[index] != selected) {
            Button button;
            this.fButtonsSelected[index] = selected;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[index]))) {
                button.setSelection(selected);
            }
        }
    }

    public boolean isEnabled(int index) {
        if (index >= 0 && index < this.fButtonsEnabled.length) {
            return this.fButtonsEnabled[index];
        }
        return false;
    }

    public void setEnabled(int index, boolean enabled) {
        if (index >= 0 && index < this.fButtonsEnabled.length && this.fButtonsEnabled[index] != enabled) {
            Button button;
            this.fButtonsEnabled[index] = enabled;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[index]))) {
                button.setEnabled(enabled);
            }
        }
    }

    protected void updateEnableState() {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(this.fEnabled);
        }
        if (this.fButtons != null) {
            boolean enabled = this.isEnabled();
            int i = 0;
            while (i < this.fButtons.length) {
                Button button = this.fButtons[i];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(enabled && this.fButtonsEnabled[i]);
                }
                ++i;
            }
        }
    }

    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
    }

    public final void setSelectionGroupListener(SelectionButtonGroupListener listener) {
        this.fGroupListener = listener;
    }

    public void dialogFieldChanged() {
        if (this.fGroupListener != null) {
            this.fGroupListener.groupChanged(this);
        }
    }

    public boolean setFocus() {
        return false;
    }

    public void postSetFocusOnDialogField(Display display) {
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    LaunchCheckboxesGroup.this.setFocus();
                }
            });
        }
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        return gd;
    }

    public Label getLabelControl(Composite parent) {
        if (this.fLabel == null) {
            this.assertCompositeNotNull(parent);
            this.fLabel = new Label(parent, 16448);
            this.fLabel.setFont(parent.getFont());
            this.fLabel.setEnabled(this.fEnabled);
            if (this.fLabelText != null && !"".equals(this.fLabelText)) {
                this.fLabel.setText(this.fLabelText);
            } else {
                this.fLabel.setText(".");
                this.fLabel.setVisible(false);
            }
        }
        return this.fLabel;
    }

    public static Control createEmptySpace(Composite parent) {
        return LaunchCheckboxesGroup.createEmptySpace(parent, 1);
    }

    public static Control createEmptySpace(Composite parent, int span) {
        return LayoutTool.createEmptySpace(parent, span);
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public final void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            this.updateEnableState();
        }
    }

    public final boolean isEnabled() {
        return this.fEnabled;
    }

    protected final void assertCompositeNotNull(Composite comp) {
        Assert.isNotNull((Object)comp, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int nColumns) {
        Assert.isTrue((nColumns >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }

    public static interface SelectionButtonGroupListener {
        public void groupChanged(LaunchCheckboxesGroup var1);
    }
}

