/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.util.StringBuf;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;

final class FileScanRun {
    private final Vector fBuffer = new Vector(20, 40);
    private final String fPattern;
    private IProgressMonitor fMonitor;
    private File[] fResult = null;
    private File fCurRoot = null;
    private String fCurRootPath = null;

    FileScanRun(String pFilter) {
        this.fPattern = pFilter;
        this.fMonitor = null;
    }

    public File[] scanFiles(File[] pBasePaths, IProgressMonitor pMonitor) throws InterruptedException {
        this.fBuffer.clear();
        this.fResult = null;
        this.fMonitor = pMonitor;
        int ii = 0;
        while (ii < pBasePaths.length) {
            this.fCurRoot = pBasePaths[ii];
            if (this.fCurRoot.exists()) {
                if (this.fCurRoot.isDirectory()) {
                    this.fCurRootPath = this.fCurRoot.getAbsolutePath();
                    this.scanDirTree(0, this.fCurRoot);
                } else {
                    this.scanZip(this.fCurRoot);
                }
            }
            ++ii;
        }
        this.fResult = this.fBuffer.toArray(new File[this.fBuffer.size()]);
        this.fCurRoot = null;
        this.fCurRootPath = null;
        return this.fResult;
    }

    public File[] getLastResult() {
        return this.fResult;
    }

    private final void scanDirTree(int pDepth, File pCurFile) throws InterruptedException {
        if (40 < ++pDepth) {
            throw new IllegalArgumentException();
        }
        if (null != this.fMonitor && this.fMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (pCurFile.isDirectory()) {
            File[] childArray = pCurFile.listFiles();
            int ii = 0;
            while (ii < childArray.length) {
                this.scanDirTree(pDepth, childArray[ii]);
                ++ii;
            }
        } else if (pCurFile.isFile() && pCurFile.getName().endsWith(this.fPattern)) {
            this.fBuffer.add(this.getRelativePath(pCurFile));
        }
    }

    private final void scanZip(File pPossibleArchive) throws InterruptedException {
        try {
            ZipFile zipFile = new ZipFile(pPossibleArchive);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                if (!name.endsWith(this.fPattern)) continue;
                this.fBuffer.add(new File(name));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final File getRelativePath(File pAbsoluteFile) {
        StringBuf absoluteName = new StringBuf(pAbsoluteFile.getAbsolutePath());
        if (absoluteName.startsWith(this.fCurRootPath)) {
            StringBuf relativeName = absoluteName.removeAt(0, this.fCurRootPath.length());
            switch (relativeName.getCharAt(0)) {
                case '/': 
                case '\\': {
                    relativeName.removeAt(0, 1);
                }
            }
            return new File(relativeName.toString());
        }
        throw new IllegalArgumentException();
    }
}

