/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.launch.ClassHierachyProvider;
import java.util.Vector;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class ClassSelectionDialog
extends CheckedTreeSelectionDialog {
    protected final ClassHierachyProvider fContentProvider;
    protected Object fInput;

    public ClassSelectionDialog(Shell pParentShell, ClassHierachyProvider pContentProvider) {
        super(pParentShell, (ILabelProvider)new JavaElementLabelProvider(1040), (ITreeContentProvider)pContentProvider);
        this.fContentProvider = pContentProvider;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite pParentComposite) {
        CheckboxTreeViewer viewer = super.createTreeViewer(pParentComposite);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int detail = e.detail;
                Widget obj = e.item;
                if (0 == (detail & 0x20)) {
                    return;
                }
                TreeItem item = null;
                try {
                    item = (TreeItem)obj;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (null == item) {
                    return;
                }
                boolean isChecked = item.getChecked();
                if (null == item.getParentItem()) {
                    TreeItem[] childItems = item.getItems();
                    int ii = 0;
                    while (ii < childItems.length) {
                        childItems[ii].setChecked(isChecked);
                        ++ii;
                    }
                    item.setGrayed(false);
                } else {
                    TreeItem parentItem = item.getParentItem();
                    TreeItem[] sisterItems = parentItem.getItems();
                    boolean allChecked = true;
                    boolean noneChecked = true;
                    int ii = 0;
                    while (ii < sisterItems.length) {
                        if (sisterItems[ii].getChecked()) {
                            allChecked = false;
                        } else {
                            noneChecked = false;
                        }
                        ++ii;
                    }
                    if (allChecked || noneChecked) {
                        if (!parentItem.getChecked() == isChecked) {
                            parentItem.setChecked(isChecked);
                        }
                        parentItem.setGrayed(false);
                    } else {
                        if (!parentItem.getChecked()) {
                            parentItem.setChecked(true);
                        }
                        parentItem.setGrayed(true);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        viewer.expandAll();
        viewer.getTree().addSelectionListener(listener);
        return viewer;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite cp = new Composite(composite, 131072);
        cp.setEnabled(false);
        cp.setVisible(false);
        return cp;
    }

    public IType[] getSelectedTestsetsResult() {
        Object[] superResult = super.getResult();
        if (null == superResult || 0 == superResult.length) {
            return new IType[0];
        }
        Vector<Object> classVector = new Vector<Object>(superResult.length);
        int ii = 0;
        while (ii < superResult.length) {
            Object curObj = superResult[ii];
            if (this.fContentProvider.containsClassElement(curObj) && !classVector.contains(curObj) && curObj instanceof IType) {
                classVector.add(curObj);
            }
            ++ii;
        }
        Object[] result = new IType[classVector.size()];
        classVector.copyInto(result);
        return result;
    }

    public int open() {
        if (null == this.fInput) {
            this.setInput(this.fContentProvider);
            super.setInitialSelection((Object)this);
        }
        return super.open();
    }

    public void setInput(Object pInput) {
        this.fInput = pInput;
        super.setInput(this.fInput);
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            return super.getImage((Object)((IType)element).getPackageFragment());
        }

        public String getText(Object element) {
            return super.getText((Object)((IType)element).getPackageFragment());
        }
    }
}

