/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ClassHierachyProvider
implements ITreeContentProvider {
    protected IJavaElement[] fRootPackages = new IJavaElement[0];
    protected IJavaElement[] fChildClasses = new IJavaElement[0];
    protected HashMap fIsChildOf = new HashMap();

    public ClassHierachyProvider(IType[] pClassElementArray) {
        this.setClassElements(pClassElementArray);
    }

    private void setClassElements(IType[] pClassArray) {
        this.fIsChildOf.clear();
        if (null == pClassArray || 0 == pClassArray.length) {
            this.fRootPackages = new IJavaElement[0];
            this.fChildClasses = new IJavaElement[0];
            return;
        }
        Vector<Object> rootVector = new Vector<Object>(pClassArray.length);
        Vector<IType> childVector = new Vector<IType>(pClassArray.length);
        int ii = 0;
        while (ii < pClassArray.length) {
            IType curClass = pClassArray[ii];
            int curElemType = curClass.getElementType();
            switch (curElemType) {
                case 5: 
                case 6: 
                case 7: {
                    IPackageFragment curPackage = curClass.getPackageFragment();
                    if (null != curPackage) {
                        if (!rootVector.contains(curPackage)) {
                            rootVector.add(curPackage);
                        }
                        childVector.add(curClass);
                        this.fIsChildOf.put(curClass, curPackage);
                        break;
                    }
                    rootVector.add(curClass);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(curClass.toString() + curElemType);
                }
            }
            ++ii;
        }
        Object[] rootObjects = rootVector.toArray();
        this.fRootPackages = new IJavaElement[rootObjects.length];
        System.arraycopy(rootObjects, 0, this.fRootPackages, 0, rootObjects.length);
        Object[] childObjects = childVector.toArray();
        this.fChildClasses = new IJavaElement[childObjects.length];
        System.arraycopy(childObjects, 0, this.fChildClasses, 0, childObjects.length);
    }

    public Object[] getChildren(Object parentElement) {
        if (!this.fIsChildOf.containsValue(parentElement)) {
            return null;
        }
        Vector v = new Vector(10);
        Iterator i = this.fIsChildOf.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry curEntry = i.next();
            if (!curEntry.getValue().equals(parentElement)) continue;
            v.add(curEntry.getKey());
        }
        return v.toArray();
    }

    public Object getParent(Object element) {
        if (this.fIsChildOf.containsKey(element)) {
            return this.fIsChildOf.get(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.fIsChildOf.containsValue(element);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this || null == inputElement) {
            return this.fRootPackages;
        }
        if (this.containsPackageElement(inputElement)) {
            return new Object[]{inputElement};
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean containsClassElement(Object pClassElement) {
        int ii = 0;
        while (ii < this.fChildClasses.length) {
            if (pClassElement == this.fChildClasses[ii]) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public boolean containsPackageElement(Object pPackageElement) {
        int ii = 0;
        while (ii < this.fRootPackages.length) {
            if (pPackageElement == this.fRootPackages[ii]) {
                return true;
            }
            ++ii;
        }
        return false;
    }
}

