/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.launch.AbsolutePathTool;
import com.sap.tc.jtools.jver.ide.eclipse.launch.JobWildcard;
import com.sap.tc.jtools.jver.ide.eclipse.launch.SocketTool;
import com.sap.tc.jtools.jver.ide.eclipse.launch.TextKeyTcp;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;

public abstract class AbstractLaunchConfig
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String PORT_ATTR = "com.sap.tc.jtools.jver.ide.eclipse.plugin.PORT";
    public static final String PROJECT_ATTR = "com.sap.tc.jtools.jver.ide.eclipse.plugin.JAVA.PROJECT";
    public static final String ATTR_CONFIG_UPDATE_COUNTER = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.UPDATES";
    public static final String ATTR_CONFIG_TYPE = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.CONFIG.TYPE";
    public static final String ATTR_JVERJOB_FILE = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.JVERJOB.FILE.NAME";
    public static final String ATTR_ATTRIBUTE_FILE = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.ATTRIB.FILE.NAME";
    public static final String ATTR_TESTSET_LIST = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TESTSET.LIST";
    public static final String ATTR_JOB_WILDCARD_LIST = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.JOB.WILDCARD.LIST";
    public static final String ATTR_TRACE_APPLICATION = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.APL";
    public static final String ATTR_TRACE_DRIVER = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.TRACE.DRIVER";
    public static final String ATTR_PERFORMANCE_MODE = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.MODE.PERFORMANCE";
    public static final String ATTR_DEBUG_PLUGIN = "com.sap.tc.jtools.jver.ide.eclipse.pluginLAUNCH.DEBUG_PLUGIN";
    public static final String DRIVER_CLASS = "com.sap.tc.jtools.jver.remotedriver.tcp.Driver";
    IJavaProject fProject = null;

    public void launch(ILaunchConfiguration configuration, String mode, final ILaunch launch, final IProgressMonitor pm) throws CoreException {
        String id;
        VMRunnerConfiguration tempConfig;
        IVMRunner runner;
        this.fProject = this.getJavaProject(configuration);
        if (null == this.fProject || !this.fProject.exists()) {
            this.abort(TextKeyTcp.T101.getText(), null, 107);
        }
        this.verifyMainTypeName(configuration);
        IVMInstall vmInstall = this.getVMInstall(configuration);
        if (null == vmInstall && null == (vmInstall = JavaRuntime.getDefaultVMInstall())) {
            this.abort(TextKeyTcp.T119.getFormattedText(vmInstall.getId()), null, 105);
        }
        if (null == (runner = vmInstall.getVMRunner(mode))) {
            this.abort(TextKeyTcp.T100.getFormattedText(vmInstall.getId()), null, 106);
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, "");
        int port = SocketTool.scanUnusedPort(5000, 15000);
        try {
            tempConfig = this.createVMRunner(configuration, this.fProject, port, mode);
        }
        catch (NoClassDefFoundError noClass) {
            tempConfig = null;
            this.abort(TextKeyTcp.T120.getText(), noClass, 116);
        }
        final VMRunnerConfiguration runConfig = tempConfig;
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        String[] bootpath = this.getBootpath(configuration);
        if (null != bootpath && 0 < bootpath.length) {
            runConfig.setBootClassPath(bootpath);
        }
        if (null == (id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, (String)null))) {
            JavaSourceLocator sourceLocator = new JavaSourceLocator(this.fProject);
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
        launch.setAttribute(PORT_ATTR, Integer.toString(port));
        launch.setAttribute(PROJECT_ATTR, this.fProject.getHandleIdentifier());
        if (null != runner) {
            runner.run(runConfig, launch, pm);
        } else {
            Runnable rr = new Runnable(){

                public void run() {
                    try {
                        runner.run(runConfig, launch, pm);
                    }
                    catch (CoreException ce) {
                        try {
                            AbstractLaunchConfig.this.abort(TextKeyTcp.T124.getText(), ce, 116);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
            };
            Thread rt = new Thread(rr);
            rt.setDaemon(true);
            rt.setName("JVer");
            rt.start();
        }
    }

    public boolean isTestsetTypeDesired(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_CONFIG_TYPE, true);
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    public String getJobFileName(ILaunchConfiguration configuration) {
        try {
            String outDir;
            File relativeFile;
            File absoluteFile;
            String relativeName = configuration.getAttribute(ATTR_JVERJOB_FILE, "");
            if (1 > relativeName.length()) {
                return "";
            }
            IJavaProject javaProject = this.getJavaProject(configuration);
            if (null == javaProject || !javaProject.exists()) {
                this.abort(TextKeyTcp.T101.getText(), null, 107);
            }
            if (null == (absoluteFile = AbsolutePathTool.getAbsoluteFile(javaProject, relativeFile = null == (outDir = this.getProjectOutDir()) || 0 == outDir.length() ? new File(relativeName) : new File(outDir + File.separator + relativeName))) || !absoluteFile.exists()) {
                if (null == absoluteFile) {
                    absoluteFile = relativeFile;
                }
                this.abort(TextKeyTcp.T143.getFormattedText(absoluteFile.getPath()), null, 107);
            }
            switch (relativeName.charAt(0)) {
                case '/': 
                case '\\': {
                    return relativeName.substring(1);
                }
            }
            return relativeName;
        }
        catch (CoreException ce) {
            Plugin.log(ce);
            return "";
        }
    }

    public IType[] getTestsets(ILaunchConfiguration configuration, IJavaProject javaProject) throws CoreException {
        String[] testsetNames = null;
        List testsetList = null;
        try {
            testsetList = configuration.getAttribute(ATTR_TESTSET_LIST, new ArrayList(0));
        }
        catch (CoreException ce) {
            // empty catch block
        }
        if (null == testsetList || testsetList.isEmpty()) {
            this.abort(TextKeyTcp.T500.getText(), null, 101);
        }
        testsetNames = new String[testsetList.size()];
        int ii = 0;
        while (ii < testsetList.size()) {
            testsetNames[ii] = testsetList.get(ii).toString();
            ++ii;
        }
        IType[] testTypes = new IType[testsetNames.length];
        String curTestset = "";
        int ii2 = 0;
        while (ii2 < testsetNames.length) {
            try {
                curTestset = testsetNames[ii2];
                testTypes[ii2] = this.findType(javaProject, curTestset);
            }
            catch (JavaModelException jme) {
                this.abort(TextKeyTcp.T501.getFormattedText(curTestset), null, 101);
            }
            ++ii2;
        }
        ii = 0;
        while (ii < testTypes.length) {
            if (null == testTypes[ii]) {
                this.abort(TextKeyTcp.T501.getFormattedText(testsetNames[ii]), null, 101);
            }
            ++ii;
        }
        return testTypes;
    }

    public static JobWildcard[] getJobWildcards(ILaunchConfiguration configuration) throws CoreException {
        List wildCardList = null;
        try {
            wildCardList = configuration.getAttribute(ATTR_JOB_WILDCARD_LIST, new ArrayList(0));
        }
        catch (CoreException ce) {
            // empty catch block
        }
        if (null != wildCardList && !wildCardList.isEmpty()) {
            int size = wildCardList.size();
            int count = 0;
            JobWildcard[] buffer = new JobWildcard[size];
            int ii = 0;
            while (ii < wildCardList.size()) {
                try {
                    JobWildcard saveval = new JobWildcard((String)wildCardList.get(ii));
                    if (0 < saveval.fToken.length() && 0 < saveval.fValue.length()) {
                        buffer[count++] = saveval;
                    }
                }
                catch (ClassCastException ignore) {
                    --count;
                }
                ++ii;
            }
            if (count == size) {
                return buffer;
            }
            JobWildcard[] result = new JobWildcard[count];
            int ii2 = 0;
            while (ii2 < count) {
                result[ii2] = buffer[ii2];
                ++ii2;
            }
            return result;
        }
        return new JobWildcard[0];
    }

    public String getAttribFileName(ILaunchConfiguration configuration) {
        try {
            String outDir;
            File relativeFile;
            File absoluteFile;
            String relativeName = configuration.getAttribute(ATTR_ATTRIBUTE_FILE, "");
            if (1 > relativeName.length()) {
                return "";
            }
            IJavaProject javaProject = this.getJavaProject(configuration);
            if (null == javaProject || !javaProject.exists()) {
                this.abort(TextKeyTcp.T101.getText(), null, 107);
            }
            if (null == (absoluteFile = AbsolutePathTool.getAbsoluteFile(javaProject, relativeFile = null == (outDir = this.getProjectOutDir()) || 0 == outDir.length() ? new File(relativeName) : new File(outDir + File.separator + relativeName))) || !absoluteFile.exists()) {
                if (null == absoluteFile) {
                    absoluteFile = relativeFile;
                }
                this.abort(TextKeyTcp.T123.getFormattedText(absoluteFile.getPath()), null, 107);
            }
            switch (relativeName.charAt(0)) {
                case '/': 
                case '\\': {
                    return relativeName.substring(1);
                }
            }
            return relativeName;
        }
        catch (CoreException ce) {
            Plugin.log(ce);
            return "";
        }
    }

    public boolean isApplicationTraceRequested(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_TRACE_APPLICATION, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isDriverTraceRequested(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_TRACE_DRIVER, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isPerformanceModeRequested(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_PERFORMANCE_MODE, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isPluginDebuggingRequested(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_DEBUG_PLUGIN, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "com.sap.tc.jtools.jver.ide.eclipse.plugin", code, message, exception));
    }

    private IType findType(IJavaProject javaProject, String mainTypeName) throws JavaModelException {
        String pathStr = mainTypeName.replace('.', '/') + ".java";
        IJavaElement javaElement = javaProject.findElement((IPath)new Path(pathStr));
        if (javaElement == null) {
            IType res;
            IType type;
            String qualifier = Signature.getQualifier((String)mainTypeName);
            if (qualifier.length() > 0 && (type = this.findType(javaProject, qualifier)) != null && (res = type.getType(Signature.getSimpleName((String)mainTypeName))).exists()) {
                return res;
            }
        } else {
            if (javaElement.getElementType() == 5) {
                String simpleName = Signature.getSimpleName((String)mainTypeName);
                return ((ICompilationUnit)javaElement).getType(simpleName);
            }
            if (javaElement.getElementType() == 6) {
                return ((IClassFile)javaElement).getType();
            }
        }
        return null;
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected String getProjectOutDir() {
        if (null != this.fProject && this.fProject.exists()) {
            try {
                IPath fullPath = this.fProject.getOutputLocation();
                IPath relativePath = fullPath.removeFirstSegments(1);
                return relativePath.toString();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return "bin";
    }

    protected abstract VMRunnerConfiguration createVMRunner(ILaunchConfiguration var1, IJavaProject var2, int var3, String var4) throws CoreException;
}

