/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.launch;

import java.io.File;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class AbsolutePathTool {
    private AbsolutePathTool() {
    }

    public static File getAbsoluteFile(IJavaProject pJavaProject, File pLocalFile) {
        File projectPath;
        IPath projectIPath = pJavaProject.getProject().getLocation();
        if (null != projectIPath && (projectPath = projectIPath.toFile()).exists() && projectPath.isDirectory()) {
            String fileName = pLocalFile.getPath();
            return new File(projectPath, fileName);
        }
        return null;
    }

    public static File getRelativeFile(IJavaProject pJavaProject, File pAbsoluteFile) {
        String projectName;
        String fileName;
        File projectPath;
        IPath projectIPath = pJavaProject.getProject().getLocation();
        if (null != projectIPath && (projectPath = projectIPath.toFile()).exists() && projectPath.isDirectory() && (fileName = pAbsoluteFile.getPath()).startsWith(projectName = projectPath.getPath())) {
            fileName = fileName.substring(projectName.length());
            return new File(fileName);
        }
        return null;
    }

    public static File[] getProjectOutAndLib(IJavaProject pJavaProject, boolean pAddOutPath, boolean pAddLibPath, boolean pSkipJRELib) throws JavaModelException {
        Vector<File> results = new Vector<File>(20, 20);
        if (pAddOutPath) {
            results.add(AbsolutePathTool.getAbsoluteFile(pJavaProject, pJavaProject.getOutputLocation().removeFirstSegments(1).toFile()));
        }
        if (pAddLibPath) {
            int i;
            IPath jrePath = null;
            if (pSkipJRELib) {
                IClasspathEntry[] rawClasspath = pJavaProject.getRawClasspath();
                i = 0;
                while (i < rawClasspath.length) {
                    String varName;
                    IClasspathEntry rawEntry = rawClasspath[i];
                    if (4 == rawEntry.getEntryKind() && "JRE_LIB".equals(varName = rawEntry.getPath().toString())) {
                        jrePath = JavaCore.getResolvedClasspathEntry((IClasspathEntry)rawEntry).getPath();
                    }
                    ++i;
                }
            }
            IClasspathEntry[] resolvedClasspath = pJavaProject.getResolvedClasspath(true);
            i = 0;
            while (i < resolvedClasspath.length) {
                IPath entryPath;
                IClasspathEntry entry = resolvedClasspath[i];
                if (1 == entry.getEntryKind() && null != (entryPath = entry.getPath())) {
                    if (pSkipJRELib) {
                        if (!entryPath.equals((Object)jrePath)) {
                            results.add(entryPath.toFile());
                        }
                    } else {
                        results.add(entryPath.toFile());
                    }
                }
                ++i;
            }
        }
        return results.toArray(new File[results.size()]);
    }
}

