/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.gui;

import com.sap.tc.jtools.jver.ide.eclipse.gui.IStatusView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.IconKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.gui.JverBaseView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.OpenJavaEditorAction;
import com.sap.tc.jtools.jver.ide.eclipse.gui.TextKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.misc.ITestStatus;
import com.sap.tc.jtools.jver.ide.eclipse.misc.TestStatus;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class StatusViewTree
implements IStatusView,
IMenuListener,
ITestStatus {
    private Tree fTree;
    private Map fTestsetMap = new HashMap();
    private JverBaseView fBaseView;
    private boolean fPressed = false;
    private final Image fIconOkay;
    private final Image fIconFlop;
    private final Image fIconWarning;
    private final Image fIconTestset;
    private final Image fIconTitle;

    public StatusViewTree(CTabFolder tabFolder, JverBaseView pBaseView) {
        this.fBaseView = pBaseView;
        this.fIconOkay = IconKeyGui.OKAY.create(this.fBaseView.getDisplay());
        this.fIconFlop = IconKeyGui.FLOP.create(this.fBaseView.getDisplay());
        this.fIconWarning = IconKeyGui.WARNING.create(this.fBaseView.getDisplay());
        this.fIconTitle = IconKeyGui.STATUS_TREE.create(this.fBaseView.getDisplay());
        this.fIconTestset = IconKeyGui.STATUS_TREE.create(this.fBaseView.getDisplay());
        CTabItem hierarchyTab = new CTabItem(tabFolder, 0);
        hierarchyTab.setText(this.getName());
        hierarchyTab.setImage(this.fIconTitle);
        Composite testTreePanel = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        testTreePanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1536);
        testTreePanel.setLayoutData((Object)gridData);
        hierarchyTab.setControl((Control)testTreePanel);
        hierarchyTab.setToolTipText(TextKeyGui.T321.getText());
        this.fTree = new Tree(testTreePanel, 512);
        gridData = new GridData(1808);
        this.fTree.setLayoutData((Object)gridData);
        this.fIconTestset.setBackground(testTreePanel.getBackground());
        this.fIconFlop.setBackground(testTreePanel.getBackground());
        this.fIconOkay.setBackground(testTreePanel.getBackground());
        this.fIconWarning.setBackground(testTreePanel.getBackground());
        this.initMenu();
        this.addListeners();
    }

    void disposeIcons() {
        if (this.fIconFlop != null && !this.fIconFlop.isDisposed()) {
            this.fIconFlop.dispose();
        }
        if (this.fIconOkay != null && !this.fIconOkay.isDisposed()) {
            this.fIconOkay.dispose();
        }
        if (this.fIconWarning != null && !this.fIconWarning.isDisposed()) {
            this.fIconWarning.dispose();
        }
        if (this.fIconTestset != null && !this.fIconTestset.isDisposed()) {
            this.fIconTestset.dispose();
        }
        if (null != this.fIconTitle && !this.fIconTitle.isDisposed()) {
            this.fIconTitle.dispose();
        }
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTree);
        this.fTree.setMenu(menu);
    }

    private String getTestLabel() {
        TreeItem treeItem = this.fTree.getSelection()[0];
        if (treeItem == null) {
            return "";
        }
        return treeItem.getText();
    }

    public TestStatus getSelectedStatus() {
        TreeItem[] treeItems = this.fTree.getSelection();
        if (treeItems.length == 0) {
            return null;
        }
        return (TestStatus)treeItems[0].getData();
    }

    public String getName() {
        return TextKeyGui.T321.getText();
    }

    public void setSelectedStatus(TestStatus pStatus) {
        TreeItem treeItem = this.findItem(pStatus);
        this.fTree.setSelection(new TreeItem[]{treeItem});
    }

    public void activate() {
        this.testSelected();
    }

    public void aboutToStart() {
        this.fTestsetMap.clear();
        this.fTree.removeAll();
        this.fTree.redraw();
        this.fTree.update();
    }

    protected void testSelected() {
        this.fBaseView.handleStatusSelected(this.getSelectedStatus());
    }

    public void menuAboutToShow(IMenuManager pManager) {
        TestStatus testStatus = this.getSelectedStatus();
        if (null != testStatus) {
            pManager.add((IAction)new OpenJavaEditorAction(this.fBaseView, testStatus.getClassName(), testStatus.getMethodName()));
        }
    }

    private void addListeners() {
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusViewTree.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StatusViewTree.this.activate();
            }
        });
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StatusViewTree.this.disposeIcons();
            }
        });
        this.fTree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                StatusViewTree.this.handleDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                StatusViewTree.this.fPressed = true;
            }

            public void mouseUp(MouseEvent e) {
                StatusViewTree.this.fPressed = false;
            }
        });
        this.fTree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!(e.getSource() instanceof Tree)) {
                    return;
                }
                TreeItem[] treeItem = new TreeItem[]{((Tree)e.getSource()).getItem(new Point(e.x, e.y))};
                if (StatusViewTree.this.fPressed & null != treeItem[0]) {
                    StatusViewTree.this.fTree.setSelection(treeItem);
                    StatusViewTree.this.activate();
                }
                if (e.y < 1 & StatusViewTree.this.fPressed) {
                    try {
                        TreeItem tItem = treeItem[0].getParentItem();
                        StatusViewTree.this.fTree.setSelection(new TreeItem[]{tItem});
                        StatusViewTree.this.activate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void handleDoubleClick(MouseEvent e) {
        TestStatus testStatus = this.getSelectedStatus();
        if (null == testStatus) {
            return;
        }
        OpenJavaEditorAction openAction = testStatus.isTestset() ? new OpenJavaEditorAction(this.fBaseView, testStatus.getClassName()) : new OpenJavaEditorAction(this.fBaseView, testStatus.getClassName(), testStatus.getMethodName());
        openAction.run();
    }

    public void addTestset(String pTestsetName) {
        TestStatus testsetStatus = new TestStatus(pTestsetName);
        if (this.fTestsetMap.containsKey(testsetStatus)) {
            return;
        }
        TreeItem treeItem = new TreeItem(this.fTree, 0);
        treeItem.setImage(this.fIconTestset);
        treeItem.setText(pTestsetName);
        treeItem.setData((Object)testsetStatus);
        this.fTree.showItem(treeItem);
        this.fTree.redraw();
        this.fTestsetMap.put(testsetStatus, treeItem);
    }

    public void addStatus(TestStatus pStatus) {
        if (!this.fBaseView.containsStatus(pStatus)) {
            return;
        }
        TestStatus testsetStatus = new TestStatus(pStatus.getClassName());
        TreeItem testsetItem = (TreeItem)this.fTestsetMap.get(testsetStatus);
        TreeItem parentNode = null;
        if (null != testsetItem) {
            parentNode = testsetItem;
        }
        TreeItem treeItem = null == parentNode ? new TreeItem(this.fTree, 0) : new TreeItem(parentNode, 0);
        treeItem.setText(pStatus.getTestName());
        treeItem.setData((Object)pStatus);
        this.setIcon(treeItem, pStatus);
        this.fTree.showItem(treeItem);
        this.fTree.redraw();
    }

    private void setIcon(TreeItem pTreeItem, TestStatus pStatus) {
        pTreeItem.setData((Object)pStatus);
        if (pStatus.isTestcase()) {
            switch (pStatus.getStatus()) {
                case 22: {
                    pTreeItem.setImage(this.fIconOkay);
                    break;
                }
                case 33: {
                    pTreeItem.setImage(this.fIconFlop);
                    break;
                }
                case 44: {
                    pTreeItem.setImage(this.fIconWarning);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private TreeItem findItem(TestStatus pStatus) {
        TreeItem[] items = this.fTree.getItems();
        int ii = 0;
        while (ii < items.length) {
            if (items[ii].getData() == pStatus) {
                return items[ii];
            }
            ++ii;
        }
        return null;
    }
}

