/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.gui;

import com.sap.tc.jtools.jver.ide.eclipse.gui.IStatusView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.IconKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.gui.JverBaseView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.OpenJavaEditorAction;
import com.sap.tc.jtools.jver.ide.eclipse.gui.TextKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.misc.ITestStatus;
import com.sap.tc.jtools.jver.ide.eclipse.misc.TestStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class StatusViewPlain
implements IStatusView,
IMenuListener,
ITestStatus {
    private Table fFailuresSwt;
    private JverBaseView fMainView;
    private boolean fPressed = false;
    private final Image fIconTitle;
    private final Image fIconFlop;
    private final Image fIconWarning;

    public StatusViewPlain(CTabFolder pTabFolder, JverBaseView pMainView) {
        this.fMainView = pMainView;
        this.fIconWarning = IconKeyGui.WARNING.create(this.fMainView.getDisplay());
        this.fIconFlop = IconKeyGui.FLOP.create(this.fMainView.getDisplay());
        this.fIconTitle = IconKeyGui.STATUS_PLAIN.create(this.fMainView.getDisplay());
        CTabItem failureTab = new CTabItem(pTabFolder, 0);
        failureTab.setText(this.getName());
        this.fIconFlop.setBackground(pTabFolder.getBackground());
        failureTab.setImage(this.fIconTitle);
        Composite composite = new Composite((Composite)pTabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.fFailuresSwt = new Table(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fFailuresSwt.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        this.fFailuresSwt.setLayoutData((Object)gridData);
        failureTab.setControl((Control)composite);
        failureTab.setToolTipText(TextKeyGui.T500.getText());
        this.fFailuresSwt.setToolTipText(TextKeyGui.T501.getText());
        this.fIconFlop.setBackground(this.fFailuresSwt.getBackground());
        this.fIconWarning.setBackground(this.fFailuresSwt.getBackground());
        this.fIconTitle.setBackground(pTabFolder.getBackground());
        this.initMenu();
        this.addListeners();
    }

    void disposeIcons() {
        if (null != this.fIconFlop && !this.fIconFlop.isDisposed()) {
            this.fIconFlop.dispose();
        }
        if (null != this.fIconWarning && !this.fIconWarning.isDisposed()) {
            this.fIconWarning.dispose();
        }
        if (null != this.fIconTitle && !this.fIconTitle.isDisposed()) {
            this.fIconTitle.dispose();
        }
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fFailuresSwt);
        this.fFailuresSwt.setMenu(menu);
    }

    public String getName() {
        return TextKeyGui.T305.getText();
    }

    public void menuAboutToShow(IMenuManager manager) {
        TestStatus curStatus = this.getSelectedStatus();
        if (null == curStatus) {
            return;
        }
        if (0 < this.fFailuresSwt.getSelectionCount()) {
            OpenJavaEditorAction openAction = new OpenJavaEditorAction(this.fMainView, curStatus.getClassName(), curStatus.getMethodName());
            manager.add((IAction)openAction);
        }
    }

    private String getSelectedText() {
        int index = this.fFailuresSwt.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.fFailuresSwt.getItem(index).getText();
    }

    public TestStatus getSelectedStatus() {
        int index = this.fFailuresSwt.getSelectionIndex();
        if (0 > index) {
            return null;
        }
        return (TestStatus)this.fFailuresSwt.getItem(index).getData();
    }

    public void setSelectedStatus(TestStatus pStatus) {
        TableItem[] items = this.fFailuresSwt.getItems();
        int ii = 0;
        while (ii < items.length) {
            TableItem tableItem = items[ii];
            if (tableItem.getData() == pStatus) {
                this.fFailuresSwt.setSelection(new TableItem[]{tableItem});
                this.fFailuresSwt.showItem(tableItem);
                return;
            }
            ++ii;
        }
    }

    public void addStatus(TestStatus pTestStatus) {
        if (!this.fMainView.containsStatus(pTestStatus)) {
            return;
        }
        if (null == pTestStatus || 22 == pTestStatus.getStatus()) {
            return;
        }
        TableItem tableItem = new TableItem(this.fFailuresSwt, 0);
        this.updateTableItem(pTestStatus, tableItem);
        this.fFailuresSwt.showItem(tableItem);
        this.fFailuresSwt.redraw();
    }

    private void updateTableItem(TestStatus pStatus, TableItem tableItem) {
        tableItem.setText(pStatus.getTestName());
        if (33 == pStatus.getStatus()) {
            tableItem.setImage(this.fIconFlop);
        } else {
            tableItem.setImage(this.fIconWarning);
        }
        tableItem.setData((Object)pStatus);
    }

    private TableItem findItem(TestStatus pStatus) {
        TableItem[] items = this.fFailuresSwt.getItems();
        int ii = 0;
        while (ii < items.length) {
            if (items[ii].getData() == pStatus) {
                return items[ii];
            }
            ++ii;
        }
        return null;
    }

    public void activate() {
        this.testSelected();
    }

    public void aboutToStart() {
        this.fFailuresSwt.removeAll();
        this.fFailuresSwt.redraw();
        this.fFailuresSwt.update();
    }

    protected void testSelected() {
        this.fMainView.handleStatusSelected(this.getSelectedStatus());
    }

    protected void addListeners() {
        this.fFailuresSwt.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusViewPlain.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StatusViewPlain.this.activate();
            }
        });
        this.fFailuresSwt.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StatusViewPlain.this.disposeIcons();
            }
        });
        this.fFailuresSwt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                StatusViewPlain.this.handleDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                StatusViewPlain.this.fPressed = true;
                StatusViewPlain.this.activate();
            }

            public void mouseUp(MouseEvent e) {
                StatusViewPlain.this.fPressed = false;
                StatusViewPlain.this.activate();
            }
        });
        this.fFailuresSwt.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TableItem tableItem = ((Table)e.getSource()).getItem(new Point(e.x, e.y));
                if (StatusViewPlain.this.fPressed & null != tableItem) {
                    StatusViewPlain.this.fFailuresSwt.setSelection(new TableItem[]{tableItem});
                    StatusViewPlain.this.activate();
                }
                if (e.y + 1 > ((StatusViewPlain)StatusViewPlain.this).fFailuresSwt.getBounds().height & StatusViewPlain.this.fPressed & StatusViewPlain.this.fFailuresSwt.getSelectionIndex() != StatusViewPlain.this.fFailuresSwt.getItemCount() - 1) {
                    StatusViewPlain.this.fFailuresSwt.setTopIndex(StatusViewPlain.this.fFailuresSwt.getTopIndex() + 1);
                    StatusViewPlain.this.fFailuresSwt.setSelection(StatusViewPlain.this.fFailuresSwt.getSelectionIndex() + 1);
                    StatusViewPlain.this.activate();
                }
                if (e.y - 1 < 0 & StatusViewPlain.this.fPressed & StatusViewPlain.this.fFailuresSwt.getTopIndex() != 0) {
                    StatusViewPlain.this.fFailuresSwt.setTopIndex(StatusViewPlain.this.fFailuresSwt.getTopIndex() - 1);
                    StatusViewPlain.this.fFailuresSwt.setSelection(StatusViewPlain.this.fFailuresSwt.getSelectionIndex() - 1);
                    StatusViewPlain.this.activate();
                }
            }
        });
    }

    public void handleDoubleClick(MouseEvent e) {
        TestStatus curStatus = this.getSelectedStatus();
        if (null != curStatus) {
            OpenJavaEditorAction openAction = new OpenJavaEditorAction(this.fMainView, curStatus.getClassName(), curStatus.getMethodName());
            openAction.run();
        }
    }

    public void addTestset(String pNotSupported) {
        if (null == pNotSupported) {
            // empty if block
        }
    }
}

