/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.gui;

import com.sap.tc.jtools.jver.ide.eclipse.gui.CopyStacktraceAction;
import com.sap.tc.jtools.jver.ide.eclipse.gui.IconKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.gui.JverBaseView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.JverPreferencePage;
import com.sap.tc.jtools.jver.ide.eclipse.gui.OpenJavaEditorAction;
import com.sap.tc.jtools.jver.ide.eclipse.gui.TextKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.util.StackInfo;
import com.sap.tc.jtools.jver.ide.eclipse.util.StringBuf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

final class StacktraceView
implements IMenuListener {
    private final Image fIconExcp;
    private final Image fIconInfo;
    private final Image fIconStack;
    private JverBaseView fBaseView;
    private String fStacktrace;
    private Table fTraceSwt;

    public StacktraceView(Composite parent, JverBaseView pBaseView) {
        this.fBaseView = pBaseView;
        this.fIconExcp = IconKeyGui.SV_XPT.create(this.fBaseView.getDisplay());
        this.fIconInfo = IconKeyGui.SV_INFO.create(this.fBaseView.getDisplay());
        this.fIconStack = IconKeyGui.SV_STACK.create(this.fBaseView.getDisplay());
        this.fTraceSwt = new Table(parent, 772);
        this.fTraceSwt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                StacktraceView.this.handleDoubleClick(e);
            }
        });
        this.initMenu();
        this.initIcons();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StacktraceView.this.disposeIcons();
            }
        });
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTraceSwt);
        this.fTraceSwt.setMenu(menu);
    }

    private void initIcons() {
        this.fIconExcp.setBackground(this.fTraceSwt.getBackground());
        this.fIconInfo.setBackground(this.fTraceSwt.getBackground());
        this.fIconStack.setBackground(this.fTraceSwt.getBackground());
    }

    void disposeIcons() {
        if (null != this.fIconExcp && !this.fIconExcp.isDisposed()) {
            this.fIconExcp.dispose();
        }
        if (null != this.fIconInfo && !this.fIconInfo.isDisposed()) {
            this.fIconInfo.dispose();
        }
        if (null != this.fIconStack && !this.fIconStack.isDisposed()) {
            this.fIconStack.dispose();
        }
    }

    void handleDoubleClick(MouseEvent e) {
        Action a;
        if (0 < this.fTraceSwt.getSelectionCount() && (a = this.createOpenAction(this.getSelectedText())) != null) {
            a.run();
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        Action a;
        if (0 < this.fTraceSwt.getSelectionCount() && (a = this.createOpenAction(this.getSelectedText())) != null) {
            manager.add((IAction)a);
        }
        manager.add((IAction)new CopyStacktraceAction(this));
    }

    public String getTrace() {
        return this.fStacktrace;
    }

    private String getSelectedText() {
        return this.fTraceSwt.getSelection()[0].getText();
    }

    private Action createOpenAction(String pTraceLine) {
        StackInfo stackInfo = StackInfo.newInstance(pTraceLine);
        String fullName = stackInfo.getFullName();
        int lineNbr = stackInfo.getLineNumber();
        if (null != fullName) {
            return new OpenJavaEditorAction(this.fBaseView, fullName, lineNbr);
        }
        return null;
    }

    public Composite getComposite() {
        return this.fTraceSwt;
    }

    public void refresh() {
        this.updateTable(this.fStacktrace);
    }

    public void showFailure(String pStacktrace) {
        if (this.fStacktrace != pStacktrace) {
            this.fStacktrace = pStacktrace;
            this.updateTable(this.fStacktrace);
        }
    }

    private void updateTable(String pStacktrace) {
        if (null == pStacktrace) {
            this.clear();
            return;
        }
        this.fTraceSwt.setRedraw(false);
        this.fTraceSwt.removeAll();
        this.fillTable(this.filterStack(this.splitStack(pStacktrace)));
        this.fTraceSwt.setRedraw(true);
        this.fTraceSwt.update();
    }

    protected void fillTable(String[] pTrace) {
        TableItem tableItem = null;
        int countItem = 0;
        if (null != pTrace) {
            int ii = 0;
            while (ii < pTrace.length) {
                if (null != pTrace[ii]) {
                    StringBuf textBuf = new StringBuf(pTrace[ii]);
                    textBuf.replaceWhitespace().trim();
                    if (0 != textBuf.getLength()) {
                        tableItem = new TableItem(this.fTraceSwt, 0);
                        tableItem.setText(textBuf.toString());
                        if (0 == countItem) {
                            tableItem.setImage(this.fIconExcp);
                        } else if (0 <= textBuf.indexOf("at ")) {
                            tableItem.setImage(this.fIconStack);
                        }
                        ++countItem;
                    }
                }
                ++ii;
            }
        }
        if (0 == countItem) {
            tableItem = new TableItem(this.fTraceSwt, 0);
            tableItem.setText(TextKeyGui.T652.getText());
            tableItem.setImage(this.fIconInfo);
        }
    }

    public void setInformation(String text) {
        this.clear();
        TableItem tableItem = new TableItem(this.fTraceSwt, 0);
        tableItem.setImage(this.fIconInfo);
        tableItem.setText(text);
    }

    public void clear() {
        this.fTraceSwt.removeAll();
        this.fStacktrace = null;
    }

    /*
     * WARNING - void declaration
     */
    private String[] splitStack(String pStacktrace) {
        Vector<void> workList = new Vector<void>(10, 10);
        if (null == pStacktrace) {
            return null;
        }
        StringReader stringReader = new StringReader(pStacktrace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while (null != (line = bufferedReader.readLine())) {
                void var5_5;
                workList.add(var5_5);
            }
        }
        catch (IOException e) {
            return new String[]{pStacktrace};
        }
        if (workList.isEmpty()) {
            return null;
        }
        String[] resultList = new String[workList.size()];
        int ii = 0;
        while (ii < workList.size()) {
            resultList[ii] = (String)workList.get(ii);
            ++ii;
        }
        return resultList;
    }

    private String[] filterStack(String[] pStack) {
        if (null == pStack || 0 >= pStack.length) {
            return null;
        }
        if (!JverPreferencePage.getFilterStack()) {
            return pStack;
        }
        String[] patterns = JverPreferencePage.getFilterPatterns();
        int ii = 1;
        while (ii < pStack.length) {
            if (null != pStack[ii]) {
                String curLine = pStack[ii];
                int jj = 0;
                while (jj < patterns.length) {
                    if (0 <= curLine.indexOf(patterns[jj])) {
                        pStack[ii] = null;
                        break;
                    }
                    ++jj;
                }
            }
            ++ii;
        }
        return pStack;
    }
}

