/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.gui;

import com.sap.tc.jtools.jver.ide.eclipse.gui.IconKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.gui.TextKeyGui;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class ProgressPanel
extends Composite {
    private static String fgZero = Integer.toString(0);
    private static String fgZeroZero = fgZero + "/" + fgZero;
    private final Image fIconFlop;
    private final Image fIconWarning;
    private final Image fIconTestset;
    private final Color fColorBlack;
    private final Color fColorRed;
    private Label fLabelFlop;
    private Label fLabelWarning;
    private Label fLabelTestset;
    private int fTotal = 0;
    private String fTotalTx = fgZero;

    public ProgressPanel(Composite parent) {
        super(parent, 64);
        this.fColorBlack = this.getDisplay().getSystemColor(2);
        this.fColorRed = this.getDisplay().getSystemColor(3);
        this.fIconFlop = IconKeyGui.FLOP.create(this.getDisplay());
        this.fIconWarning = IconKeyGui.WARNING.create(this.getDisplay());
        this.fIconTestset = IconKeyGui.TESTRUN.create(this.getDisplay());
        this.fLabelFlop = this.createLabel(TextKeyGui.T200.getText(), this.fIconFlop);
        this.fLabelWarning = this.createLabel(TextKeyGui.T201.getText(), this.fIconWarning);
        this.fLabelTestset = this.createLabel(TextKeyGui.T202.getText(), this.fIconTestset);
        this.resetCounters();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProgressPanel.this.disposeIcons();
            }
        });
    }

    void disposeIcons() {
        if (!this.fIconFlop.isDisposed()) {
            this.fIconFlop.dispose();
        }
        if (!this.fIconWarning.isDisposed()) {
            this.fIconWarning.dispose();
        }
        if (!this.fIconTestset.isDisposed()) {
            this.fIconTestset.dispose();
        }
    }

    private Label createLabel(String pTitle, Image pIcon) {
        Label newLabel = new Label((Composite)this, 0);
        if (null != pIcon) {
            pIcon.setBackground(newLabel.getBackground());
            newLabel.setImage(pIcon);
        }
        newLabel.setLayoutData((Object)new GridData(32));
        newLabel = new Label((Composite)this, 0);
        newLabel.setText(pTitle);
        newLabel.setLayoutData((Object)new GridData(32));
        newLabel = new Label((Composite)this, 0);
        newLabel.setLayoutData((Object)new GridData(800));
        return newLabel;
    }

    public void resetCounters() {
        this.fLabelWarning.setForeground(this.fColorBlack);
        this.fLabelFlop.setForeground(this.fColorBlack);
        this.fLabelFlop.setText(fgZero);
        this.fLabelWarning.setText(fgZero);
        this.fLabelTestset.setText(fgZeroZero);
        this.fTotal = 0;
        this.fTotalTx = fgZero;
    }

    public void setTestTotal(int pNumOfTests) {
        this.fTotal = pNumOfTests;
        this.fTotalTx = Integer.toString(pNumOfTests);
    }

    public int getTestRunTotal() {
        return this.fTotal;
    }

    public void setTestsetCount(int pNumCurrentTestset) {
        this.fLabelTestset.setText(Integer.toString(pNumCurrentTestset) + "/" + this.fTotalTx);
        this.fLabelTestset.redraw();
    }

    public void setFlopCount(int pCount) {
        if (0 > pCount) {
            this.fLabelFlop.setForeground(this.fColorBlack);
            this.fLabelFlop.setText(fgZero);
        } else {
            this.fLabelFlop.setForeground(this.fColorRed);
            this.fLabelFlop.setText(Integer.toString(pCount));
        }
        this.fLabelFlop.redraw();
    }

    public void setWarningCount(int pCount) {
        if (0 > pCount) {
            this.fLabelWarning.setForeground(this.fColorBlack);
            this.fLabelWarning.setText(fgZero);
        } else {
            this.fLabelWarning.setForeground(this.fColorRed);
            this.fLabelWarning.setText(Integer.toString(pCount));
        }
        this.fLabelWarning.redraw();
    }
}

