/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.gui;

import com.sap.tc.jtools.jver.ide.eclipse.gui.JverBaseView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.TextKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.util.StringBuf;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public final class OpenJavaEditorAction
extends Action {
    final JverBaseView fBaseView;
    final String fClazzName;
    String fMethodName;
    ISourceRange fMethodRange;
    int fLineNbr;
    static final String[] fgDummy = new String[0];

    public OpenJavaEditorAction(JverBaseView pBaseView, String pClazzName) {
        super(TextKeyGui.T050.getText());
        this.fBaseView = pBaseView;
        this.fClazzName = pClazzName;
        this.fMethodName = null;
        this.fMethodRange = null;
        this.fLineNbr = 0;
    }

    public OpenJavaEditorAction(JverBaseView pBaseView, String pClazzName, int pLineNbr) {
        this(pBaseView, pClazzName);
        this.fLineNbr = pLineNbr;
    }

    public OpenJavaEditorAction(JverBaseView pBaseView, String pClazzName, String pMethodName) {
        this(pBaseView, pClazzName);
        this.fMethodName = pMethodName;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IJavaElement javaElement = this.findElement();
            if (null == javaElement) {
                String classFile = null == this.fClazzName || 0 == this.fClazzName.length() ? "<unknown class>" : this.fClazzName;
                MessageDialog.openError((Shell)this.fBaseView.getShell(), (String)TextKeyGui.T100.getText(), (String)TextKeyGui.T101.getFormattedText(classFile));
                return;
            }
            textEditor = (ITextEditor)EditorUtility.openInEditor((Object)javaElement, (boolean)false);
        }
        catch (CoreException exC) {
            ErrorDialog.openError((Shell)this.fBaseView.getShell(), (String)TextKeyGui.ERROR.getText(), (String)TextKeyGui.T101.getFormattedText(this.fClazzName), (IStatus)exC.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fBaseView.postInfo(TextKeyGui.T102.getText());
            return;
        }
        this.reveal(textEditor);
    }

    private IJavaElement findElement() throws JavaModelException {
        IType clazz = this.findClazz();
        if (null == clazz) {
            return null;
        }
        if (null == this.fMethodName) {
            return clazz;
        }
        try {
            IMethod method = this.findMethod(clazz);
            if (null == method) {
                ITypeHierarchy inheritanceHierarchy = clazz.newSupertypeHierarchy(null);
                IType[] parentClazzes = inheritanceHierarchy.getAllSuperclasses(clazz);
                int ii = 0;
                while (ii < parentClazzes.length && null == method) {
                    method = this.findMethod(parentClazzes[ii]);
                    ++ii;
                }
            }
            if (method != null) {
                this.fMethodRange = method.getNameRange();
                return method;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        this.fMethodRange = null;
        this.fLineNbr = 1;
        return clazz;
    }

    private IType findClazz() throws JavaModelException {
        StringBuf name = new StringBuf(this.fClazzName).replace('.', '/').append(".java");
        IJavaElement element = this.fBaseView.getLaunchedProject().findElement((IPath)new Path(name.toString()));
        if (element instanceof ICompilationUnit) {
            String simpleName = Signature.getSimpleName((String)this.fClazzName);
            return ((ICompilationUnit)element).getType(simpleName);
        }
        if (element instanceof IClassFile) {
            return ((IClassFile)element).getType();
        }
        return null;
    }

    private IMethod findMethod(IType typeClazz) throws JavaModelException {
        IMethod method = typeClazz.getMethod(this.fMethodName, fgDummy);
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    private void reveal(ITextEditor pEditor) {
        if (null != this.fMethodRange) {
            pEditor.selectAndReveal(this.fMethodRange.getOffset(), this.fMethodRange.getLength());
        } else {
            try {
                IDocument curDoc = pEditor.getDocumentProvider().getDocument((Object)pEditor.getEditorInput());
                int lineNbr = this.fLineNbr - 1;
                if (1 > lineNbr || lineNbr > curDoc.getLength()) {
                    lineNbr = 1;
                }
                pEditor.selectAndReveal(curDoc.getLineOffset(lineNbr), curDoc.getLineLength(lineNbr));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

