/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.gui;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.gui.FilterPatternsDialog;
import com.sap.tc.jtools.jver.ide.eclipse.gui.TextKeyGui;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class JverPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static final String SYSTEM_OUT = "System.out";
    private String fFilterString;
    private Table fSwtTable;
    private Button fAddButton;
    private Button fRemoveButton;
    private Text fSwtDriverLog;
    private Text fSwtPerformanceLog;
    private Text fSwtApplicationLog;
    public static final String PARAM_FILTER_ENTRIES_COUNT = "JVER_FILTER_ENTRIES_COUNT";
    public static final String PARAM_FILTER_ENTRY_ = "JVER_FILTER_ENTRY_";
    public static final String PARAM_DO_FILTER_STACK = "JVER_DO_FILTER_STACK";
    public static final String PARAM_LOG_DRIVER = "JVER_LOG_RUNNER";
    public static final String PARAM_LOG_PERFORMANCE = "JVER_LOG_PERFORMANCE";
    public static final String PARAM_LOG_APPLICATION = "JVER_LOG_APPLICATION";
    private static final String[] fgDefaultFilterPatterns = new String[]{"com.sap.ide.eclipse.plugin", "com.sap.tc.jtools.jver.driver", "com.sap.tc.jtools.jver.framework", "com.sap.tc.jtools.jver.scanner", "java.lang.reflect.Method.invoke"};

    public JverPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        if (null == workbench) {
            // empty if block
        }
    }

    public static String[] getFilterPatterns() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        int numPatterns = prefStore.getInt(PARAM_FILTER_ENTRIES_COUNT);
        String[] resultArray = new String[numPatterns];
        int ii = 0;
        while (ii < numPatterns) {
            resultArray[ii] = prefStore.getString(PARAM_FILTER_ENTRY_ + ii);
            ++ii;
        }
        return resultArray;
    }

    public static String getDriverLog() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        return prefStore.getString(PARAM_LOG_DRIVER);
    }

    public static String getPerformanceLog() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        return prefStore.getString(PARAM_LOG_PERFORMANCE);
    }

    public static String getApplicationLog() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        return prefStore.getString(PARAM_LOG_APPLICATION);
    }

    public static boolean getFilterStack() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        return prefStore.getBoolean(PARAM_DO_FILTER_STACK);
    }

    public static void setFilterStack(boolean pDoFilter) {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        prefStore.setValue(PARAM_DO_FILTER_STACK, pDoFilter);
    }

    public static void initializeDefaults(IPreferenceStore pStore) {
        pStore.setDefault(PARAM_LOG_DRIVER, SYSTEM_OUT);
        pStore.setDefault(PARAM_LOG_PERFORMANCE, SYSTEM_OUT);
        pStore.setDefault(PARAM_LOG_APPLICATION, SYSTEM_OUT);
        pStore.setDefault(PARAM_DO_FILTER_STACK, true);
        int numPatterns = pStore.getInt(PARAM_FILTER_ENTRIES_COUNT);
        if (0 == numPatterns) {
            pStore.setValue(PARAM_FILTER_ENTRIES_COUNT, fgDefaultFilterPatterns.length);
            int ii = 0;
            while (ii < fgDefaultFilterPatterns.length) {
                pStore.setValue(PARAM_FILTER_ENTRY_ + ii, fgDefaultFilterPatterns[ii]);
                ++ii;
            }
        }
    }

    public void createControl(Composite pParentComposite) {
        super.createControl(pParentComposite);
    }

    protected Control createContents(Composite pParentComposite) {
        this.noDefaultAndApplyButton();
        Composite composite = this.createContainer(pParentComposite);
        this.createCheckPanel(composite);
        this.createFilterTable(composite);
        this.createAddRemovePanel(composite);
        composite = this.createContainer(pParentComposite);
        this.createDriverLog(composite);
        this.createPerformanceLog(composite);
        this.createApplicationLog(composite);
        return composite;
    }

    protected Composite createContainer(Composite pParentComposite) {
        Composite composite = new Composite(pParentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    protected void createCheckPanel(Composite pComposite) {
        Composite checkPanel = new Composite(pComposite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        checkPanel.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        checkPanel.setLayout((Layout)layout);
    }

    protected void createAddRemovePanel(Composite pComposite) {
        Composite buttonPanel = new Composite(pComposite, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        this.createAddButton(buttonPanel);
        this.createRemoveButton(buttonPanel);
    }

    protected void createRemoveButton(Composite buttonPanel) {
        this.fRemoveButton = new Button(buttonPanel, 8);
        this.fRemoveButton.setText(TextKeyGui.T053.getText());
        this.setButtonGridData(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
    }

    protected void createAddButton(Composite buttonPanel) {
        this.fAddButton = new Button(buttonPanel, 8);
        this.fAddButton.setText(TextKeyGui.T052.getText());
        this.setButtonGridData(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)this);
    }

    protected void createFilterTable(Composite pComposite) {
        Label label = new Label(pComposite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(TextKeyGui.T600.getText());
        this.fSwtTable = new Table(pComposite, 2052);
        gridData = new GridData(1808);
        this.fSwtTable.setLayoutData((Object)gridData);
        this.fSwtTable.addSelectionListener((SelectionListener)this);
        this.fillList();
        if (0 > this.fSwtTable.getItemCount()) {
            this.fSwtTable.setSelection(0);
        }
    }

    protected void createDriverLog(Composite pComposite) {
        Label label = new Label(pComposite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(TextKeyGui.T610.getText());
        this.fSwtDriverLog = new Text(pComposite, 2052);
        this.fSwtDriverLog.setToolTipText(TextKeyGui.T611.getText());
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fSwtDriverLog.setLayoutData((Object)gridData);
        this.fSwtDriverLog.setText(JverPreferencePage.getDriverLog());
    }

    protected void createPerformanceLog(Composite pComposite) {
        Label label = new Label(pComposite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(TextKeyGui.T612.getText());
        this.fSwtPerformanceLog = new Text(pComposite, 2052);
        this.fSwtPerformanceLog.setToolTipText(TextKeyGui.T613.getText());
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fSwtPerformanceLog.setLayoutData((Object)gridData);
        this.fSwtPerformanceLog.setText(JverPreferencePage.getPerformanceLog());
    }

    protected void createApplicationLog(Composite pComposite) {
        Label label = new Label(pComposite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(TextKeyGui.T614.getText());
        this.fSwtApplicationLog = new Text(pComposite, 2052);
        this.fSwtApplicationLog.setToolTipText(TextKeyGui.T615.getText());
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fSwtApplicationLog.setLayoutData((Object)gridData);
        this.fSwtApplicationLog.setText(JverPreferencePage.getApplicationLog());
    }

    public void widgetDefaultSelected(SelectionEvent pSelectionEvent) {
        this.widgetSelected(pSelectionEvent);
    }

    public void widgetSelected(SelectionEvent pSelectionEvent) {
        if (pSelectionEvent.getSource().equals(this.fAddButton)) {
            FilterPatternsDialog filterDialog = new FilterPatternsDialog(this.getControl().getShell(), TextKeyGui.T052.getText(), TextKeyGui.T650.getText());
            filterDialog.open();
            String textPattern = filterDialog.getValue();
            this.addFilterString(textPattern);
            this.fSwtTable.select(this.fSwtTable.getItemCount() - 1);
        } else if (pSelectionEvent.getSource().equals(this.fRemoveButton) && 0 < this.fSwtTable.getSelectionCount()) {
            this.fSwtTable.remove(this.fSwtTable.getSelectionIndex());
        }
        this.fRemoveButton.setEnabled(-1 != this.fSwtTable.getSelectionIndex());
    }

    protected void addFilterString(String pNewEntry) {
        if (null != pNewEntry) {
            TableItem tableItem = new TableItem(this.fSwtTable, 0);
            tableItem.setText(pNewEntry);
        }
    }

    public boolean performOk() {
        IPreferenceStore prefStore = this.getPreferenceStore();
        int filterEntriesCount = this.fSwtTable.getItemCount();
        prefStore.setValue(PARAM_FILTER_ENTRIES_COUNT, filterEntriesCount);
        int ii = 0;
        while (ii < filterEntriesCount) {
            prefStore.setValue(PARAM_FILTER_ENTRY_ + ii, this.fSwtTable.getItem(ii).getText());
            ++ii;
        }
        prefStore.setValue(PARAM_LOG_DRIVER, this.fSwtDriverLog.getText());
        prefStore.setValue(PARAM_LOG_PERFORMANCE, this.fSwtPerformanceLog.getText());
        prefStore.setValue(PARAM_LOG_APPLICATION, this.fSwtApplicationLog.getText());
        return true;
    }

    private void fillList() {
        String[] patterns = JverPreferencePage.getFilterPatterns();
        int ii = 0;
        while (ii < patterns.length) {
            TableItem tableItem = new TableItem(this.fSwtTable, 0);
            tableItem.setText(patterns[ii]);
            ++ii;
        }
    }

    protected void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 32;
        gridData.verticalAlignment = 2;
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint((Button)button);
    }
}

