/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.ide.eclipse.gui;

import com.sap.tc.jtools.jver.ide.eclipse.Plugin;
import com.sap.tc.jtools.jver.ide.eclipse.gui.CopyStacktraceAction;
import com.sap.tc.jtools.jver.ide.eclipse.gui.CustomTabLayout;
import com.sap.tc.jtools.jver.ide.eclipse.gui.IStatusView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.IconKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.gui.ProgressPanel;
import com.sap.tc.jtools.jver.ide.eclipse.gui.StacktraceView;
import com.sap.tc.jtools.jver.ide.eclipse.gui.StatusViewPlain;
import com.sap.tc.jtools.jver.ide.eclipse.gui.StatusViewTree;
import com.sap.tc.jtools.jver.ide.eclipse.gui.TextKeyGui;
import com.sap.tc.jtools.jver.ide.eclipse.gui.UseStacktraceFilerAction;
import com.sap.tc.jtools.jver.ide.eclipse.misc.ITestStatus;
import com.sap.tc.jtools.jver.ide.eclipse.misc.TestStatus;
import com.sap.tc.jtools.jver.remotedriver.tcp.IEvaluation;
import com.sap.tc.jtools.jver.remotedriver.tcp.ListenerPeer;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public final class JverBaseView
extends ViewPart
implements IEvaluation,
ITestStatus,
IPropertyChangeListener {
    protected final int PROGRESS_METHOD_FACTOR = 20;
    protected int fCntFlops;
    protected int fCntWarnings;
    protected int fCntTestsetRun;
    protected int fNumTestset;
    protected String fLastTestsetName = "";
    protected int fCntTestcaseRunTask = 0;
    protected int fCntTestcaseRun = 0;
    protected int fUprTestcaseRun = 20;
    protected boolean fJobError;
    protected boolean fIsDisposed;
    public static final String ECLIPSE_ID_BASEVIEW = "com.sap.tc.jtools.jver.ide.eclipse.gui.jverbaseview";
    private final String UNKNOWN_TESTSET = "TestsetUnknown";
    private final String UNKNOWN_TESTCASE = "TestcaseUnknown";
    private IJavaProject fJavaProject;
    private Vector fStatusVector = new Vector(40, 20);
    private ProgressBar fProgressBar;
    private ProgressPanel fProgressPanel;
    private StacktraceView fStacktraceView;
    private Vector fStatusViewVector = new Vector();
    private IStatusView fActiveStatusView;
    private ListenerPeer fPeerHandle;
    private String fLaunchMode;

    public void stopTest() {
        if (null != this.fPeerHandle) {
            this.fPeerHandle.abortTestjob();
        }
    }

    public void processJobStart(int pNumberOfTestsets, final String pJVerVersion) {
        this.reset(pNumberOfTestsets);
        this.fLastTestsetName = "";
        if (null != pJVerVersion && 0 < pJVerVersion.length()) {
            this.postSyncRunnable(new Runnable(){

                public void run() {
                    if (!JverBaseView.this.isDisposed()) {
                        JverBaseView.super.setTitle(JverBaseView.this.computeTitle(pJVerVersion));
                    }
                }
            });
        }
    }

    public void processJobCompletion(long pElapsed) {
        if (this.fCntTestsetRun + 1 < this.fNumTestset) {
            this.fJobError = true;
        } else {
            this.fCntTestsetRun = this.fNumTestset;
        }
        String[] wildCards = new String[]{this.elapsedTimeAsString(pElapsed), Integer.toString(this.fCntTestcaseRunTask)};
        this.postInfo(TextKeyGui.T302.getFormattedText(wildCards));
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.refreshProgressPanelPosted();
                JverBaseView.this.refreshProgressBarPosted();
                if (0 < JverBaseView.this.fStatusVector.size()) {
                    TestStatus firstStatus = null;
                    firstStatus = (TestStatus)JverBaseView.this.fStatusVector.elementAt(0);
                    JverBaseView.this.fActiveStatusView.setSelectedStatus(firstStatus);
                    JverBaseView.this.handleStatusSelected(firstStatus);
                }
            }
        });
    }

    private void showFailure(final String pFailure) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!JverBaseView.this.isDisposed()) {
                    JverBaseView.this.fStacktraceView.showFailure(pFailure);
                }
            }
        });
    }

    public void processJobAbortion(long pElapsed) {
        this.fJobError = true;
        this.postInfo(TextKeyGui.T303.getFormattedText(this.elapsedTimeAsString(pElapsed)));
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.refreshProgressPanelPosted();
                if (0 < JverBaseView.this.fStatusVector.size()) {
                    TestStatus lastStatus = (TestStatus)JverBaseView.this.fStatusVector.lastElement();
                    JverBaseView.this.fActiveStatusView.setSelectedStatus(lastStatus);
                    JverBaseView.this.handleStatusSelected(lastStatus);
                }
            }
        });
    }

    public void processJobTermination(String pMessage) {
        this.fJobError = true;
        if (null == pMessage) {
            pMessage = "";
        }
        this.postInfo(TextKeyGui.T304.getFormattedText(pMessage));
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.refreshProgressPanelPosted();
                if (0 < JverBaseView.this.fStatusVector.size()) {
                    TestStatus lastStatus = (TestStatus)JverBaseView.this.fStatusVector.lastElement();
                    JverBaseView.this.fActiveStatusView.setSelectedStatus(lastStatus);
                    JverBaseView.this.handleStatusSelected(lastStatus);
                }
            }
        });
    }

    public void processTestsetStart(String pTestsetName) {
        this.fLastTestsetName = pTestsetName;
        this.fCntTestcaseRun = 0;
        this.fUprTestcaseRun = 20;
        this.postTestsetStart(pTestsetName);
        if (1 > this.fCntTestsetRun) {
            this.postShowTestResultsView();
        }
    }

    public void processTestsetExpectedTestcount(String pTestsetName, int pEstimatedNumberofTestmethods) {
        if (0 == this.fCntTestcaseRun && this.fLastTestsetName == pTestsetName && 0 < pEstimatedNumberofTestmethods) {
            this.fUprTestcaseRun = pEstimatedNumberofTestmethods;
        }
    }

    public void processTestsetCompletion(String pTestsetName) {
        ++this.fCntTestsetRun;
        this.fLastTestsetName = "";
        if (null == pTestsetName) {
            // empty if block
        }
    }

    public void processTestcaseSkip(String pClassName, String pMethodName) {
        if (null == pClassName) {
            // empty if block
        }
        ++this.fCntTestcaseRunTask;
        ++this.fCntTestcaseRun;
        this.postRefreshProgressBar();
        this.postInfo(TextKeyGui.T313.getText() + pMethodName);
    }

    public void processTestcaseStart(String pClassName, String pMethodName) {
        if (null == pClassName) {
            // empty if block
        }
        this.postInfo(TextKeyGui.T314.getText() + pMethodName);
    }

    public void processTestcaseCompletion(String pClassName, String pMethodName) {
        ++this.fCntTestcaseRun;
        ++this.fCntTestcaseRunTask;
        this.postRefreshProgressBar();
        TestStatus okayStatus = new TestStatus(pClassName, pMethodName);
        if (this.fStatusVector.contains(okayStatus)) {
            return;
        }
        okayStatus.setStatus(22);
        this.fStatusVector.add(okayStatus);
        this.postTestcaseCompletion(okayStatus);
    }

    public void processFailure(String pTestsetName, String pTestcaseName, int pRemoteStatus, String pTrace) {
        if (null == pTestsetName || 0 == pTestsetName.length()) {
            pTestcaseName = "TestcaseUnknown";
            pTestsetName = "TestsetUnknown";
            pRemoteStatus = 1;
            pTestsetName = null == this.fLastTestsetName || 0 == this.fLastTestsetName.length() ? "TestsetUnknown" : this.fLastTestsetName;
        }
        TestStatus testStatus = new TestStatus(pTestsetName, pTestcaseName);
        this.fStatusVector.add(testStatus);
        testStatus.setTrace(pTrace);
        if (2 == pRemoteStatus) {
            ++this.fCntFlops;
            testStatus.setStatus(33);
        } else if (3 == pRemoteStatus) {
            ++this.fCntWarnings;
            testStatus.setStatus(44);
        } else {
            ++this.fCntWarnings;
            testStatus.setStatus(44);
        }
        this.postTestcaseCompletion(testStatus);
        this.postShowTestResultsView();
    }

    public void startTestRunListening(IJavaProject pJavaProject, int pPort, ILaunch pLaunch) {
        this.fJavaProject = pJavaProject;
        this.fLaunchMode = pLaunch.getLaunchMode();
        String msg = TextKeyGui.T320.getText();
        this.showInformation(msg);
        this.postInfo(msg);
        if (null != this.fPeerHandle) {
            this.stopTest();
        }
        this.fPeerHandle = new ListenerPeer();
        this.fPeerHandle.startListenerThread((IEvaluation)this, pPort);
        this.setTitle(this.computeTitle(null));
        this.setTitleToolTip(this.fJavaProject.getElementName());
    }

    private String computeTitle(String pVersion) {
        String projectName = null != this.fJavaProject ? this.fJavaProject.getElementName() : "";
        if (null == pVersion) {
            return "JVer: " + projectName;
        }
        return "Jver (" + pVersion + "):" + projectName;
    }

    private IStatusLineManager getStatusLine() {
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    public IJavaProject getLaunchedProject() {
        return this.fJavaProject;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public synchronized void dispose() {
        if (!this.fIsDisposed) {
            this.fIsDisposed = true;
            this.stopTest();
        }
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fProgressPanel.isDisposed();
    }

    private void start(int total) {
        this.resetProgressBar(total);
        this.fProgressPanel.setTestTotal(total);
        this.fProgressPanel.setTestsetCount(0);
        this.fProgressPanel.setWarningCount(0);
        this.fProgressPanel.setFlopCount(0);
    }

    private void resetProgressBar(int pTotalTestsets) {
        this.fProgressBar.setMinimum(0);
        this.fProgressBar.setSelection(0);
        this.fProgressBar.setForeground(this.getDisplay().getSystemColor(5));
        this.fProgressBar.setMaximum(pTotalTestsets * 20);
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void postAsyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    protected Display getDisplay() {
        if (null == this.fProgressPanel || this.fProgressPanel.isDisposed()) {
            return Plugin.getDisplay();
        }
        return this.fProgressPanel.getDisplay();
    }

    private void aboutToStart() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!JverBaseView.this.isDisposed()) {
                    Enumeration e = JverBaseView.this.fStatusViewVector.elements();
                    while (e.hasMoreElements()) {
                        IStatusView v = (IStatusView)e.nextElement();
                        v.aboutToStart();
                    }
                }
            }
        });
    }

    public void postTestsetStart(final String pTestsetName) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.refreshProgressBarPosted();
                Enumeration e = JverBaseView.this.fStatusViewVector.elements();
                while (e.hasMoreElements()) {
                    IStatusView v = (IStatusView)e.nextElement();
                    v.addTestset(pTestsetName);
                }
            }
        });
    }

    private void postTestcaseCompletion(final TestStatus pTestStatus) {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.refreshProgressPanelPosted();
                Enumeration e = JverBaseView.this.fStatusViewVector.elements();
                while (e.hasMoreElements()) {
                    IStatusView v = (IStatusView)e.nextElement();
                    v.addStatus(pTestStatus);
                }
                JverBaseView.this.refreshProgressPanelPosted();
            }
        });
    }

    private void postTestcaseFailure(final TestStatus pTestStatus) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.refreshProgressPanelPosted();
                Enumeration e = JverBaseView.this.fStatusViewVector.elements();
                while (e.hasMoreElements()) {
                    IStatusView v = (IStatusView)e.nextElement();
                    v.addStatus(pTestStatus);
                }
            }
        });
    }

    public void postRefreshProgressBar() {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.refreshProgressBarPosted();
            }
        });
    }

    private void refreshProgressBarPosted() {
        int posTestset = this.fCntTestsetRun * 20;
        if (0 > posTestset) {
            posTestset = 0;
        }
        if (this.fCntTestcaseRun > this.fUprTestcaseRun) {
            this.fUprTestcaseRun = this.fUprTestcaseRun;
        }
        float posTestcaseFloat = ((float)this.fCntTestcaseRun + 0.1f) / (float)this.fUprTestcaseRun * 20.0f;
        int posTestcase = (int)posTestcaseFloat;
        this.fProgressBar.setSelection(posTestset + posTestcase);
        this.fProgressBar.update();
    }

    private void refreshProgressPanelPosted() {
        this.fProgressPanel.setFlopCount(this.fCntFlops);
        this.fProgressPanel.setWarningCount(this.fCntWarnings);
        this.fProgressPanel.setTestsetCount(this.fCntTestsetRun);
        this.updateProgressBarColor(this.fCntWarnings + this.fCntFlops);
        this.fProgressBar.redraw();
    }

    private void updateProgressBarColor(int pNumFailures) {
        if (this.fJobError) {
            this.fProgressBar.setForeground(this.getDisplay().getSystemColor(4));
        } else if (0 < pNumFailures) {
            this.fProgressBar.setForeground(this.getDisplay().getSystemColor(3));
        } else {
            this.fProgressBar.setForeground(this.getDisplay().getSystemColor(5));
        }
    }

    protected void postShowTestResultsView() {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.showBaseView();
            }
        });
    }

    public void showBaseView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            page.showView(ECLIPSE_ID_BASEVIEW);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)TextKeyGui.T306.getText(), (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    protected void showInformation(final String pInfoText) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!JverBaseView.this.isDisposed()) {
                    JverBaseView.this.fStacktraceView.setInformation(pInfoText);
                }
            }
        });
    }

    private CTabFolder createResultViews(Composite parentComposite) {
        CTabFolder tabFolder = new CTabFolder(parentComposite, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        StatusViewPlain plainView = new StatusViewPlain(tabFolder, this);
        StatusViewTree treeView = new StatusViewTree(tabFolder, this);
        this.fStatusViewVector.addElement(plainView);
        this.fStatusViewVector.addElement(treeView);
        tabFolder.setSelection(0);
        this.fActiveStatusView = (IStatusView)this.fStatusViewVector.firstElement();
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JverBaseView.this.statusViewChanged(event);
            }
        });
        return tabFolder;
    }

    private void statusViewChanged(SelectionEvent event) {
        Enumeration e = this.fStatusViewVector.elements();
        while (e.hasMoreElements()) {
            IStatusView v = (IStatusView)e.nextElement();
            if (((CTabFolder)event.widget).getSelection().getText() != v.getName() || v == this.fActiveStatusView) continue;
            if (null != this.fActiveStatusView) {
                v.setSelectedStatus(this.fActiveStatusView.getSelectedStatus());
            }
            this.fActiveStatusView = v;
            this.fActiveStatusView.activate();
        }
    }

    private SashForm createSashForm(Composite parent) {
        SashForm sashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)sashForm, 0);
        CTabFolder tabFolder = this.createResultViews((Composite)top);
        tabFolder.setLayoutData((Object)new CustomTabLayout());
        top.setContent((Control)tabFolder);
        ViewForm bottom = new ViewForm((Composite)sashForm, 0);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fStacktraceView = new StacktraceView((Composite)bottom, this);
        bottom.setContent((Control)this.fStacktraceView.getComposite());
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText(TextKeyGui.T307.getText());
        label.setImage(IconKeyGui.BV_STACKTRACE.create(this.getDisplay()));
        bottom.setTopLeft((Control)label);
        ToolBarManager failureToolBarmanager = new ToolBarManager(failureToolBar);
        failureToolBarmanager.add((IAction)new UseStacktraceFilerAction(this.fStacktraceView));
        failureToolBarmanager.update(true);
        sashForm.setWeights(new int[]{60, 40});
        return sashForm;
    }

    private void reset(final int pNumberOfTests) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.fProgressPanel.resetCounters();
                JverBaseView.this.fStacktraceView.clear();
                JverBaseView.this.clearStatus();
                JverBaseView.this.start(pNumberOfTests);
            }
        });
        this.fCntTestcaseRun = 0;
        this.fCntTestcaseRunTask = 0;
        this.fNumTestset = pNumberOfTests;
        this.fCntTestsetRun = 0;
        this.fCntFlops = 0;
        this.fCntWarnings = 0;
        this.fJobError = false;
        this.aboutToStart();
        this.fStatusVector.clear();
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    public void setFocus() {
        this.fProgressBar.setFocus();
    }

    public void createPartControl(Composite parentComposite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        parentComposite.setLayout((Layout)gridLayout);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)new StopAction());
        actionBars.updateActionBars();
        Composite progressPanel = this.createProgressPanel(parentComposite);
        progressPanel.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parentComposite);
        sashForm.setLayoutData((Object)new GridData(1808));
        actionBars.setGlobalActionHandler("copy", (IAction)new CopyStacktraceAction(this.fStacktraceView));
    }

    private Composite createProgressPanel(Composite parentComposite) {
        Composite composite = new Composite(parentComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        this.fProgressBar = new ProgressBar(composite, 256);
        this.fProgressBar.setLayoutData((Object)new GridData(768));
        this.fProgressPanel = new ProgressPanel(composite);
        this.fProgressPanel.setLayoutData(new GridData(768));
        return composite;
    }

    public boolean containsStatus(TestStatus pStatus) {
        Enumeration e = this.fStatusVector.elements();
        while (e.hasMoreElements()) {
            TestStatus curStatus = (TestStatus)e.nextElement();
            if (pStatus != curStatus) continue;
            return true;
        }
        return false;
    }

    public TestStatus getFirstStatus(String pTestcaseName) {
        int index = this.fStatusVector.indexOf(pTestcaseName);
        if (0 > index) {
            return null;
        }
        return (TestStatus)this.fStatusVector.elementAt(index);
    }

    public void handleStatusSelected(TestStatus pStatus) {
        if (null != pStatus && pStatus.isTestcase()) {
            this.showFailure(pStatus.getTrace());
        } else {
            this.showFailure("");
        }
    }

    private void showMessage(String pMessage) {
        this.showInformation(pMessage);
        this.postError(pMessage);
    }

    protected void postInfo(final String pMessage) {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.getStatusLine().setErrorMessage(null);
                JverBaseView.this.getStatusLine().setMessage(pMessage);
            }
        });
    }

    protected void postError(final String message) {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (JverBaseView.this.isDisposed()) {
                    return;
                }
                JverBaseView.this.getStatusLine().setMessage(null);
                JverBaseView.this.getStatusLine().setErrorMessage(message);
            }
        });
    }

    private String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (null != event) {
            this.firePropertyChange(1);
        }
    }

    private class StopAction
    extends Action {
        public StopAction() {
            this.setText(TextKeyGui.T300.getText());
            this.setToolTipText(TextKeyGui.T300.getText());
            this.setImageDescriptor(IconKeyGui.BV_DO_STOP.createDescriptor());
        }

        public void run() {
            JverBaseView.this.stopTest();
        }
    }
}

