/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.generation.console;

import com.sap.dictionary.tools.generation.Generation;
import com.sap.ide.generationfwk.naming.NamingGenerationUnitFile;
import com.sap.ide.generationfwk.naming.NamingServiceBase;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.exception.ValidationException;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GenerationConsole
extends Generation {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$dictionary$tools$generation$console$GenerationConsole == null ? (class$com$sap$dictionary$tools$generation$console$GenerationConsole = GenerationConsole.class$("com.sap.dictionary.tools.generation.console.GenerationConsole")) : class$com$sap$dictionary$tools$generation$console$GenerationConsole).getName());
    public static final String COMMAND_PARAMETER_CFG_FILE = "-cfgfile";
    public static final String COMMAND_PARAMETER_HELP = "-help";
    public static final String COMMAND_PARAMETER_TEST = "-test";
    public static final String COMMAND_PARAMETER_SOURCEPATH = "-sourcepath";
    public static final String COMMAND_PARAMETER_TARGETPATH = "-d";
    public static final String COMMAND_PARAMETER_PACKAGE = "-package";
    public static final String COMMAND_PARAMETER_ARCHIVE_NAME = "-archivename";
    public static final String COMMAND_PARAMETER_DB_TABLE = "-dbtable";
    public static final String COMMAND_PARAMETER_DEPLOYMENT = "-deployment";
    public static final String COMMAND_PARAMETER_DC_NAME = "-dcname";
    public static final String COMMAND_PARAMETER_NO_CHECK = "-nocheck";
    public static final String COMMAND_PARAMETER_NO_FOLDER_STRUCTURE = "-nofolderstructure";
    public static final String COMMAND_PARAMETER_SIMPLE_TYPE = "-simpletype";
    public static final String COMMAND_PARAMETER_STRUCTURE = "-structure";
    public static final String COMMAND_PARAMETER_ADDPATHS = "-addpaths";
    public static final String COMMAND_PARAMETER_LANGUAGE = "-language";
    public static final String COMMAND_PARAMETER_VENDOR = "-vendor";
    public static final String COMMAND_PARAMETER_JARM_LEVEL = "-jarm";
    public static final String PARAMETER_VALUE_ALL = "+";
    private String mCfgFile = "DictionaryGenerationConfiguration.xml";
    private String mSourcePath = "";
    private String mPackage = "";
    private String mArchiveName = "";
    private String mDbTable = "";
    private boolean mDeployment = false;
    private String mDcName = "";
    private boolean mNoCheck = false;
    private boolean mNoFolderStructure = false;
    private String mSimpleType = "";
    private String mStructure = "";
    private String mAddPaths = "";
    private String mLanguage = "";
    private String mVendor = "";
    private boolean mHelp = false;
    private DtDictionaryRoot mDictionaryRoot = null;
    static /* synthetic */ Class class$com$sap$dictionary$tools$generation$console$GenerationConsole;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;

    private GenerationConsole() {
        this(1);
    }

    protected GenerationConsole(int environment) {
        this(environment, "DictionaryGenerationConfiguration.xml");
    }

    protected GenerationConsole(int environment, String templateConfigurationFile) {
        super(environment, templateConfigurationFile);
    }

    public static void main(String[] args) {
        long lStaringTime = System.currentTimeMillis();
        GenerationConsole lGenerator = new GenerationConsole();
        lGenerator.generate(args);
        long lEndingTime = System.currentTimeMillis();
        if (Generation.isErrorIndicator()) {
            lGenerator.printMessage(2, "Generation failed due to errors (" + (lEndingTime - lStaringTime) / 1000L + " seconds)");
        } else {
            lGenerator.printMessage(1, "Generation finished (" + (lEndingTime - lStaringTime) / 1000L + " seconds)");
        }
        lGenerator.cleanup();
    }

    protected final void generate(String[] args) {
        this.setIncremental(false);
        this.setErrorIndicator(false);
        this.scanCommandLine(args);
        if (this.isHelp()) {
            this.printHelp();
            return;
        }
        this.getNamingService().isFolderStructure(!this.isNoFolderStructure());
        try {
            block14: {
                try {
                    int i;
                    this.refreshConfiguration();
                    if (this.getSimpleType() != null && this.getSimpleType().length() > 0) {
                        this.createDictionaryRoot(this.getSourcePath(), this.getAddPaths());
                        DtSimpleType[] lSimpleTypes = this.instantiateSimpleTypes();
                        if (lSimpleTypes != null && lSimpleTypes.length > 0) {
                            i = 0;
                            while (i < lSimpleTypes.length) {
                                this.generatePersistentSimpleType(lSimpleTypes[i], !this.isNoCheck());
                                ++i;
                            }
                        }
                    }
                    if (this.getStructure() != null && this.getStructure().length() > 0) {
                        this.createDictionaryRoot(this.getSourcePath(), this.getAddPaths());
                        DtGeneralStructure[] lStructures = this.instantiateStructures();
                        if (lStructures != null && lStructures.length > 0) {
                            i = 0;
                            while (i < lStructures.length) {
                                this.generatePersistentStructure(lStructures[i], !this.isNoCheck());
                                ++i;
                            }
                        }
                    }
                    if (this.getDbTable() != null && this.getDbTable().length() > 0) {
                        this.createDictionaryRoot(this.getSourcePath(), this.getAddPaths());
                        DtDbTable[] lDbTables = this.instantiateDbTables();
                        if (lDbTables != null && lDbTables.length > 0) {
                            i = 0;
                            while (i < lDbTables.length) {
                                this.generatePersistentDbTable(lDbTables[i], !this.isNoCheck());
                                ++i;
                            }
                        }
                    }
                    if (!this.isDeployment()) break block14;
                    this.createDictionaryRoot(this.getSourcePath(), this.getAddPaths());
                    this.generatePersistentArchive(this.getArchiveName(), this.getVendor(), this.getDcName(), this.getDictionaryRoot().getLogicalDictionaries(), this.getDictionaryRoot().getSimpleTypes(), this.getDictionaryRoot().getStructures(), this.getDictionaryRoot().getTables(), this.getLanguages(this.getLanguage()), !this.isNoCheck());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TRACE_LOCATION.catching((Throwable)ex);
                    this.printMessage(2, "Unknown exception during generation " + ex.getMessage() + " (" + ex.toString() + ")");
                    Object var5_6 = null;
                    this.shutDownMetamodel();
                }
            }
            Object var5_5 = null;
            this.shutDownMetamodel();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.shutDownMetamodel();
            throw throwable;
        }
    }

    private void shutDownMetamodel() {
        if (this.getDictionaryRoot() != null) {
            try {
                this.getDictionaryRoot().getMetamodel().shutDown();
            }
            catch (Exception e) {
                TRACE_LOCATION.catching((Throwable)e);
                e.printStackTrace();
            }
            this.setDictionaryRoot(null);
        }
        if (!I18NService.getInstance().isCodepageValidationEnabled()) {
            I18NService.getInstance().enableCodepageValidation();
        }
    }

    private DtSimpleType[] instantiateSimpleTypes() {
        if (this.getDictionaryRoot() == null) {
            return new DtSimpleType[0];
        }
        DtSimpleType[] lSimpleTypes = new DtSimpleType[]{};
        try {
            if (this.getPackage().trim().equals(PARAMETER_VALUE_ALL) && this.getSimpleType().trim().equals(PARAMETER_VALUE_ALL)) {
                DtSimpleType[] lAllSimpleTypes = this.getDictionaryRoot().getSimpleTypes();
                ArrayList<DtSimpleType> lSourceObjectList = new ArrayList<DtSimpleType>();
                int i = 0;
                while (i < lAllSimpleTypes.length) {
                    if (!lAllSimpleTypes[i].originatesInArchive()) {
                        lSourceObjectList.add(lAllSimpleTypes[i]);
                    }
                    ++i;
                }
                lSimpleTypes = new DtSimpleType[lSourceObjectList.size()];
                lSimpleTypes = lSourceObjectList.toArray(lSimpleTypes);
            } else {
                lSimpleTypes = this.getSimpleType().trim().equals(PARAMETER_VALUE_ALL) ? this.getDictionaryRoot().getSimpleTypes(this.getPackage()) : new DtSimpleType[]{this.getDictionaryRoot().getSimpleType(this.getPackage(), this.getSimpleType())};
            }
        }
        catch (LoadException ex) {
            this.printMessage(2, "SimpleType " + this.getSimpleType() + " could not be instantiated by the MetadataAPI, " + ex.getMessage() + "\n    sourcepath: " + this.getSourcePath() + "\n    package:    " + this.getPackage() + "\n    cause:      " + ex.getCause());
            return null;
        }
        int i = 0;
        while (i < lSimpleTypes.length) {
            if (lSimpleTypes[i] == null) {
                this.printMessage(2, "SimpleType " + this.getSimpleType() + " could not be instantiated by the MetadataAPI");
            } else {
                try {
                    lSimpleTypes[i].validate();
                }
                catch (ValidationException e) {
                    this.printMessage(3, "Metadata of simpleType " + lSimpleTypes[i].getName() + " is not valid! " + e.getMessage());
                }
            }
            ++i;
        }
        return lSimpleTypes;
    }

    private DtGeneralStructure[] instantiateStructures() {
        if (this.getDictionaryRoot() == null) {
            return new DtGeneralStructure[0];
        }
        DtGeneralStructure[] lStructures = new DtGeneralStructure[]{};
        try {
            if (this.getPackage().trim().equals(PARAMETER_VALUE_ALL) && this.getStructure().trim().equals(PARAMETER_VALUE_ALL)) {
                DtGeneralStructure[] lAllStructures = this.getDictionaryRoot().getStructures();
                ArrayList<DtGeneralStructure> lSourceObjectList = new ArrayList<DtGeneralStructure>();
                int i = 0;
                while (i < lAllStructures.length) {
                    if (!lAllStructures[i].originatesInArchive()) {
                        lSourceObjectList.add(lAllStructures[i]);
                    }
                    ++i;
                }
                lStructures = new DtGeneralStructure[lSourceObjectList.size()];
                lStructures = lSourceObjectList.toArray(lStructures);
            } else {
                lStructures = this.getStructure().trim().equals(PARAMETER_VALUE_ALL) ? this.getDictionaryRoot().getStructures(this.getPackage()) : new DtGeneralStructure[]{this.getDictionaryRoot().getStructure(this.getPackage(), this.getStructure())};
            }
        }
        catch (LoadException ex) {
            this.printMessage(2, "Structure " + this.getStructure() + " could not be instantiated by the MetadataAPI, " + ex.getMessage() + "\n    sourcepath: " + this.getSourcePath() + "\n    package:    " + this.getPackage() + "\n    cause:      " + ex.getCause());
            return null;
        }
        int i = 0;
        while (i < lStructures.length) {
            if (lStructures[i] == null) {
                this.printMessage(2, "Structure " + this.getStructure() + " could not be instantiated by the MetadataAPI");
            } else {
                try {
                    lStructures[i].validate();
                }
                catch (ValidationException e) {
                    this.printMessage(3, "Metadata of structure " + lStructures[i].getName() + " is not valid! " + e.getMessage());
                }
            }
            ++i;
        }
        return lStructures;
    }

    private DtDbTable[] instantiateDbTables() {
        if (this.getDictionaryRoot() == null) {
            return new DtDbTable[0];
        }
        DtDbTable[] lDbTables = new DtDbTable[]{};
        try {
            if (this.getPackage().trim().equals(PARAMETER_VALUE_ALL) && this.getDbTable().trim().equals(PARAMETER_VALUE_ALL)) {
                DtDbTable[] lAllDbTables = this.getDictionaryRoot().getTables();
                ArrayList<DtDbTable> lSourceObjectList = new ArrayList<DtDbTable>();
                int i = 0;
                while (i < lAllDbTables.length) {
                    if (!lAllDbTables[i].originatesInArchive()) {
                        lSourceObjectList.add(lAllDbTables[i]);
                    }
                    ++i;
                }
                lDbTables = new DtDbTable[lSourceObjectList.size()];
                lDbTables = lSourceObjectList.toArray(lDbTables);
            } else {
                lDbTables = this.getDbTable().trim().equals(PARAMETER_VALUE_ALL) ? this.getDictionaryRoot().getTables(this.getPackage()) : new DtDbTable[]{this.getDictionaryRoot().getTable(this.getPackage(), this.getDbTable())};
            }
        }
        catch (LoadException ex) {
            this.printMessage(2, "DbTable " + this.getDbTable() + " could not be instantiated by the MetadataAPI, " + ex.getMessage() + "\n    sourcepath: " + this.getSourcePath() + "\n    package:    " + this.getPackage() + "\n    cause:      " + ex.getCause());
            return null;
        }
        int i = 0;
        while (i < lDbTables.length) {
            if (lDbTables[i] == null) {
                this.printMessage(2, "DbTable " + this.getDbTable() + " could not be instantiated by the MetadataAPI");
            } else {
                try {
                    lDbTables[i].validate();
                }
                catch (ValidationException e) {
                    this.printMessage(3, "Metadata of dbTable " + lDbTables[i].getName() + " is not valid! " + e.getMessage());
                }
            }
            ++i;
        }
        return lDbTables;
    }

    private void scanCommandLine(String[] args) {
        if (args == null || args.length == 0) {
            this.setHelp(true);
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_HELP)) {
                this.setHelp(true);
                return;
            }
            if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_CFG_FILE)) {
                this.setCfgFile(args[++i]);
                this.getGenerationConfiguration().setConfigurationFile(this.getCfgFile());
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_TEST)) {
                this.setTestMode(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_SOURCEPATH)) {
                File lSourceDirectory;
                if (!(lSourceDirectory = new File(args[++i])).exists() || !lSourceDirectory.isDirectory()) {
                    this.printMessage(2, "Source directory " + lSourceDirectory.toString() + " does not exist");
                } else {
                    this.setSourcePath(lSourceDirectory.toString());
                }
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_TARGETPATH)) {
                File lTargetDirectory;
                if (!(lTargetDirectory = new File(args[++i])).exists()) {
                    this.printMessage(1, "Destination directory " + lTargetDirectory.toString() + " does not exist");
                    if (lTargetDirectory.mkdirs()) {
                        this.setTargetPath(lTargetDirectory.toString());
                        this.printMessage(1, "Destination directory " + lTargetDirectory.toString() + " is created");
                    } else {
                        this.setTargetPath(new File(".").toString());
                        this.printMessage(1, "Set local destination directory " + lTargetDirectory.toString());
                    }
                } else if (!lTargetDirectory.isDirectory()) {
                    this.printMessage(1, "Destination directory " + lTargetDirectory.toString() + " is not a directory");
                    this.setTargetPath(new File(".").toString());
                    this.printMessage(1, "Set local destination directory " + lTargetDirectory.toString());
                } else {
                    this.setTargetPath(lTargetDirectory.toString());
                }
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_NO_CHECK)) {
                this.setNoCheck(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_NO_FOLDER_STRUCTURE)) {
                this.setNoFolderStructure(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_PACKAGE)) {
                this.setPackage(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_ARCHIVE_NAME)) {
                this.setArchiveName(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_SIMPLE_TYPE)) {
                this.setSimpleType(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_STRUCTURE)) {
                this.setStructure(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_DB_TABLE)) {
                this.setDbTable(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_DEPLOYMENT)) {
                this.setDeployment(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_VENDOR)) {
                this.setVendor(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_DC_NAME)) {
                this.setDcName(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_ADDPATHS)) {
                this.setAddPaths(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_LANGUAGE)) {
                this.setLanguage(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_JARM_LEVEL)) {
                this.setJarmLevel(Integer.parseInt(args[++i]));
            } else if (args[i].startsWith("-")) {
                this.printMessage(2, "Illegal option " + args[i]);
            }
            ++i;
        }
        if (this.getSourcePath() == null || this.getSourcePath().length() == 0) {
            this.printMessage(1, "Set destination directory " + this.getTargetPath() + " as source directory");
            this.setSourcePath(this.getTargetPath());
        }
        if (!(this.getPackage() != null && this.getPackage().length() != 0 || this.getSimpleType() != null && this.getSimpleType().length() != 0 || this.getStructure() != null && this.getStructure().length() != 0 || this.getDbTable() != null && this.getDbTable().length() != 0)) {
            this.setPackage(PARAMETER_VALUE_ALL);
            this.setSimpleType(PARAMETER_VALUE_ALL);
            this.setStructure(PARAMETER_VALUE_ALL);
            this.setDbTable(PARAMETER_VALUE_ALL);
        }
        if (this.isTestMode()) {
            this.printCommandParameters();
        }
    }

    public final void printCommandParameters() {
        this.printMessage(1, "");
        this.printMessage(1, "test output: command parameters");
        this.printMessage(1, "  -cfgfile    : " + this.getCfgFile());
        this.printMessage(1, "  -sourcepath : " + this.getSourcePath());
        this.printMessage(1, "  -d          : " + this.getTargetPath());
        this.printMessage(1, "  -package    : " + this.getPackage());
        this.printMessage(1, "  -dbtable    : " + this.getDbTable());
        this.printMessage(1, "  -simpletype : " + this.getSimpleType());
        this.printMessage(1, "  -structure  : " + this.getStructure());
        this.printMessage(1, "  -deployment : " + this.isDeployment());
        this.printMessage(1, "  -archivename: " + this.getArchiveName());
        this.printMessage(1, "  -vendor     : " + this.getVendor());
        this.printMessage(1, "  -dcname     : " + this.getDcName());
        this.printMessage(1, "  -addpaths   : " + this.getAddPaths());
        this.printMessage(1, "  -language   : " + this.getLanguage());
        this.printMessage(1, "  -jarm       : " + this.getJarmLevel());
        this.printMessage(1, "");
    }

    public final void printHelp() {
        this.printMessage(1, "");
        this.printMessage(1, "usage: java com.sap.dictionary.tools.generation.GenerationConsole [-cfgfile <file>] [-help] [-test] -sourcepath <dir> -d <dir> -package <java package> [-simpletype <simpleTypeName>] [-structure <structureName>] [-dbtable <tableName>] [-deployment] [-archivename <archiveName>] [-vendor <vendor>] [-dcname <dcName>] [-addpaths <dir1>;<dir2>] [-language <language1>;<language2>]");
        this.printMessage(1, "");
        this.printMessage(1, "  -help                        display this message");
        this.printMessage(1, "  -test                        test mode");
        this.printMessage(1, "  -jarm       <level>          jarm instrumentation level (0,1, ... 10)");
        this.printMessage(1, "");
        this.printMessage(1, "  -cfgfile    <file>           generation configuration file");
        this.printMessage(1, "  -sourcepath <dir>            directory where design time repository files can be found");
        this.printMessage(1, "  -d          <dir>            directory where java files will be generated");
        this.printMessage(1, "  -package    <pkg>            root package");
        this.printMessage(1, "  -addpaths   <dir1>;<dir2>    list of directories where datatypes are located (separated by semikolon)");
        this.printMessage(1, "  -language   <language>       language of texts");
        this.printMessage(1, "");
        this.printMessage(1, "  -simpletype <simpleTypeName> Dictionary simple type name");
        this.printMessage(1, "  -structure  <structureName>  Dictionary structure name");
        this.printMessage(1, "  -dbtable    <tableName>      Dictionary table name");
        this.printMessage(1, "");
        this.printMessage(1, "  -deployment                 requests generation of deployment information");
        this.printMessage(1, "  -vendor      <vendor>       vendor name");
        this.printMessage(1, "  -archivename <archiveName>  name of deployable archive");
        this.printMessage(1, "  -dcname      <dcName>       name of development component");
        this.printMessage(1, "");
        this.printMessage(1, "");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myTypes/src -d c:/myType   -package com.sap.test.type -simpletype myType      -language en");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myTypes/src -d c:/myType   -package com.sap.test.type -structure  myStructure -language en");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myTypes/src -d c:/myType   -package com.sap.test.type -dbtable    myDbTable   -language de");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myTypes/src -d c:/myDeploy -deployment -vendor sap.com -archivename sap.com~bsp~mydd -language de;fr");
        this.printMessage(1, "");
    }

    private void setCfgFile(String cfgFile) {
        this.mCfgFile = cfgFile == null || cfgFile.length() == 0 ? "DictionaryGenerationConfiguration.xml" : cfgFile;
    }

    public String getCfgFile() {
        return this.mCfgFile;
    }

    private void setSourcePath(String sourcePath) {
        this.mSourcePath = sourcePath == null ? "" : NamingServiceBase.getNormalizedFileName((String)sourcePath);
    }

    public String getSourcePath() {
        return this.mSourcePath;
    }

    private void setPackage(String packageName) {
        this.mPackage = packageName == null ? "" : packageName;
    }

    public String getPackage() {
        return this.mPackage;
    }

    private void setArchiveName(String archiveName) {
        this.mArchiveName = archiveName == null ? "" : archiveName;
    }

    public final String getArchiveName() {
        return this.mArchiveName;
    }

    private void setVendor(String vendor) {
        this.mVendor = vendor == null ? "" : vendor;
    }

    public final String getVendor() {
        return this.mVendor;
    }

    private void setDcName(String dcName) {
        this.mDcName = dcName == null ? "" : dcName;
    }

    public final String getDcName() {
        return this.mDcName;
    }

    private void setLanguage(String language) {
        this.mLanguage = language == null ? "" : language;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    private void setAddPaths(String addPaths) {
        this.mAddPaths = addPaths == null ? "" : addPaths;
    }

    public String getAddPaths() {
        return this.mAddPaths;
    }

    private void setSimpleType(String simpleTypeName) {
        this.mSimpleType = simpleTypeName == null ? "" : simpleTypeName;
    }

    public String getSimpleType() {
        return this.mSimpleType;
    }

    private void setStructure(String structureName) {
        this.mStructure = structureName == null ? "" : structureName;
    }

    public String getStructure() {
        return this.mStructure;
    }

    private void setDbTable(String dbTableName) {
        this.mDbTable = dbTableName == null ? "" : dbTableName;
    }

    public String getDbTable() {
        return this.mDbTable;
    }

    public final boolean isDeployment() {
        return this.mDeployment;
    }

    private void setDeployment(boolean deployment) {
        this.mDeployment = deployment;
    }

    public final boolean isHelp() {
        return this.mHelp;
    }

    private void setHelp(boolean help) {
        this.mHelp = help;
    }

    public final boolean isNoCheck() {
        return this.mNoCheck;
    }

    private void setNoCheck(boolean noCheck) {
        this.mNoCheck = noCheck;
    }

    public final boolean isNoFolderStructure() {
        return this.mNoFolderStructure;
    }

    private void setNoFolderStructure(boolean noFolderStructure) {
        this.mNoFolderStructure = noFolderStructure;
    }

    private DtDictionaryRoot createDictionaryRoot(String rootPath, String addPaths) {
        if (this.getDictionaryRoot() == null) {
            try {
                I18NService.getInstance().disableCodepageValidation();
                Metamodel lMetamodel = new Metamodel("DataDictionary", rootPath, GenerationConsole.getAdditionalPaths(addPaths));
                String[] lAddArchives = GenerationConsole.getAdditionalArchivePaths(addPaths);
                int i = 0;
                while (i < lAddArchives.length) {
                    lMetamodel.addArchive(lAddArchives[i]);
                    ++i;
                }
                this.setDictionaryRoot((DtDictionaryRoot)lMetamodel.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = GenerationConsole.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot));
            }
            catch (MetamodelException e) {
                this.printMessage(2, "Could not initialize DataDictionary root, " + e.getMessage() + "\n    rootpath: " + this.getSourcePath());
            }
        }
        return this.getDictionaryRoot();
    }

    private static String[] splitParameterListString(String parameterList) {
        StringTokenizer lTokenizer = new StringTokenizer(parameterList, "\"';,", false);
        ArrayList<String> lParameterArrayList = new ArrayList<String>();
        while (lTokenizer.hasMoreTokens()) {
            lParameterArrayList.add(lTokenizer.nextToken());
        }
        String[] lParameterList = new String[]{};
        return lParameterArrayList.toArray(lParameterList);
    }

    private static String[] getAdditionalPaths(String addPaths) {
        String[] lAddPaths = GenerationConsole.splitParameterListString(addPaths);
        ArrayList<String> lPathsArrayList = new ArrayList<String>();
        int i = 0;
        while (i < lAddPaths.length) {
            if (!lAddPaths[i].toLowerCase().endsWith(".jar") && !lAddPaths[i].toLowerCase().endsWith(".zip")) {
                lPathsArrayList.add(lAddPaths[i]);
            }
            ++i;
        }
        lAddPaths = new String[lPathsArrayList.size()];
        return lPathsArrayList.toArray(lAddPaths);
    }

    private static String[] getAdditionalArchivePaths(String addPaths) {
        String[] lAddArchives = GenerationConsole.splitParameterListString(addPaths);
        ArrayList<String> lArchivesArrayList = new ArrayList<String>();
        int i = 0;
        while (i < lAddArchives.length) {
            if (lAddArchives[i].toLowerCase().endsWith(".jar") || lAddArchives[i].toLowerCase().endsWith(".zip")) {
                lArchivesArrayList.add(lAddArchives[i]);
            }
            ++i;
        }
        lAddArchives = new String[lArchivesArrayList.size()];
        return lArchivesArrayList.toArray(lAddArchives);
    }

    private String[] getLanguages(String languages) {
        String[] lLanguagesList = GenerationConsole.splitParameterListString(languages);
        if (lLanguagesList == null) {
            lLanguagesList = new String[]{};
        }
        return lLanguagesList;
    }

    private DtDictionaryRoot getDictionaryRoot() {
        return this.mDictionaryRoot;
    }

    private void setDictionaryRoot(DtDictionaryRoot dictionaryRoot) {
        this.mDictionaryRoot = dictionaryRoot;
    }

    protected final boolean isGeneration(DevelopmentObject devObject) {
        return !devObject.getMDO().originatesInArchive();
    }

    protected void showCheckResult(ArrayList infoMessages, ArrayList warningMessages, ArrayList errorMessages) {
        int i;
        super.showCheckResult(infoMessages, warningMessages, errorMessages);
        if (infoMessages != null) {
            i = 0;
            while (i < infoMessages.size()) {
                this.printMessage(1, ((String)infoMessages.get(i)).trim());
                ++i;
            }
        }
        if (warningMessages != null) {
            i = 0;
            while (i < warningMessages.size()) {
                this.printMessage(3, ((String)warningMessages.get(i)).trim());
                ++i;
            }
        }
        if (errorMessages != null) {
            i = 0;
            while (i < errorMessages.size()) {
                this.printMessage(2, ((String)errorMessages.get(i)).trim());
                ++i;
            }
        }
    }

    protected final String getGenerationUnitDisplayName(NamingGenerationUnitFile naming) {
        String lTargetPath = NamingServiceBase.getNormalizedFileName((String)this.getTargetPath());
        String lFilePath = NamingServiceBase.getNormalizedFileName((String)naming.getAbsoluteFilePath());
        if (lTargetPath == null || lTargetPath.length() == 0) {
            return lFilePath;
        }
        if (lFilePath.startsWith(lTargetPath)) {
            return lFilePath.substring(lTargetPath.length() + 1);
        }
        return lFilePath;
    }

    protected void cleanup() {
        super.cleanup();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

