/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.extension.AbstractProvider;

public final class ServletSecurityRoleProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isServletSecurityRoleLink(element.getUniqueName());
    }

    private boolean linkExists(UniqueName uin) {
        UniqueName roleUin = WebAppModelMetaInfo.getServletSecurityRoleLinkSecurityRole(uin);
        SecurityRole role = WebAppModelAccess.getSecurityRole(this.getModel(), roleUin);
        if (role == null) {
            return false;
        }
        Servlet servlet = WebAppModelAccess.getContainingServlet(this.getModel(), uin);
        if (servlet == null) {
            return false;
        }
        return role.getName().equals(servlet.getRunAsRoleName());
    }

    public boolean isDeleted(Element element) {
        return !this.linkExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isServletSecurityRoleLink(uin)) {
            return false;
        }
        return this.linkExists(uin);
    }

    private SecurityRole readLink(Entity template) {
        ElementEnumeration roleEnum = template.participants("Supplier");
        if (!roleEnum.hasMoreElements()) {
            return null;
        }
        Element roleElement = roleEnum.next();
        UniqueName roleUin = roleElement.getUniqueName();
        if (!WebAppModelMetaInfo.isSecurityRole(roleUin)) {
            return null;
        }
        return WebAppModelAccess.getSecurityRole(this.getModel(), roleUin);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        if (!"com.tssap.j2ee.core.webapp.SecurityRoleLink".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isServlet(parent.getUniqueName()) && !WebAppModelMetaInfo.isJsp(parent.getUniqueName())) {
            return false;
        }
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        if (servlet == null) {
            return false;
        }
        WebApp webApp = (WebApp)servlet.getParent();
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            return false;
        }
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            link = servlet.getRunAsRoleName();
            if (link != null) {
                return false;
            }
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            link = template.getPropertyValue("roleLink");
            SecurityRole linkedRole = this.readLink(template);
            if (linkedRole != null) {
                link = linkedRole.getName();
            }
            if (link == null || link.trim().length() == 0) {
                return false;
            }
        }
        return servlet.canSetRunAsRoleName(link);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            link = template.getPropertyValue("roleLink");
            SecurityRole linkedRole = this.readLink(template);
            if (linkedRole != null) {
                link = linkedRole.getName();
            }
        }
        servlet.setRunAsRoleName(link);
        WebApp webApp = (WebApp)servlet.getParent();
        return WebAppModelMetaInfo.getServletSecurityRoleLink(webApp.getFile(), link, servlet.getName());
    }

    public boolean canDelete(Element element) {
        Servlet servlet = WebAppModelAccess.getContainingServlet(this.getModel(), element.getUniqueName());
        if (servlet == null) {
            return false;
        }
        return servlet.canSetRunAsRoleName(null);
    }

    public void delete(Element element) {
        Servlet servlet = WebAppModelAccess.getContainingServlet(this.getModel(), element.getUniqueName());
        servlet.setRunAsRoleName(null);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isServlet(parent.getUniqueName()) || WebAppModelMetaInfo.isJsp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        if (servlet == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        String roleName = servlet.getRunAsRoleName();
        if (roleName == null || roleName.trim().length() == 0) {
            servlet.setUserData((Object)"deltaSecurityRole", null);
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebApp webApp = (WebApp)servlet.getParent();
        UniqueName roleUin = WebAppModelMetaInfo.getSecurityRole(webApp.getFile(), roleName);
        SecurityRole role = WebAppModelAccess.getSecurityRole(this.getModel(), roleUin);
        if (role == null) {
            servlet.setUserData((Object)"deltaSecurityRole", null);
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        UniqueName uin = WebAppModelMetaInfo.getServletSecurityRoleLink(webApp.getFile(), roleName, servlet.getName());
        servlet.setUserData((Object)"deltaSecurityRole", (Object)uin);
        return SingleEnumeration.createUniqueNameEnumeration((UniqueName)uin);
    }
}

